/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.actions;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectUtils;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import javafx.stage.Window;

public final class SaveProjectAsAction
extends PkgMgrAction {
    public SaveProjectAsAction(PkgMgrFrame pmf) {
        super(pmf, "menu.package.saveAs");
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        pmf.menuCall();
        this.saveAs(pmf, pmf.getProject());
    }

    public void saveAs(PkgMgrFrame frame, Project project) {
        File newName = FileUtility.getSaveProjectFX(project, (Window)frame.getWindow(), Config.getString("pkgmgr.saveAs.title"));
        if (newName == null) {
            return;
        }
        try {
            project.saveAll();
            project.saveAllEditors();
        }
        catch (IOException ioe) {
            DialogManager.showErrorFX((Window)frame.getWindow(), "cannot-save-project");
            return;
        }
        if (!ProjectUtils.saveProjectCopy(project, newName, frame.getWindow())) {
            return;
        }
        PkgMgrFrame.closeProject(project);
        Project openProj = Project.openProject(newName.getAbsolutePath());
        if (openProj != null) {
            Package pkg = openProj.getPackage("");
            PkgMgrFrame pmf = PkgMgrFrame.createFrame(pkg, null);
            pmf.setVisible(true);
        } else {
            Debug.message("Save as: could not open package under new name");
        }
    }
}

