/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.print;

import bluej.editor.flow.PrintDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.print.PrintProgressDialog;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.utility.Debug;
import bluej.utility.javafx.FXRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.print.PrinterJob;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PackagePrintManager
extends Thread {
    private final PrintProgressDialog printProgressDialog;
    private final List<FXRunnable> printActions = new ArrayList<FXRunnable>();
    private final PrinterJob job;

    @OnThread(value=Tag.FXPlatform)
    public PackagePrintManager(PrinterJob job, PkgMgrFrame pkgMgrFrame, PrintDialog.PrintChoices printChoices) {
        super("Package Print");
        ReadmeTarget readmeTgt;
        this.printProgressDialog = new PrintProgressDialog((Window)pkgMgrFrame.getWindow(), true);
        this.job = job;
        if (printChoices.printDiagram) {
            this.printActions.add(() -> this.printClassDiagram(job, pkgMgrFrame));
        }
        Package pkg = pkgMgrFrame.getPackage();
        if (printChoices.printSource) {
            this.printActions.addAll(pkg.getAllClassnamesWithSource().stream().map(className -> ((ClassTarget)pkg.getTarget((String)className)).getEditor()).map(ed -> ed.printTo(job, printChoices.printSize, printChoices.printLineNumbers, printChoices.printHighlighting, this.printProgressDialog.getWithinFileUpdater())).collect(Collectors.toList()));
        }
        if (printChoices.printReadme && (readmeTgt = pkg.getReadmeTarget()) != null && readmeTgt.getEditor() != null) {
            this.printActions.add(readmeTgt.getEditor().printTo(job, printChoices.printSize, printChoices.printLineNumbers, printChoices.printHighlighting, this.printProgressDialog.getWithinFileUpdater()));
        }
    }

    @Override
    @OnThread(value=Tag.FX, ignoreParent=true)
    public void run() {
        try {
            for (int i = 0; i < this.printActions.size(); ++i) {
                FXRunnable printAction = this.printActions.get(i);
                if (this.printProgressDialog.setMultiFileProgress(i, this.printActions.size())) {
                    printAction.run();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            Debug.reportError(t);
        }
        this.job.endJob();
        this.printProgressDialog.finished();
    }

    @OnThread(value=Tag.FX)
    public void printClassDiagram(PrinterJob printJob, PkgMgrFrame pkgMgrFrame) {
        pkgMgrFrame.printDiagram(printJob);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showDialogAndWait() {
        this.printProgressDialog.showAndWait();
    }
}

