/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.flow.FlowEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.NonCodeEditableTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.actions.EditAction;
import bluej.utility.Debug;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ReadmeTarget
extends NonCodeEditableTarget {
    private static final String openStr = Config.getString("pkgmgr.packagemenu.open");
    public static final String README_ID = "@README";
    private static @OnThread(value=Tag.FXPlatform) Image readmeImage;
    private static @OnThread(value=Tag.FXPlatform) Image selectedReadmeImage;
    private @OnThread(value=Tag.FXPlatform) ImageView imageView;

    public ReadmeTarget(Package pkg) {
        super(pkg, README_ID, "");
        if (readmeImage == null) {
            readmeImage = Config.getImageAsFXImage("image.readme");
        }
        if (selectedReadmeImage == null) {
            selectedReadmeImage = Config.getImageAsFXImage("image.readme-selected");
        }
        this.setPos(10, 10);
        this.setSize((int)readmeImage.getWidth(), (int)readmeImage.getHeight());
        JavaFXUtil.addStyleClass((Styleable)this.pane, "readme-target");
        this.pane.setTop(null);
        this.imageView = new ImageView();
        this.imageView.setImage(readmeImage);
        this.pane.setCenter((Node)this.imageView);
    }

    @Override
    public void load(Properties props, String prefix) throws NumberFormatException {
    }

    @Override
    public File getSourceFile() {
        return new File(this.getPackage().getPath(), "README.TXT");
    }

    @Override
    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return false;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isSaveable() {
        return false;
    }

    @Override
    public Editor getEditor() {
        if (this.editor == null) {
            FlowEditor flowEditor = new FlowEditor(newWindow -> {
                if (newWindow) {
                    return this.getPackage().getProject().createNewFXTabbedEditor();
                }
                return this.getPackage().getProject().getDefaultFXTabbedEditor();
            }, this.getSourceFile().getName(), (EditorWatcher)this, null, null, () -> {}, (BooleanExpression)new ReadOnlyBooleanWrapper(false), false);
            flowEditor.showFile(this.getSourceFile().getAbsolutePath(), StandardCharsets.UTF_8, false, null);
            this.editor = flowEditor;
        }
        return this.editor;
    }

    private void openEditor(boolean openInNewWindow) {
        if (this.editor == null && !this.getSourceFile().exists()) {
            try {
                this.getSourceFile().createNewFile();
            }
            catch (IOException ioe) {
                Debug.reportError("Couldn't open README", ioe);
            }
        }
        if (this.getEditor() != null) {
            this.editor.setEditorVisible(true, openInNewWindow);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick(boolean openInNewWindow) {
        this.openEditor(openInNewWindow);
    }

    @Override
    public List<? extends AbstractOperation<Target>> getContextOperations() {
        return List.of(new EditAction());
    }

    @Override
    public void remove() {
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isMoveable() {
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.imageView.setImage(selected ? selectedReadmeImage : readmeImage);
    }
}

