/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.actions;

import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.javafx.AbstractOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class EditableTargetOperation
extends AbstractOperation<Target> {
    private final AbstractOperation.MenuItemOrder menuItemOrder;
    private final List<String> styleClasses;
    private final String label;

    public EditableTargetOperation(String identifier, AbstractOperation.Combine combine, KeyCombination shortcut, String label, AbstractOperation.MenuItemOrder menuItemOrder, String ... styleClasses) {
        super(identifier, combine, shortcut);
        this.label = label;
        this.menuItemOrder = menuItemOrder;
        this.styleClasses = Arrays.asList(styleClasses);
    }

    @Override
    public final void activate(List<Target> targets) {
        List<EditableTarget> editableTargets = targets.stream().flatMap(t -> t instanceof EditableTarget ? Stream.of((EditableTarget)t) : Stream.empty()).collect(Collectors.toList());
        if (!editableTargets.isEmpty() && this.confirm(editableTargets)) {
            for (EditableTarget target : editableTargets) {
                this.executeEditable(target);
            }
        }
    }

    protected boolean confirm(List<EditableTarget> editableTargets) {
        return true;
    }

    protected abstract void executeEditable(EditableTarget var1);

    @Override
    public final List<AbstractOperation.ItemLabel> getLabels() {
        return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(this.label), this.menuItemOrder));
    }

    @Override
    public List<String> getStyleClasses() {
        return this.styleClasses;
    }
}

