/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.Config;
import bluej.compiler.Diagnostic;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixSuggestion;
import bluej.editor.stride.FrameEditor;
import bluej.stride.framedjava.ast.CallExpressionSlotFragment;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.frames.TryFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UnreportedExceptionError
extends DirectSlotError {
    private final List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();
    private final String exceptionType;

    @OnThread(value=Tag.FX)
    public UnreportedExceptionError(SlotFragment slotFragment, int startErrorPos, FrameEditor editor, String exceptionType, Set<String> vars) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        this.exceptionType = exceptionType;
        String exceptionVarNameRoot = exceptionType.substring(exceptionType.lastIndexOf(".") + 1).replaceAll("[^A-Z]", "").toLowerCase();
        boolean foundVarName = false;
        int varSuffix = 0;
        Object exceptionVarName = exceptionVarNameRoot;
        do {
            if (!(foundVarName = vars.contains(exceptionVarName))) continue;
            exceptionVarName = exceptionVarNameRoot + ++varSuffix;
        } while (foundVarName);
        String finalExceptionVarName = exceptionVarName;
        String catchStrideExpression = (String)exceptionVarName + ".printStackTrace()";
        InteractionManager finalInteractionMgr = editor.getSource().getEditor();
        Frame errorFrame = ((CallExpressionSlotFragment)slotFragment).getSlot().getParentFrame();
        this.corrections.add((FixSuggestion)new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.unreportedException.fixMsg.trycatch"), () -> {
            List<CodeElement> elements = GreenfootFrameUtil.getElementsForMultipleFrames(Collections.singletonList(errorFrame));
            Frame errorFrameCopy = elements.get(0).createFrame(finalInteractionMgr);
            TryFrame newTryFrame = new TryFrame(finalInteractionMgr, Collections.singletonList(errorFrameCopy), Collections.singletonList(new TypeSlotFragment(exceptionType, exceptionType)), Collections.singletonList(new NameDefSlotFragment(finalExceptionVarName)), Collections.singletonList(Collections.singletonList(new CallFrame(finalInteractionMgr, catchStrideExpression, ""))), null, true);
            FrameContentRow currRow = (FrameContentRow)((CallExpressionSlotFragment)slotFragment).getSlot().getSlotParent();
            currRow.focusUp(((ExpressionSlotFragment)slotFragment).getSlot(), false);
            finalInteractionMgr.beginRecordingState(finalInteractionMgr.getFocusedCursor());
            finalInteractionMgr.getFocusedCursor().insertBlockBefore(newTryFrame);
            errorFrame.getParentCanvas().removeBlock(errorFrame);
            newTryFrame.getIntermediateCanvases().get(0).getFirstCursor().requestFocus();
            finalInteractionMgr.endRecordingState(finalInteractionMgr.getFocusedCursor());
        }));
        MethodFrameWithBody methodFrame = null;
        FrameCanvas c = errorFrame.getParentCanvas();
        while (c != null && c.getParent() != null && c.getParent().getFrame() != null) {
            if (c.getParent().getFrame() instanceof MethodFrameWithBody) {
                methodFrame = (MethodFrameWithBody)c.getParent().getFrame();
            }
            c = c.getParent().getFrame().getParentCanvas();
        }
        MethodFrameWithBody finalMethodFrame = methodFrame;
        this.corrections.add((FixSuggestion)new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.unreportedException.fixMsg.throws"), () -> finalMethodFrame.addThrows(exceptionType)));
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return Config.getString("editor.quickfix.unreportedException.errorMsg.part1") + this.exceptionType + Config.getString("editor.quickfix.unreportedException.errorMsg.part2");
    }

    @Override
    @OnThread(value=Tag.Any)
    public int getItalicMessageStartIndex() {
        return this.getMessage().indexOf(this.exceptionType);
    }

    @Override
    @OnThread(value=Tag.Any)
    public int getItalicMessageEndIndex() {
        return this.getMessage().indexOf(this.exceptionType) + this.exceptionType.length();
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }
}

