/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.InheritedFieldFrame;
import bluej.stride.framedjava.frames.InheritedMethodFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.TriangleLabel;
import bluej.utility.javafx.SharedTransition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;

class InheritedCanvas {
    public final String superClassName;
    public final FrameCanvas canvas;
    public final FrameContentRow precedingDivider;
    public final SlotLabel precedingDividerLabel;
    public final TriangleLabel optionalCollapse;

    public InheritedCanvas(final ClassFrame classFrame, final InteractionManager editor, String superClassName, boolean single) {
        this.canvas = new FrameCanvas(editor, new CanvasParent(){

            @Override
            public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                return null;
            }

            @Override
            public String getXPathForElementAt(double sceneX, double sceneY, LocatableElement.LocationMap locationMap, boolean includePseudoElements, boolean includeSubstringIndex) {
                return null;
            }

            @Override
            public FrameTypeCheck check(FrameCanvas canvasBase) {
                return new FrameTypeCheck(){

                    @Override
                    public boolean canInsert(StrideCategory category) {
                        return false;
                    }

                    @Override
                    public boolean canPlace(Class<? extends Frame> type) {
                        return Arrays.asList(InheritedMethodFrame.class, InheritedFieldFrame.class).contains(type);
                    }
                };
            }

            @Override
            public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursor) {
                return Collections.emptyList();
            }

            @Override
            public Frame getFrame() {
                return classFrame;
            }

            @Override
            public String getLocationDescription(FrameCanvas c) {
                return " in the class " + (editor.nameProperty().get() != null ? (String)editor.nameProperty().get() : "[editor name property null in InheritedCanvas]");
            }

            @Override
            public InteractionManager getEditor() {
                return editor;
            }

            @Override
            public void modifiedCanvasContent() {
            }

            @Override
            public String getHelpContext() {
                return "";
            }
        }, "class-inherited-"){

            @Override
            public FrameCursor findClosestCursor(double sceneX, double sceneY, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                return null;
            }

            @Override
            public FrameCursor getFirstCursor() {
                return null;
            }

            @Override
            public FrameCursor getLastCursor() {
                return null;
            }
        };
        this.superClassName = superClassName;
        if (single) {
            this.precedingDividerLabel = null;
            this.precedingDivider = null;
            this.optionalCollapse = null;
        } else if (superClassName.equals("java.lang.Object")) {
            String text = Config.getString("frame.class.inherited.from").replace("$", "Object");
            this.precedingDividerLabel = new SlotLabel(text, "class-inherited-label");
            this.optionalCollapse = new TriangleLabel(editor, t -> this.canvas.growUsing(t.getProgress()), t -> this.canvas.shrinkUsing(t.getOppositeProgress()), new SimpleBooleanProperty(false));
            this.precedingDivider = new FrameContentRow((Frame)classFrame, this.precedingDividerLabel, this.optionalCollapse);
        } else {
            String text = Config.getString("frame.class.inherited.from").replace("$", superClassName);
            this.precedingDividerLabel = new SlotLabel(text, "class-inherited-label");
            this.precedingDivider = new FrameContentRow((Frame)classFrame, this.precedingDividerLabel);
            this.optionalCollapse = null;
        }
    }

    public void grow(SharedTransition t) {
        if (this.optionalCollapse == null || this.optionalCollapse.expandedProperty().get()) {
            this.canvas.growUsing(t.getProgress());
        }
        if (this.precedingDividerLabel != null) {
            this.precedingDividerLabel.growVertically(t);
            this.precedingDividerLabel.setLeftPadding(this.canvas.leftMargin().get());
        }
        if (this.optionalCollapse != null) {
            this.optionalCollapse.setVisible(true);
        }
    }

    public void shrink(SharedTransition t) {
        this.canvas.shrinkUsing(t.getOppositeProgress());
        if (this.precedingDividerLabel != null) {
            this.precedingDividerLabel.shrinkVertically(t);
        }
        if (this.optionalCollapse != null) {
            this.optionalCollapse.setVisible(false);
        }
    }
}

