/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.CursorFinder;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import java.util.List;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface CanvasParent
extends CursorFinder {
    public FrameTypeCheck check(FrameCanvas var1);

    default public FrameCursor getCursorBefore(FrameCanvas c) {
        List canvases = this.getFrame().getCanvases().collect(Collectors.toList());
        int index = canvases.indexOf(c);
        if (index == -1) {
            throw new IllegalStateException("Canvas not known by parent frame");
        }
        FrameCursor candidate = null;
        while (index > 0 && (candidate = ((FrameCanvas)canvases.get(index - 1)).getLastCursor()) == null) {
            --index;
        }
        if (candidate != null) {
            return candidate;
        }
        return this.getFrame().getCursorBefore();
    }

    default public FrameCursor getCursorAfter(FrameCanvas c) {
        List canvases = this.getFrame().getCanvases().collect(Collectors.toList());
        int index = canvases.indexOf(c);
        if (index == -1) {
            throw new IllegalStateException("Canvas not known by parent frame");
        }
        FrameCursor candidate = null;
        while (index + 1 < canvases.size() && (candidate = ((FrameCanvas)canvases.get(index + 1)).getFirstCursor()) == null) {
            ++index;
        }
        if (candidate != null) {
            return candidate;
        }
        return this.getFrame().getCursorAfter();
    }

    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas var1, FrameCursor var2);

    public InteractionManager getEditor();

    default public void modifiedCanvasContent() {
        this.getEditor().modifiedFrame(null, false);
    }

    @OnThread(value=Tag.FXPlatform)
    public static boolean processInnerExtensionKey(CanvasParent p, FrameCanvas canvas, FrameCursor cursor, char c, RecallableFocus rc, boolean atTop) {
        List candidates = p.getAvailableExtensions(canvas, cursor).stream().filter(e -> e.getShortcutKey() == c && e.validFor(atTop ? ExtensionDescription.ExtensionSource.INSIDE_FIRST : ExtensionDescription.ExtensionSource.INSIDE_LATER)).collect(Collectors.toList());
        if (candidates.size() == 0) {
            return false;
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException("Ambiguous inner extension for: " + c);
        }
        p.getEditor().beginRecordingState(rc);
        ((ExtensionDescription)candidates.get(0)).activate();
        p.getEditor().endRecordingState(rc);
        return true;
    }

    public Frame getFrame();

    public String getLocationDescription(FrameCanvas var1);

    public String getHelpContext();

    default public CanvasKind getChildKind(FrameCanvas c) {
        return CanvasKind.STATEMENTS;
    }

    public static enum CanvasKind {
        FIELDS,
        CONSTRUCTORS,
        METHODS,
        STATEMENTS,
        IMPORTS;

    }
}

