/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.NotAProjectDialog;
import bluej.utility.ProjectLocationDialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class FileUtility {
    public static final int NO_ERROR = 0;
    public static final int SRC_NOT_DIRECTORY = 2;
    public static final int COPY_ERROR = 3;
    public static final int DEST_EXISTS_NOT_DIR = 4;
    public static final int DEST_EXISTS_NON_EMPTY = 5;

    @OnThread(value=Tag.FXPlatform)
    public static File getOpenProjectFX(Window parent) {
        File dir;
        File originalDir = FileUtility.getOpenDirFX(parent, Config.getString("pkgmgr.openPkg.title"), true);
        if (originalDir == null) {
            return null;
        }
        for (dir = originalDir; dir != null && dir.getParentFile() != null && Package.isPackage(dir.getParentFile()); dir = dir.getParentFile()) {
        }
        if (!Package.isPackage(dir)) {
            List<File> subDirs = null;
            if (dir != null) {
                subDirs = Arrays.asList(dir.listFiles(f -> f.isDirectory() && Package.isPackage(f)));
            }
            NotAProjectDialog dlg = new NotAProjectDialog(parent, originalDir, subDirs);
            dlg.showAndWait();
            if (dlg.isCancel()) {
                return null;
            }
            if (dlg.isChooseAgain()) {
                return FileUtility.getOpenProjectFX(parent);
            }
            return dlg.getSelectedDir();
        }
        return dir;
    }

    @OnThread(value=Tag.FXPlatform)
    public static File getSaveProjectFX(Project project, Window parent, String title) {
        File chosen = new ProjectLocationDialog(project, parent, title).showAndWait();
        if (chosen == null) {
            return null;
        }
        if (chosen != null && chosen.getParentFile() != null) {
            PrefMgr.setProjectDirectory(chosen.getParentFile().getPath());
        }
        return chosen;
    }

    @OnThread(value=Tag.FXPlatform)
    public static List<File> getMultipleFilesFX(Window parent, String title, FileChooser.ExtensionFilter filter) {
        FileChooser chooser = new FileChooser();
        chooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        if (filter != null) {
            chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{filter});
        }
        chooser.setTitle(title);
        return chooser.showOpenMultipleDialog(parent);
    }

    @OnThread(value=Tag.FXPlatform)
    public static List<File> getOpenFilesFX(Window parent, String title, List<FileChooser.ExtensionFilter> filters, boolean rememberDir) {
        FileChooser newChooser = new FileChooser();
        newChooser.getExtensionFilters().setAll(filters);
        newChooser.setTitle(title);
        newChooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        List chosen = newChooser.showOpenMultipleDialog(parent);
        if (chosen != null && chosen.size() > 0 && ((File)chosen.get(0)).getParentFile() != null && rememberDir) {
            PrefMgr.setProjectDirectory(((File)chosen.get(0)).getParentFile().getPath());
        }
        return chosen;
    }

    @OnThread(value=Tag.FXPlatform)
    public static File getSaveFileFX(Window parent, String title, List<FileChooser.ExtensionFilter> filters, boolean rememberDir) {
        FileChooser newChooser = new FileChooser();
        if (filters != null) {
            newChooser.getExtensionFilters().setAll(filters);
        }
        newChooser.setTitle(title);
        newChooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        File chosen = newChooser.showSaveDialog(parent);
        if (chosen != null && chosen.getParentFile() != null && rememberDir) {
            PrefMgr.setProjectDirectory(chosen.getParentFile().getPath());
        }
        return chosen;
    }

    @OnThread(value=Tag.FXPlatform)
    public static File getOpenArchiveFX(Window parent, String title, boolean rememberDir) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("ZIP/JAR file", new String[]{"*.zip", "*.jar"})});
        if (title != null) {
            chooser.setTitle(title);
        }
        chooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        File chosen = chooser.showOpenDialog(parent);
        if (chosen != null && chosen.getParentFile() != null && rememberDir) {
            PrefMgr.setProjectDirectory(chosen.getParentFile().getPath());
        }
        return chosen;
    }

    @OnThread(value=Tag.FXPlatform)
    public static File getOpenDirFX(Window parent, String title, boolean rememberDir) {
        File chosen;
        DirectoryChooser newChooser = new DirectoryChooser();
        newChooser.setTitle(title);
        if (PrefMgr.getProjectDirectory() != null) {
            newChooser.setInitialDirectory(PrefMgr.getProjectDirectory());
        }
        if ((chosen = newChooser.showDialog(parent)) != null && chosen.getParentFile() != null && rememberDir) {
            PrefMgr.setProjectDirectory(chosen.getParentFile().getPath());
        }
        return chosen;
    }

    @OnThread(value=Tag.FX)
    public static FileChooser.ExtensionFilter getJavaStrideSourceFilterFX() {
        return new FileChooser.ExtensionFilter("Java/Stride source", new String[]{"*." + SourceType.Java.getExtension(), "*." + SourceType.Stride.getExtension()});
    }

    @OnThread(value=Tag.Any)
    public static void copyFile(String source, String dest) throws IOException {
        File srcFile = new File(source);
        File destFile = new File(dest);
        FileUtility.copyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile.equals(destFile)) {
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(srcFile));
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            FileUtility.copyStream(in, out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @OnThread(value=Tag.Any)
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int c;
        byte[] buffer = new byte[4096];
        while ((c = in.read(buffer)) != -1) {
            out.write(buffer, 0, c);
        }
    }

    @OnThread(value=Tag.Any)
    public static int copyDirectory(File srcFile, File destFile) {
        if (!srcFile.isDirectory()) {
            return 2;
        }
        if (destFile.exists() && !destFile.isDirectory()) {
            return 4;
        }
        if (destFile.exists()) {
            if (destFile.list().length > 0) {
                return 5;
            }
        } else if (!destFile.mkdir()) {
            return 3;
        }
        String[] dir = srcFile.list();
        for (int i = 0; i < dir.length; ++i) {
            File file = new File(srcFile, dir[i]);
            if (file.isDirectory()) {
                if (FileUtility.copyDirectory(file, new File(destFile, dir[i])) == 0) continue;
                return 3;
            }
            File file2 = new File(destFile, dir[i]);
            try {
                FileUtility.copyFile(file, file2);
                continue;
            }
            catch (IOException ioe) {
                return 3;
            }
        }
        return 0;
    }

    @OnThread(value=Tag.Any)
    public static File[] recursiveCopyFile(File srcDir, File destDir) {
        if (srcDir == null || destDir == null) {
            throw new IllegalArgumentException();
        }
        for (File parentDir = destDir.getParentFile(); parentDir != null; parentDir = parentDir.getParentFile()) {
            if (!parentDir.equals(srcDir)) continue;
            return new File[]{srcDir};
        }
        return FileUtility.actualRecursiveCopyFile(srcDir, destDir);
    }

    @OnThread(value=Tag.Any)
    private static File[] actualRecursiveCopyFile(File srcDir, File destDir) {
        ArrayList<File> failed = new ArrayList<File>();
        if (srcDir.getAbsolutePath().equals(destDir.getAbsolutePath())) {
            return null;
        }
        if (!srcDir.isDirectory() || !destDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        File[] files = srcDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                File newDir = new File(destDir, files[i].getName());
                newDir.mkdir();
                if (newDir.isDirectory()) {
                    FileUtility.actualRecursiveCopyFile(files[i], newDir);
                    continue;
                }
                failed.add(files[i]);
                continue;
            }
            if (!files[i].isFile()) continue;
            File newFile = new File(destDir, files[i].getName());
            if (!newFile.exists()) {
                try {
                    FileUtility.copyFile(files[i], newFile);
                }
                catch (IOException ioe) {
                    failed.add(files[i]);
                }
                continue;
            }
            failed.add(files[i]);
        }
        if (failed.size() > 0) {
            return failed.toArray(new File[0]);
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public static File findFile(File startDir, String suffix) {
        File[] files = startDir.listFiles();
        if (files != null) {
            int i;
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().endsWith(suffix)) continue;
                return files[i];
            }
            for (i = 0; i < files.length; ++i) {
                File found;
                if (!files[i].isDirectory() || (found = FileUtility.findFile(files[i], suffix)) == null) continue;
                return found;
            }
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public static boolean containsFile(File dir, String suffix) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !files[i].getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    public static void deleteDir(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null || Array.getLength(fileList) == 0) {
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        } else {
            for (int i = 0; i < Array.getLength(fileList); ++i) {
                FileUtility.deleteDir(fileList[i]);
            }
            try {
                directory.delete();
            }
            catch (SecurityException se) {
                Debug.message("Trouble deleting: " + directory + se);
            }
        }
    }

    @OnThread(value=Tag.Any)
    public static String makeRelativePath(File parent, File file) {
        String parentPath;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(parentPath = parent.getAbsolutePath())) {
            filePath = filePath.substring(parentPath.length() + 1);
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public static WriteCapabilities getVistaWriteCapabilities(File dir) {
        if (!dir.isDirectory()) {
            return WriteCapabilities.UNKNOWN;
        }
        WriteCapabilities capabilities = WriteCapabilities.UNKNOWN;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("bluej", null, dir);
            tmpFile.deleteOnExit();
            capabilities = FileUtility.isVirtualized(tmpFile) ? WriteCapabilities.VIRTUALIZED_WRITE : WriteCapabilities.NORMAL_WRITE;
        }
        catch (IOException e) {
            capabilities = WriteCapabilities.READ_ONLY;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return capabilities;
    }

    @OnThread(value=Tag.Any)
    private static boolean isVirtualized(File file) {
        boolean isVirtualized = false;
        if (Config.isModernWinOS()) {
            try {
                String canonicalPath = file.getCanonicalPath();
                int colonIndex = canonicalPath.indexOf(":");
                if (colonIndex > 0) {
                    String pathPart = canonicalPath.substring(colonIndex + 1);
                    String virtualStore = System.getenv("localappdata") + File.separator + "VirtualStore";
                    String virtualTmpFilePath = virtualStore + pathPart;
                    isVirtualized = new File(virtualTmpFilePath).exists();
                }
            }
            catch (IOException e) {
                Debug.reportError("Error when testing for Windows virtualisation.", e);
            }
        }
        return isVirtualized;
    }

    public static enum WriteCapabilities {
        READ_ONLY,
        NORMAL_WRITE,
        VIRTUALIZED_WRITE,
        UNKNOWN;

    }
}

