/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Package;
import bluej.utility.JavaNames;
import bluej.utility.PackageFileView;
import bluej.utility.filefilter.DirectoryFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
class PackageChooser
extends JFileChooser {
    private static final Icon classIcon = Config.getFixedImageAsIcon("class-icon.png");
    private static final Icon packageIcon = Config.getFixedImageAsIcon("package-icon.png");
    private static final String previewLine1 = Config.getString("utility.packageChooser.previewPane1");
    private static final String previewLine2 = Config.getString("utility.packageChooser.previewPane2");
    private PackageDisplay displayPanel;
    private boolean allowNewFiles = true;

    public PackageChooser(File startDirectory, boolean preview, boolean showArchives) {
        super(startDirectory);
        if (showArchives) {
            this.setFileSelectionMode(2);
        } else {
            this.setFileSelectionMode(1);
        }
        this.setFileView(new PackageFileView());
        if (preview) {
            this.displayPanel = new PackageDisplay(startDirectory);
            this.setAccessory(this.displayPanel);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (!(e.getNewValue() instanceof File)) {
                        return;
                    }
                    File dir = (File)e.getNewValue();
                    if (dir == null) {
                        return;
                    }
                    if (dir.getName().equals("")) {
                        return;
                    }
                    PackageChooser.this.displayPanel.setDisplayDirectory(dir.getAbsoluteFile());
                }
            });
        }
    }

    public void setAllowNewFiles(boolean allowNewFiles) {
        this.allowNewFiles = allowNewFiles;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fname = f.getName();
        return fname.endsWith(".jar") || fname.endsWith(".JAR") || fname.endsWith(".zip") || fname.endsWith(".ZIP") || Config.isGreenfoot() && (fname.endsWith(".gfar") || fname.endsWith(".GFAR") || fname.endsWith(".sb"));
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (Package.isPackage(dir)) {
            this.setSelectedFile(dir);
            super.approveSelection();
        } else {
            FileChooserUI ui;
            super.setCurrentDirectory(dir);
            if (this.allowNewFiles && (ui = this.getUI()) instanceof BasicFileChooserUI) {
                BasicFileChooserUI mui = (BasicFileChooserUI)ui;
                mui.setFileName("");
            }
        }
    }

    protected void approved() {
        super.approveSelection();
    }

    class PackageDisplay
    extends JList {
        final int headerLines = 3;
        int lastClass = 0;

        PackageDisplay(File displayDir) {
            this.setPreferredSize(new Dimension(150, 200));
            this.setCellRenderer(new MyListRenderer());
            this.setDisplayDirectory(displayDir);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
        }

        void setDisplayDirectory(File displayDir) {
            if (displayDir == null) {
                return;
            }
            int maxDisplay = 3;
            File[] subDirs = displayDir.listFiles(new DirectoryFilter());
            File[] srcFiles = displayDir.listFiles(new JavaSourceFilter());
            ArrayList<Object> listVec = new ArrayList<Object>();
            listVec.add(previewLine1);
            listVec.add(previewLine2);
            listVec.add(" ");
            if (subDirs != null) {
                this.lastClass = 0;
                while (this.lastClass < srcFiles.length && this.lastClass < maxDisplay) {
                    String javaFileName = JavaNames.stripSuffix(srcFiles[this.lastClass].getName(), "." + SourceType.Java.toString().toLowerCase());
                    if (JavaNames.isIdentifier(javaFileName) && javaFileName.indexOf(36) == -1) {
                        listVec.add(javaFileName);
                    }
                    ++this.lastClass;
                }
            }
            if (srcFiles != null) {
                for (int i = 0; i < subDirs.length && i < maxDisplay; ++i) {
                    if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
                    listVec.add(subDirs[i].getName());
                    File[] subSubDirs = subDirs[i].listFiles(new DirectoryFilter());
                    if (subSubDirs == null) continue;
                    for (int j = 0; j < subSubDirs.length; ++j) {
                        if (!JavaNames.isIdentifier(subSubDirs[j].getName())) continue;
                        listVec.add(subDirs[i].getName() + "." + subSubDirs[j].getName());
                    }
                }
            }
            this.setListData(listVec.toArray());
        }

        class MyListRenderer
        extends DefaultListCellRenderer {
            MyListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component s = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index >= 3) {
                    if (index - 3 < PackageDisplay.this.lastClass) {
                        ((JLabel)s).setIcon(classIcon);
                    } else {
                        ((JLabel)s).setIcon(packageIcon);
                    }
                }
                return s;
            }
        }
    }
}

