/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ScrollFreeTextArea {
    private static final Scene scene = new Scene((Parent)new VBox(), 4000.0, 4000.0);
    private static Scene calculationAidScene = null;
    private static TextArea calculationAid = null;
    private static String calculationAidFontCSS = null;
    private static List<String> calculationAidStyleClass = null;
    private final SimpleDoubleProperty scale = new SimpleDoubleProperty(1.0);
    private final TextArea textArea = new TextArea(){

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public @OnThread(value=Tag.FXPlatform, ignoreParent=true) Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objects) {
            switch (accessibleAttribute) {
                case HELP: {
                    return ScrollFreeTextArea.this.screenReaderHelp;
                }
                case ROLE_DESCRIPTION: {
                    return ScrollFreeTextArea.this.screenReaderRoleDescriptor;
                }
            }
            return super.queryAccessibleAttribute(accessibleAttribute, objects);
        }
    };
    private boolean initialised = false;
    private double blankHeight;
    private double suggestedOneLineHeight;
    private String screenReaderHelp = "";
    private String screenReaderRoleDescriptor = "";

    public ScrollFreeTextArea(final InteractionManager editor) {
        final TextArea offScreen = new TextArea();
        final SimpleDoubleProperty contentHeight = new SimpleDoubleProperty();
        ChangeListener<Object> listener = new ChangeListener<Object>(){

            public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                if (ScrollFreeTextArea.this.textArea.getScene() != null && ScrollFreeTextArea.this.textArea.getSkin() != null && !ScrollFreeTextArea.this.initialised) {
                    ScrollFreeTextArea.this.initialised = true;
                    ScrollFreeTextArea.this.textArea.sceneProperty().removeListener((ChangeListener)this);
                    ScrollFreeTextArea.this.textArea.skinProperty().removeListener((ChangeListener)this);
                    ScrollFreeTextArea.this.recalculateOneTwoLineHeights((String)editor.getFontCSS().get());
                    ScrollFreeTextArea.this.textArea.getStyleClass().addListener(c -> ScrollFreeTextArea.this.recalculateOneTwoLineHeights((String)editor.getFontCSS().get()));
                    ScrollFreeTextArea.this.textArea.snapshot(null, null);
                    ScrollPane p = (ScrollPane)ScrollFreeTextArea.this.textArea.lookup(".scroll-pane");
                    p.setFitToHeight(true);
                    p.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                    contentHeight.bind((ObservableValue)new DoubleBinding(){
                        private boolean accessedInternals = false;
                        private Region content;
                        {
                            this.bind(new Observable[]{ScrollFreeTextArea.this.scale});
                            this.bind(new Observable[]{ScrollFreeTextArea.this.textArea.widthProperty()});
                            this.bind(new Observable[]{ScrollFreeTextArea.this.textProperty()});
                            this.bind(new Observable[]{offScreen.styleProperty()});
                            this.bind(new Observable[]{ScrollFreeTextArea.this.textArea.paddingProperty()});
                        }

                        protected double computeValue() {
                            scene.setRoot((Parent)new Pane(new Node[]{offScreen}));
                            offScreen.applyCss();
                            scene.getRoot().layout();
                            if (!this.accessedInternals) {
                                ((ScrollPane)offScreen.lookup(".scroll-pane")).setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                                ((ScrollPane)offScreen.lookup(".scroll-pane")).setFitToWidth(true);
                                this.content = (Region)offScreen.lookup(".content");
                                this.accessedInternals = true;
                            }
                            double prev = this.content.getPrefHeight();
                            this.content.setPrefHeight(-1.0);
                            this.content.prefHeight(this.content.getWidth() + 1.0);
                            double r = this.content.prefHeight(this.content.getWidth());
                            this.content.setPrefHeight(r);
                            scene.setRoot((Parent)new VBox());
                            if (r <= ScrollFreeTextArea.this.blankHeight) {
                                return ScrollFreeTextArea.this.scale.get() * (ScrollFreeTextArea.this.suggestedOneLineHeight + ScrollFreeTextArea.this.textArea.getPadding().getTop() + ScrollFreeTextArea.this.textArea.getPadding().getBottom());
                            }
                            return ScrollFreeTextArea.this.scale.get() * (r + ScrollFreeTextArea.this.textArea.getPadding().getTop() + ScrollFreeTextArea.this.textArea.getPadding().getBottom());
                        }
                    });
                }
            }
        };
        this.textArea.sceneProperty().addListener((ChangeListener)listener);
        this.textArea.skinProperty().addListener((ChangeListener)listener);
        this.textArea.setWrapText(true);
        offScreen.setWrapText(true);
        this.textArea.setPrefRowCount(0);
        this.textArea.setMinHeight(0.0);
        this.textArea.prefHeightProperty().bind((ObservableValue)contentHeight);
        JavaFXUtil.bindList(offScreen.getStyleClass(), this.textArea.getStyleClass());
        offScreen.textProperty().bind((ObservableValue)this.textArea.textProperty());
        offScreen.minWidthProperty().bind((ObservableValue)offScreen.prefWidthProperty());
        offScreen.prefWidthProperty().bind((ObservableValue)this.textArea.widthProperty());
        offScreen.maxWidthProperty().bind((ObservableValue)offScreen.prefWidthProperty());
        offScreen.setPrefRowCount(0);
        offScreen.setMinHeight(0.0);
        offScreen.styleProperty().bind((ObservableValue)editor.getFontCSS());
        JavaFXUtil.addChangeListener(editor.getFontCSS(), this::recalculateOneTwoLineHeights);
        JavaFXUtil.addChangeListener(this.textArea.widthProperty(), w -> Platform.runLater(() -> ((TextArea)this.textArea).requestLayout()));
    }

    private void recalculateOneTwoLineHeights(String fontSize) {
        this.blankHeight = this.calculateHeight(fontSize, "X");
        double twoLine = this.calculateHeight(fontSize, "X\nX");
        double threeLine = this.calculateHeight(fontSize, "X\nX\nX");
        double extraLine = threeLine - twoLine;
        this.suggestedOneLineHeight = twoLine - extraLine + 2.0;
    }

    private double calculateHeight(String fontCSS, String text) {
        if (calculationAid == null || calculationAidScene == null) {
            calculationAid = new TextArea();
            calculationAid.setWrapText(true);
            calculationAid.setPrefRowCount(0);
            calculationAid.setMinHeight(0.0);
            calculationAidScene = new Scene((Parent)new Pane(new Node[]{calculationAid}), 4000.0, 4000.0);
            Config.addEditorStylesheets(calculationAidScene);
        }
        if (!fontCSS.equals(calculationAidFontCSS)) {
            calculationAid.setStyle(fontCSS);
            calculationAidFontCSS = fontCSS;
            calculationAid.applyCss();
        }
        if (!calculationAid.getStyleClass().equals(calculationAidStyleClass)) {
            calculationAid.getStyleClass().setAll((Collection)this.textArea.getStyleClass());
            calculationAidStyleClass = new ArrayList<String>((Collection<String>)this.textArea.getStyleClass());
            calculationAid.applyCss();
        }
        calculationAid.setText(text);
        calculationAid.layout();
        ((ScrollPane)calculationAid.lookup(".scroll-pane")).setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        ((ScrollPane)calculationAid.lookup(".scroll-pane")).setFitToWidth(true);
        Region content = (Region)calculationAid.lookup(".content");
        double r = content.prefHeight(1000.0);
        return r;
    }

    public void setPromptText(String s) {
        this.textArea.setPromptText(s);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String value) {
        this.textArea.setText(value);
    }

    public StringProperty textProperty() {
        return this.textArea.textProperty();
    }

    public StringProperty promptTextProperty() {
        return this.textArea.promptTextProperty();
    }

    public ReadOnlyIntegerProperty caretPositionProperty() {
        return this.textArea.caretPositionProperty();
    }

    public void positionCaret(int pos) {
        this.textArea.positionCaret(pos);
    }

    public int getLength() {
        return this.textArea.getLength();
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public boolean isDisable() {
        return this.textArea.isDisable();
    }

    public void setDisable(boolean value) {
        this.textArea.setDisable(value);
    }

    public boolean isFocused() {
        return this.textArea.isFocused();
    }

    public ObservableBooleanValue focusedProperty() {
        return this.textArea.focusedProperty();
    }

    protected void setFocusTraversable(boolean on) {
        this.textArea.setFocusTraversable(on);
    }

    protected void addTextStyleClasses(String ... styleClasses) {
        JavaFXUtil.addStyleClass((Styleable)this.textArea, styleClasses);
    }

    public Node getNode() {
        return this.textArea;
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.textArea.heightProperty();
    }

    public void setPseudoclass(String name, boolean on) {
        JavaFXUtil.setPseudoclass(name, on, new Node[]{this.textArea});
    }

    public <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.textArea.addEventFilter(eventType, eventFilter);
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void bindPrefMaxWidth(DoubleBinding amount) {
        this.textArea.maxWidthProperty().bind((ObservableValue)amount);
        this.textArea.prefWidthProperty().bind((ObservableValue)this.textArea.maxWidthProperty());
    }

    public void insertAtCaret(String s) {
        this.textArea.insertText(this.textArea.getCaretPosition(), s);
    }

    public void shrinkToNothingUsing(SharedTransition animate) {
        this.scale.unbind();
        this.scale.bind((ObservableValue)animate.getOppositeProgress());
        animate.addOnStopped(() -> ((SimpleDoubleProperty)this.scale).unbind());
        animate.addOnStopped(() -> this.textArea.setVisible(false));
    }

    public void growFromNothingUsing(SharedTransition animate) {
        this.textArea.setVisible(true);
        this.scale.unbind();
        this.scale.bind((ObservableValue)animate.getProgress());
        animate.addOnStopped(() -> ((SimpleDoubleProperty)this.scale).unbind());
    }

    public Bounds getSceneBounds() {
        return this.textArea.localToScene(this.textArea.getBoundsInLocal());
    }

    public void setScreenReaderRoleDescription(String text) {
        this.screenReaderRoleDescriptor = text;
    }

    public void setScreenReaderHelpSlots(String helpText) {
        this.screenReaderHelp = helpText;
    }

    static {
        Config.addEditorStylesheets(scene);
    }
}

