/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2.editor;

import bluej.editor.Editor;
import bluej.editor.TextEditor;
import bluej.extensions2.BClass;
import bluej.extensions2.editor.DocumentListener;
import bluej.extensions2.editor.TextLocation;
import bluej.parser.SourceLocation;
import java.io.IOException;
import javafx.geometry.Rectangle2D;

public class JavaEditor {
    private final BClass bClass;
    private TextEditor bjEditor;

    JavaEditor(BClass bClass, TextEditor bjEditor) {
        this.bClass = bClass;
        this.bjEditor = bjEditor;
    }

    Editor getEditor() {
        return this.bjEditor;
    }

    public BClass getBClass() {
        return this.bClass;
    }

    public void saveFile() {
        try {
            this.bjEditor.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFile() {
        this.bjEditor.reloadFile();
    }

    public void setVisible(boolean visible) {
        this.bjEditor.setEditorVisible(visible, false);
    }

    public boolean isVisible() {
        return this.bjEditor.isOpen();
    }

    public TextLocation getCaretLocation() {
        return this.convertLocation(this.bjEditor.getCaretLocation());
    }

    public void setCaretLocation(TextLocation location) {
        this.bjEditor.setCaretLocation(this.convertLocation(location));
    }

    public void showMessage(String message) {
        this.bjEditor.writeMessage(message);
    }

    public TextLocation getSelectionBegin() {
        return this.convertLocation(this.bjEditor.getSelectionBegin());
    }

    public TextLocation getSelectionEnd() {
        return this.convertLocation(this.bjEditor.getSelectionEnd());
    }

    public String getText(TextLocation begin, TextLocation end) {
        return this.bjEditor.getText(this.convertLocation(begin), this.convertLocation(end));
    }

    public void setText(TextLocation begin, TextLocation end, String newText) {
        this.bjEditor.setText(this.convertLocation(begin), this.convertLocation(end), newText);
    }

    public void setSelection(TextLocation begin, TextLocation end) {
        this.bjEditor.setSelection(this.convertLocation(begin), this.convertLocation(end));
    }

    public void setReadOnly(boolean readOnly) {
        this.bjEditor.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.bjEditor.isReadOnly();
    }

    public Object getProperty(String propertyKey) {
        return this.bjEditor.getProperty(propertyKey);
    }

    public void setProperty(String propertyKey, Object value) {
        this.bjEditor.setProperty(propertyKey, value);
    }

    public int getOffsetFromTextLocation(TextLocation location) {
        return this.bjEditor.getOffsetFromLineColumn(this.convertLocation(location));
    }

    public TextLocation getTextLocationFromOffset(int offset) {
        return this.convertLocation(this.bjEditor.getLineColumnFromOffset(offset));
    }

    public int getLineLength(int line) {
        return this.bjEditor.getLineLength(line);
    }

    public int getLineCount() {
        return this.bjEditor.numberOfLines();
    }

    public int getTextLength() {
        return this.bjEditor.getTextLength();
    }

    public Rectangle2D getScreenBounds() {
        return this.bjEditor.getScreenBoundsIfSelectedTab();
    }

    private SourceLocation convertLocation(TextLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getLine() + 1, location.getColumn() + 1);
    }

    private TextLocation convertLocation(SourceLocation location) {
        if (location == null) {
            return null;
        }
        return new TextLocation(location.getLine() - 1, location.getColumn() - 1);
    }

    public LocationDetails getLocationFromScreenPos(int screenX, int screenY) {
        SourceLocation sourceLocation = this.bjEditor.getTextPositionForScreenPos(screenX, screenY);
        return sourceLocation == null ? null : new LocationDetails(this.convertLocation(sourceLocation), this.bjEditor.getScreenBoundsOfLine(sourceLocation.getLine()));
    }

    public double getFontSizeInPixels() {
        return this.bjEditor.getFontSizeInPixels();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.bjEditor.addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.bjEditor.removeDocumentListener(listener);
    }

    public static class LocationDetails {
        private final TextLocation textLocation;
        private final Rectangle2D lineBoundsOnScreen;

        private LocationDetails(TextLocation textLocation, Rectangle2D lineBoundsOnScreen) {
            this.textLocation = textLocation;
            this.lineBoundsOnScreen = lineBoundsOnScreen;
        }

        public TextLocation getTextLocation() {
            return this.textLocation;
        }

        public Rectangle2D getLineBoundsOnScreen() {
            return this.lineBoundsOnScreen;
        }
    }
}

