/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.classmgr.BPClassLoader;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadListener;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.RunOnThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiTestResult;
import bluej.debugger.jdi.JdiTestResultError;
import bluej.debugger.jdi.JdiTestResultFailure;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadSet;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.TestResultsWithRunTime;
import bluej.debugger.jdi.VMReference;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXPlatformSupplier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMOutOfMemoryException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JdiDebugger
extends Debugger {
    private static final int loaderPriority = 3;
    private @OnThread(value=Tag.Any) boolean autoRestart = true;
    private @OnThread(value=Tag.Any) boolean selfRestart = false;
    private @OnThread(value=Tag.Any) VMReference vmRef;
    private @OnThread(value=Tag.Any) MachineLoaderThread machineLoader;
    private @OnThread(value=Tag.Any) Object serverThreadLock = new Object();
    private @OnThread(value=Tag.VMEventHandler) JdiThreadSet allThreads;
    private final DebuggerThreadListener threadListener;
    private final @OnThread(value=Tag.Any) List<DebuggerListener> listenerList = new ArrayList<DebuggerListener>();
    private File startingDirectory;
    private DebuggerTerminal terminal;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Set<String> usedNames;
    private @OnThread(value=Tag.Any) int machineState = 1;
    private BPClassLoader lastProjectClassLoader;
    private ExceptionDescription lastException;
    private URL[] libraries = new URL[0];
    private RunOnThread runOnThread = RunOnThread.DEFAULT;

    public JdiDebugger(File startingDirectory, DebuggerTerminal terminal, DebuggerThreadListener debuggerThreadListener) {
        this.startingDirectory = startingDirectory;
        this.terminal = terminal;
        this.threadListener = debuggerThreadListener;
        this.allThreads = new JdiThreadSet();
        this.usedNames = new TreeSet<String>();
    }

    @Override
    public void setUserLibraries(URL[] libraries) {
        this.libraries = libraries;
    }

    @Override
    @OnThread(value=Tag.Any)
    public synchronized void launch() {
        if (this.vmRef != null) {
            throw new IllegalStateException("JdiDebugger.launch() was called but the debugger was already loaded");
        }
        if (this.machineLoader != null && !this.selfRestart) {
            return;
        }
        this.autoRestart = true;
        if (!this.selfRestart) {
            this.machineLoader = new MachineLoaderThread();
        }
        this.selfRestart = false;
        this.machineLoader.setPriority(3);
        this.machineLoader.start();
    }

    @Override
    public synchronized void close(boolean restart) {
        if (this.vmRef != null) {
            this.autoRestart = restart;
            this.selfRestart = restart;
            if (this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRef.close();
        } else if (!restart) {
            this.autoRestart = false;
            this.selfRestart = false;
            this.machineLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(l);
            return this.machineState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void removeDebuggerListener(DebuggerListener l) {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private DebuggerListener[] getListeners() {
        List<DebuggerListener> list = this.listenerList;
        synchronized (list) {
            return this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessNewName(String className) {
        String baseName = JavaNames.getBase(className = className.replace('[', ' ').replace(']', ' ').trim());
        int stringEndIndex = baseName.length() > 8 ? 8 : baseName.length();
        String newName = Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1, stringEndIndex);
        int num = 1;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            while (this.usedNames.contains(newName + num)) {
                ++num;
            }
        }
        return newName + num;
    }

    @Override
    public String guessNewName(DebuggerObject obj) {
        String name = null;
        DebuggerClass cls = obj.getClassRef();
        if (cls.isEnum()) {
            ObjectReference val = obj.getObjectReference();
            name = JdiUtils.getJdiUtils().getValueString(val);
        }
        if (name == null) {
            name = cls.getName();
        }
        return this.guessNewName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newClassLoader(BPClassLoader bpClassLoader) {
        VMReference vmr = null;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            if (bpClassLoader == null) {
                return;
            }
            this.lastProjectClassLoader = bpClassLoader;
            vmr = this.getVMNoWait();
            if (vmr != null) {
                this.usedNames.clear();
            }
        }
        if (vmr != null) {
            try {
                vmr.clearAllBreakpoints();
                vmr.newClassLoader(bpClassLoader.getURLs());
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void removeBreakpointsForClass(String className) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.clearBreakpointsForClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObject(String scopeId, String newInstanceName, DebuggerObject dob) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.addObject(scopeId, newInstanceName, ((JdiObject)dob).getObjectReference());
            JdiDebugger jdiDebugger = this;
            synchronized (jdiDebugger) {
                this.usedNames.add(newInstanceName);
            }
        }
        return true;
    }

    @Override
    public void removeObject(String scopeId, String instanceName) {
        VMReference vmr = this.getVMNoWait();
        if (vmr != null) {
            vmr.removeObject(scopeId, instanceName);
        }
    }

    @Override
    public Map<String, DebuggerObject> getObjects() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public int getStatus() {
        return this.machineState;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public DebuggerObject getMirror(String value) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            try {
                StringReference stringReference;
                do {
                    stringReference = vmr.getMirror(value);
                    try {
                        stringReference.disableCollection();
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        // empty catch block
                    }
                } while (stringReference.isCollected());
                return JdiObject.getDebuggerObject(stringReference);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (VMOutOfMemoryException vMOutOfMemoryException) {
                // empty catch block
            }
        }
        return null;
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public FXPlatformSupplier<Map<String, DebuggerObject>> runTestSetUp(String className) {
        ArrayReference arrayRef = null;
        VMReference vmr = this.getVM();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeTestSetup(className);
                }
                if (arrayRef != null) {
                    ArrayReference arrayRefFinal = arrayRef;
                    ObjectReference testObject = (ObjectReference)arrayRef.getValue(arrayRef.length() - 1);
                    return () -> {
                        HashMap<String, JdiObject> returnMap = new HashMap<String, JdiObject>();
                        JdiObject jdiTestObject = JdiObject.getDebuggerObject(testObject);
                        for (int i = 0; i < arrayRefFinal.length() - 1; i += 2) {
                            String fieldName = ((StringReference)arrayRefFinal.getValue(i)).value();
                            Field testField = testObject.referenceType().fieldByName(fieldName);
                            if (testField.typeName().matches("int|double|float|short|boolean|byte|long|char|")) continue;
                            returnMap.put(fieldName, JdiObject.getDebuggerObject((ObjectReference)arrayRefFinal.getValue(i + 1), testField, jdiTestObject));
                        }
                        return returnMap;
                    };
                }
                return () -> Collections.emptyMap();
            }
        }
        catch (InvocationException e) {
            return () -> null;
        }
        catch (VMDisconnectedException e) {
            return () -> null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public TestResultsWithRunTime runTestMethod(String className, String methodName) {
        ArrayReference arrayRef = null;
        ArrayList<DebuggerTestResult> results = new ArrayList<DebuggerTestResult>();
        TestResultsWithRunTime testResultsWithRunTime = new TestResultsWithRunTime();
        try {
            VMReference vmr = this.getVM();
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    arrayRef = (ArrayReference)vmr.invokeRunTest(className, methodName);
                }
                if (arrayRef == null || arrayRef.length() == 0) {
                    results.add(new JdiTestResultError(className, methodName, methodName, "VM returned unknown result", "", null, 0));
                    testResultsWithRunTime.setResults(results);
                    testResultsWithRunTime.setTotalRunTime(0);
                    return testResultsWithRunTime;
                }
                int runTimeMs = Integer.parseInt(((StringReference)arrayRef.getValue(0)).value());
                for (int i = 1; i < arrayRef.length(); i += 9) {
                    String actualMethodName = ((StringReference)arrayRef.getValue(i)).value();
                    String displayTestName = ((StringReference)arrayRef.getValue(i + 1)).value();
                    String failureType = ((StringReference)arrayRef.getValue(i + 8)).value();
                    if (failureType.equals("success")) {
                        results.add(new JdiTestResult(className, actualMethodName, displayTestName, 0));
                        continue;
                    }
                    String exMsg = ((StringReference)arrayRef.getValue(i + 2)).value();
                    String traceMsg = ((StringReference)arrayRef.getValue(i + 3)).value();
                    String failureClass = ((StringReference)arrayRef.getValue(i + 4)).value();
                    String failureSource = ((StringReference)arrayRef.getValue(i + 5)).value();
                    String failureMethod = ((StringReference)arrayRef.getValue(i + 6)).value();
                    int lineNo = Integer.parseInt(((StringReference)arrayRef.getValue(i + 7)).value());
                    SourceLocation failPoint = new SourceLocation(failureClass, failureSource, failureMethod, lineNo);
                    if (failureType.equals("failure")) {
                        results.add(new JdiTestResultFailure(className, actualMethodName, displayTestName, exMsg, traceMsg, failPoint, 0));
                        continue;
                    }
                    results.add(new JdiTestResultError(className, actualMethodName, displayTestName, exMsg, traceMsg, failPoint, 0));
                }
                testResultsWithRunTime.setTotalRunTime(runTimeMs);
                testResultsWithRunTime.setResults(results);
                return testResultsWithRunTime;
            }
        }
        catch (InvocationException ie) {
            results.add(new JdiTestResultError(className, methodName, methodName, "Internal invocation error", "", null, 0));
            testResultsWithRunTime.setResults(results);
            testResultsWithRunTime.setTotalRunTime(0);
            return testResultsWithRunTime;
        }
        catch (VMDisconnectedException vmde) {
            results.add(new JdiTestResultError(className, "", "", "VM restarted", "", null, 0));
            testResultsWithRunTime.setResults(results);
            testResultsWithRunTime.setTotalRunTime(0);
            return testResultsWithRunTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void disposeWindows() {
        VMReference vmr = this.getVMNoWait();
        try {
            Object object = this.serverThreadLock;
            synchronized (object) {
                if (vmr != null) {
                    vmr.disposeWindows();
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult runClassMain(String className) throws ClassNotFoundException {
        VMReference vmr = this.getVM();
        Object object = this.serverThreadLock;
        synchronized (object) {
            if (vmr != null) {
                return vmr.runShellClass(className);
            }
            return new DebuggerResult(4);
        }
    }

    @Override
    public CompletableFuture<FXPlatformSupplier<DebuggerResult>> launchFXApp(final String className) {
        final CompletableFuture<FXPlatformSupplier<DebuggerResult>> result = new CompletableFuture<FXPlatformSupplier<DebuggerResult>>();
        BlueJEventListener listener = new BlueJEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blueJEvent(int eventId, Object arg, Project prj) {
                if (eventId == 2) {
                    BlueJEvent.removeListener(this);
                    VMReference vmr = JdiDebugger.this.getVM();
                    if (vmr != null) {
                        Object object = JdiDebugger.this.serverThreadLock;
                        synchronized (object) {
                            result.complete(vmr.launchFXApp(className));
                        }
                    } else {
                        result.complete(() -> new DebuggerResult(4));
                    }
                }
            }
        };
        BlueJEvent.addListener(listener);
        this.close(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult instantiateClass(String className) {
        VMReference vmr = this.getVM();
        if (vmr != null) {
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className);
            }
        }
        return new DebuggerResult(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult instantiateClass(String className, String[] paramTypes, DebuggerObject[] args) {
        if (paramTypes == null || args == null || paramTypes.length == 0 || args.length == 0) {
            return this.instantiateClass(className);
        }
        VMReference vmr = this.getVM();
        if (vmr != null) {
            ObjectReference[] orArgs = new ObjectReference[args.length];
            for (int i = 0; i < args.length; ++i) {
                JdiObject jdiObject = (JdiObject)args[i];
                orArgs[i] = jdiObject.getObjectReference();
            }
            Object object = this.serverThreadLock;
            synchronized (object) {
                return vmr.instantiateClass(className, paramTypes, orArgs);
            }
        }
        return new DebuggerResult(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.NOTVMEventHandler)
    public FXPlatformSupplier<DebuggerClass> getClass(String className, boolean initialize) throws ClassNotFoundException {
        ReferenceType classMirror;
        VMReference vmr = this.getVM();
        if (vmr == null) {
            throw new ClassNotFoundException("Virtual machine terminated.");
        }
        Object object = this.serverThreadLock;
        synchronized (object) {
            classMirror = initialize && this.machineState != 3 ? vmr.loadInitClass(className) : vmr.loadClass(className);
        }
        return () -> new JdiClass(classMirror);
    }

    @OnThread(value=Tag.VMEventHandler)
    private void fireTargetEvent(DebuggerEvent ce, boolean skipUpdate) {
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].processDebuggerEvent(ce, skipUpdate);
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    void raiseStateChangeEvent(int newState) {
        if (newState != this.machineState) {
            if (this.machineState == 4 && newState != 3) {
                this.doStateChange(4, 3);
            }
            if (this.machineState == 3 && newState == 1) {
                this.doStateChange(3, 2);
            }
            this.doStateChange(this.machineState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.VMEventHandler)
    private void doStateChange(int oldState, int newState) {
        DebuggerListener[] debuggerListenerArray = this.listenerList;
        synchronized (this.listenerList) {
            DebuggerListener[] ll = this.listenerList.toArray(new DebuggerListener[this.listenerList.size()]);
            this.machineState = newState;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (DebuggerListener l : ll) {
                l.processDebuggerEvent(new DebuggerEvent((Object)this, 1, oldState, newState), false);
            }
            return;
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean toggleBreakpoint(String className, int line, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, line, properties);
                }
                return vmr.clearBreakpoint(className, line);
            }
            return false;
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return false;
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean toggleBreakpoint(String className, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                if (set) {
                    return vmr.setBreakpoint(className, method, properties);
                }
                return vmr.clearBreakpoint(className, method);
            }
            return false;
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return false;
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean toggleBreakpoint(DebuggerClass debuggerClass, String method, boolean set, Map<String, String> properties) {
        VMReference vmr = this.getVM();
        try {
            if (vmr != null) {
                JdiClass jdiClass = (JdiClass)debuggerClass;
                if (set) {
                    return vmr.setBreakpoint(jdiClass.remoteClass, method, properties);
                }
                return vmr.clearBreakpoint(jdiClass.remoteClass, method);
            }
            return false;
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            e.printStackTrace(System.out);
            return false;
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    public void breakpoint(ThreadReference tr, int debuggerEventType, boolean skipUpdate, DebuggerEvent.BreakpointProperties props) {
        JdiThread breakThread = this.allThreads.find(tr);
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(breakThread, true);
        }
        this.fireTargetEvent(new DebuggerEvent(this, debuggerEventType, breakThread, props), skipUpdate);
    }

    @OnThread(value=Tag.VMEventHandler)
    public boolean screenBreakpoint(ThreadReference thread, int debuggerEventType, DebuggerEvent.BreakpointProperties props) {
        JdiThread breakThread = this.allThreads.find(thread);
        breakThread.stopped();
        DebuggerEvent event = new DebuggerEvent(this, debuggerEventType, breakThread, props);
        boolean done = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            done = done || listeners[i].examineDebuggerEvent(event);
        }
        return done;
    }

    @OnThread(value=Tag.VMEventHandler)
    synchronized void vmDisconnect() {
        if (this.autoRestart) {
            this.allThreads.clear();
            if (this.vmRef != null) {
                if (!this.selfRestart) {
                    this.machineLoader = new MachineLoaderThread();
                }
                this.selfRestart = true;
                this.vmRef.closeIO();
                this.vmRef = null;
                this.raiseStateChangeEvent(1);
                this.launch();
                this.usedNames.clear();
                this.threadListener.clearThreads();
            }
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    void threadStart(ThreadReference tr) {
        JdiThread newThread = new JdiThread(this, tr);
        this.allThreads.add(newThread);
        this.threadListener.addThread(newThread);
    }

    @OnThread(value=Tag.VMEventHandler)
    void threadDeath(ThreadReference tr) {
        JdiThread jdiThread = this.allThreads.removeThread(tr);
        if (jdiThread != null) {
            this.threadListener.removeThread(jdiThread);
        }
    }

    @OnThread(value=Tag.Any)
    private VMReference getVM() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVM();
    }

    @OnThread(value=Tag.Any)
    private VMReference getVMNoWait() {
        MachineLoaderThread mlt = this.machineLoader;
        if (mlt == null) {
            return null;
        }
        return mlt.getVMNoWait();
    }

    @OnThread(value=Tag.Any)
    void emitThreadHaltEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, true);
    }

    @OnThread(value=Tag.Any)
    void emitThreadResumedEvent(JdiThread thread) {
        this.vmRef.emitThreadEvent(thread, false);
    }

    @OnThread(value=Tag.VMEventHandler)
    void threadHalted(JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 2, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(thread, false);
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    @OnThread(value=Tag.VMEventHandler)
    void threadResumed(JdiThread thread) {
        DebuggerEvent event = new DebuggerEvent(this, 6, thread, null);
        boolean skipUpdate = false;
        DebuggerListener[] listeners = this.getListeners();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            skipUpdate |= listeners[i].examineDebuggerEvent(event);
        }
        if (!skipUpdate) {
            this.threadListener.threadStateChanged(thread, false);
        }
        this.fireTargetEvent(event, skipUpdate);
    }

    @OnThread(value=Tag.VMEventHandler)
    public JdiThread findThread(ThreadReference thread) {
        return this.allThreads.find(thread);
    }

    @Override
    public synchronized void setRunOnThread(RunOnThread runOnThread) {
        this.runOnThread = runOnThread;
        if (this.vmRef != null) {
            this.getVM().setRunOnThread(runOnThread);
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void runOnEventHandler(Debugger.EventHandlerRunnable runnable) {
        VMReference vmReference = this.getVMNoWait();
        if (vmReference != null) {
            vmReference.runOnEventHandler(runnable);
        } else {
            Debug.printCallStack("Could not run EventHandlerRunnable as VM not initialised");
        }
    }

    class MachineLoaderThread
    extends Thread {
        @OnThread(value=Tag.Any)
        MachineLoaderThread() {
            super("Machine Loader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @OnThread(value=Tag.Worker, ignoreParent=true)
        public void run() {
            try {
                BPClassLoader lastLoader;
                VMReference newVM = new VMReference(JdiDebugger.this, JdiDebugger.this.terminal, JdiDebugger.this.startingDirectory, JdiDebugger.this.libraries);
                JdiDebugger jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    if (!JdiDebugger.this.autoRestart) {
                        newVM.close();
                        JdiDebugger.this.notifyAll();
                        return;
                    }
                    lastLoader = JdiDebugger.this.lastProjectClassLoader;
                }
                newVM.newClassLoader(lastLoader.getURLs());
                newVM.setRunOnThread(JdiDebugger.this.runOnThread);
                jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    JdiDebugger.this.vmRef = newVM;
                }
            }
            catch (JdiVmCreationException e) {
                this.launchFailed();
            }
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                JdiDebugger.this.notifyAll();
            }
        }

        @OnThread(value=Tag.Any)
        private void launchFailed() {
            JdiDebugger.this.raiseStateChangeEvent(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Any)
        private VMReference getVM() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                while (JdiDebugger.this.vmRef == null && JdiDebugger.this.autoRestart) {
                    try {
                        JdiDebugger.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return JdiDebugger.this.vmRef;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnThread(value=Tag.Any)
        private VMReference getVMNoWait() {
            JdiDebugger jdiDebugger = JdiDebugger.this;
            synchronized (jdiDebugger) {
                return JdiDebugger.this.vmRef;
            }
        }
    }
}

