/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.gentype.JavaType;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class AssertPanel
extends HBox {
    private static final String equalToLabel = Config.getString("debugger.assert.equalTo");
    private static final String sameAsLabel = Config.getString("debugger.assert.sameAs");
    private static final String notSameAsLabel = Config.getString("debugger.assert.notSameAs");
    private static final String notNullLabel = Config.getString("debugger.assert.notNull");
    private static final String assertNullLabel = Config.getString("debugger.assert.null");
    private static final String equalToFloatingPointLabel = Config.getString("debugger.assert.equalToFloatingPoint");
    private Pane standardPanel;
    private Label deltaLabel;
    private TextField assertData;
    private TextField deltaData;
    private ComboBox<AssertInfo> assertCombo;
    protected CheckBox assertCheckbox;
    private Consumer<Boolean> updateCaller = null;
    private final ObservableList<AssertInfo> asserts = FXCollections.observableArrayList((Object[])new AssertInfo[]{new AssertInfo(equalToLabel, "assertEquals", 1, false, true, true), new AssertInfo(sameAsLabel, "assertSame", 1, false, true, false), new AssertInfo(notSameAsLabel, "assertNotSame", 1, false, true, false), new AssertInfo(notNullLabel, "assertNotNull", 0, false, true, false), new AssertInfo(assertNullLabel, "assertNull", 0, false, true, false), new AssertInfo(equalToFloatingPointLabel, "assertEquals", 2, true, false, false)});

    public AssertPanel(JavaType type, Consumer<Boolean> updateCaller) {
        JavaFXUtil.addStyleClass((Styleable)this, "assert-panel");
        this.updateCaller = updateCaller;
        boolean isFloat = type.typeIs(JavaType.JT_FLOAT) || type.typeIs(JavaType.JT_DOUBLE);
        this.assertCheckbox = new CheckBox(Config.getString("debugger.assert.assertThatResIs"));
        JavaFXUtil.addStyleClass((Styleable)this.assertCheckbox, "assert-checkbox");
        JavaFXUtil.addChangeListenerPlatform(this.assertCheckbox.selectedProperty(), b -> this.update());
        this.standardPanel = new VBox();
        HBox assertPartHBox = new HBox();
        JavaFXUtil.addStyleClass((Styleable)assertPartHBox, "assert-row");
        this.assertCombo = new ComboBox();
        assertPartHBox.getChildren().add(this.assertCombo);
        this.assertData = new TextField();
        JavaFXUtil.addStyleClass((Styleable)this.assertData, "assert-field-data");
        JavaFXUtil.addChangeListenerPlatform(this.assertData.textProperty(), s -> this.update());
        assertPartHBox.getChildren().add((Object)this.assertData);
        this.standardPanel.getChildren().add((Object)assertPartHBox);
        HBox deltaPartHBox = new HBox();
        JavaFXUtil.addStyleClass((Styleable)deltaPartHBox, "delta-row");
        this.deltaLabel = new Label(Config.getString("debugger.assert.delta"));
        deltaPartHBox.getChildren().add((Object)this.deltaLabel);
        JavaFXUtil.addStyleClass((Styleable)this.deltaLabel, "delta-label");
        this.deltaLabel.setVisible(false);
        this.deltaData = new TextField("0.1");
        JavaFXUtil.addStyleClass((Styleable)this.deltaData, "assert-field-delta");
        JavaFXUtil.addChangeListenerPlatform(this.deltaData.textProperty(), s -> this.update());
        deltaPartHBox.getChildren().add((Object)this.deltaData);
        this.deltaData.setVisible(false);
        this.deltaData.visibleProperty().set(isFloat);
        this.deltaData.managedProperty().set(isFloat);
        this.deltaLabel.visibleProperty().set(isFloat);
        this.deltaLabel.managedProperty().set(isFloat);
        this.standardPanel.getChildren().add((Object)deltaPartHBox);
        this.getChildren().add((Object)this.assertCheckbox);
        this.getChildren().add((Object)this.standardPanel);
        this.assertCheckbox.setSelected(true);
        this.assertCombo.setItems((ObservableList)this.asserts.filtered(a -> {
            if (isFloat) {
                return a.supportsFloatingPoint;
            }
            if (type.isPrimitive()) {
                return a.supportsPrimitive;
            }
            return a.supportsObject;
        }));
        this.assertCombo.getSelectionModel().select(0);
        this.update();
    }

    private static <T> BooleanBinding ofB(ObservableValue<T> t, Function<T, Boolean> accessor) {
        return Bindings.createBooleanBinding(() -> (Boolean)accessor.apply(t.getValue()), (Observable[])new Observable[]{t});
    }

    private boolean isAssertComplete() {
        if (!this.assertCheckbox.isSelected()) {
            return true;
        }
        AssertInfo info = (AssertInfo)this.assertCombo.getSelectionModel().getSelectedItem();
        if (info == null) {
            return false;
        }
        if (info.needsSecondField() && this.deltaData.getText().trim().length() == 0) {
            return false;
        }
        return !info.needsFirstField() || this.assertData.getText().trim().length() != 0;
    }

    public boolean isAssertEnabled() {
        return this.assertCheckbox != null ? this.assertCheckbox.isSelected() : false;
    }

    private void update() {
        boolean isChecked = this.isAssertEnabled();
        this.assertCombo.setDisable(!isChecked);
        this.assertData.setDisable(!isChecked || !AssertPanel.ofB(this.assertCombo.getSelectionModel().selectedItemProperty(), ai -> ai == null ? false : ai.needsFirstField()).get());
        boolean disableDelta = !this.isAssertEnabled() || !AssertPanel.ofB(this.assertCombo.getSelectionModel().selectedItemProperty(), ai -> ai == null ? false : ai.needsSecondField()).get();
        this.deltaLabel.setDisable(disableDelta);
        this.deltaData.setDisable(disableDelta);
        if (this.updateCaller != null) {
            this.updateCaller.accept(this.isAssertComplete());
        }
    }

    public String getAssertStatement() {
        AssertInfo info = (AssertInfo)this.assertCombo.getSelectionModel().getSelectedItem();
        if (info.needsSecondField()) {
            return InvokerRecord.makeAssertionStatement(info.assertMethodName, this.assertData.getText(), this.deltaData.getText());
        }
        if (info.needsFirstField()) {
            return InvokerRecord.makeAssertionStatement(info.assertMethodName, this.assertData.getText());
        }
        return InvokerRecord.makeAssertionStatement(info.assertMethodName);
    }

    public void recordAssertion(Package pkg, FXPlatformSupplier<Optional<Integer>> testIdentifier, int invocationIdentifier) {
        AssertInfo info = (AssertInfo)this.assertCombo.getSelectionModel().getSelectedItem();
        String param1 = info.needsFirstField() ? this.assertData.getText() : null;
        String param2 = info.needsSecondField() ? this.deltaData.getText() : null;
        Optional<Integer> optTestId = testIdentifier.get();
        optTestId.ifPresent(testId -> DataCollector.assertTestMethod(pkg, testId, invocationIdentifier, info.assertMethodName, param1, param2));
    }

    private static class AssertInfo {
        public final String label;
        public final String assertMethodName;
        public final int fieldsNeeded;
        public final boolean supportsFloatingPoint;
        public final boolean supportsObject;
        public final boolean supportsPrimitive;

        public AssertInfo(String label, String assertMethodName, int fieldsNeeded, boolean supportsFloatingPoint, boolean supportsObject, boolean supportsPrimitive) {
            this.label = label;
            this.assertMethodName = assertMethodName;
            this.fieldsNeeded = fieldsNeeded;
            this.supportsFloatingPoint = supportsFloatingPoint;
            this.supportsObject = supportsObject;
            this.supportsPrimitive = supportsPrimitive;
        }

        public boolean needsFirstField() {
            return this.fieldsNeeded >= 1;
        }

        public boolean needsSecondField() {
            return this.fieldsNeeded >= 2;
        }

        public String toString() {
            return this.label;
        }
    }
}

