/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.inspector.ObjectBackground;
import bluej.debugmgr.objectbench.ArrayWrapper;
import bluej.debugmgr.objectbench.BluejResultWatcher;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.extensions2.BObject;
import bluej.extensions2.ExtensionBridge;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.ExtensionsMenuManager;
import bluej.extmgr.ObjectExtensionMenu;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableRectangle;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.binding.When;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectWrapper
extends StackPane
implements InvokeListener,
NamedValue {
    static final @OnThread(value=Tag.Any) String methodException = Config.getString("debugger.objectwrapper.methodException");
    static final @OnThread(value=Tag.Any) String invocationException = Config.getString("debugger.objectwrapper.invocationException");
    static final @OnThread(value=Tag.Any) String inspect = Config.getString("debugger.objectwrapper.inspect");
    static final @OnThread(value=Tag.Any) String remove = Config.getString("debugger.objectwrapper.remove");
    static final @OnThread(value=Tag.Any) String redefinedIn = Config.getString("debugger.objectwrapper.redefined");
    static final @OnThread(value=Tag.Any) String inheritedFrom = Config.getString("debugger.objectwrapper.inherited");
    public static final int WIDTH = 100;
    public static final int HEIGHT = 70;
    public static final double CORNER_SIZE = 36.0;
    public static final double FOCUSED_BORDER = 3.0;
    public static final double UNFOCUSED_BORDER = 1.0;
    public static final double SHADOW_RADIUS = 3.0;
    private static int itemHeight = 28;
    private static boolean itemHeightKnown = false;
    private static @OnThread(value=Tag.Any) int itemsOnScreen;
    protected final @OnThread(value=Tag.Any) DebuggerObject obj;
    private final String objClassName;
    protected @OnThread(value=Tag.Any) GenTypeClass iType;
    private final String className;
    private @OnThread(value=Tag.Any, requireSynchronized=true) String objInstanceName;
    protected String displayClassName;
    protected ContextMenu menu;
    protected final Rectangle highlight = new ResizableRectangle();
    private final Package pkg;
    private final PkgMgrFrame pmf;
    private final ObjectBench ob;
    private static final String MENU_STYLE_INBUILT = "object-action-inbuilt";
    private @OnThread(value=Tag.Any, requireSynchronized=true) BObject singleBObject;

    @OnThread(value=Tag.FXPlatform)
    public static ObjectWrapper getWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (obj.isArray()) {
            return new ArrayWrapper(pmf, ob, obj, instanceName);
        }
        return new ObjectWrapper(pmf, ob, obj, iType, instanceName);
    }

    @OnThread(value=Tag.FXPlatform)
    protected ObjectWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (!itemHeightKnown) {
            itemsOnScreen = (int)Config.getScreenBounds().getHeight() / itemHeight;
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.ob = ob;
        this.obj = obj;
        this.objClassName = obj.getClassName();
        this.iType = iType;
        this.setName(instanceName);
        if (obj.isNullObject()) {
            this.className = "";
            this.displayClassName = "";
        } else {
            GenTypeClass objType = obj.getGenType();
            this.className = objType.toString();
            this.displayClassName = objType.toString(true);
        }
        Class<?> cl = this.findIType();
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        this.createMenu(extMgr, cl);
        JavaFXUtil.listenForContextMenu((Node)this, (x, y) -> {
            this.menu.show((Node)this, x.doubleValue(), y.doubleValue());
            return true;
        }, KeyCode.SPACE, KeyCode.ENTER);
        this.setMinWidth(100.0);
        this.setMinHeight(70.0);
        this.setMaxWidth(100.0);
        this.setMaxHeight(70.0);
        this.setCursor(Cursor.HAND);
        this.setFocusTraversable(true);
        this.setOnMouseClicked(this::clicked);
        JavaFXUtil.addFocusListener((Node)this, focused -> {
            if (focused.booleanValue()) {
                ob.objectGotFocus(this);
            } else if (ob.getSelectedObject() == this) {
                ob.setSelectedObject(null);
            }
        });
        JavaFXUtil.addStyleClass((Styleable)this, "object-wrapper");
        Label label = new Label(this.getName() + ":\n" + this.displayClassName);
        this.setAccessibleText(label.getText() + " Object");
        this.setAccessibleRole(AccessibleRole.NODE);
        JavaFXUtil.addStyleClass((Styleable)label, "object-wrapper-text");
        this.createComponent(label);
        this.highlight.setMouseTransparent(true);
        this.highlight.setVisible(false);
        this.highlight.getStyleClass().add((Object)"object-debug-highlight");
    }

    protected void createComponent(Label label) {
        this.getChildren().addAll((Object[])new Node[]{new ObjectBackground(36.0, (ObservableDoubleValue)new When((ObservableBooleanValue)this.focusedProperty()).then(3.0).otherwise(1.0)), label, this.highlight});
        this.setBackground(null);
        this.setEffect((Effect)new DropShadow(3.0, 1.5, 1.5, Color.GRAY));
    }

    @OnThread(value=Tag.Any)
    public Package getPackage() {
        return this.pkg;
    }

    public PkgMgrFrame getFrame() {
        return this.pmf;
    }

    @OnThread(value=Tag.Any)
    public String getClassName() {
        return this.objClassName;
    }

    @OnThread(value=Tag.Any)
    public String getTypeName() {
        return this.className;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getGenType() {
        return this.iType;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isFinal() {
        return true;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isInitialized() {
        return true;
    }

    public final synchronized BObject getBObject() {
        if (this.singleBObject == null) {
            this.singleBObject = ExtensionBridge.newBObject((ObjectWrapper)this);
        }
        return this.singleBObject;
    }

    public void prepareRemove() {
        Project proj = this.pkg.getProject();
        proj.removeInspectorInstance(this.obj);
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean classIsAccessible(Class<?> cl) {
        int clMods = cl.getModifiers();
        String classPackage = JavaNames.getPrefix(cl.getName());
        return (!Modifier.isProtected(clMods) || this.pkg.getQualifiedName().equals(classPackage)) && !Modifier.isPrivate(clMods);
    }

    private Class<?> unwrapArrays(String className) {
        String memberType = className.substring(0, className.length() - 2);
        if (memberType.endsWith("[]")) {
            return Array.newInstance(this.unwrapArrays(memberType), 0).getClass();
        }
        switch (memberType) {
            case "boolean": {
                return boolean[].class;
            }
            case "byte": {
                return byte[].class;
            }
            case "short": {
                return short[].class;
            }
            case "int": {
                return int[].class;
            }
            case "long": {
                return long[].class;
            }
            case "float": {
                return float[].class;
            }
            case "double": {
                return double[].class;
            }
            case "char": {
                return char[].class;
            }
        }
        return Array.newInstance(this.pkg.loadClass(memberType), 0).getClass();
    }

    @OnThread(value=Tag.FXPlatform)
    private Class<?> findIType() {
        String className = this.obj.getClassName();
        Class<?> cl = this.pkg.loadClass(className);
        if (cl == null && this.obj.isArray() && className.endsWith("[]")) {
            cl = this.unwrapArrays(className);
        }
        if (cl != null) {
            if (!this.classIsAccessible(cl)) {
                cl = this.pkg.loadClass(this.iType.classloaderName());
                while (cl != null && !this.classIsAccessible(cl)) {
                    if ((cl = cl.getSuperclass()) != null) {
                        this.iType = this.iType.mapToSuper(cl.getName());
                        continue;
                    }
                    JavaReflective objectReflective = new JavaReflective(Object.class);
                    this.iType = new GenTypeClass(objectReflective);
                }
            } else {
                this.iType = this.obj.getGenType();
            }
        }
        return cl;
    }

    protected void createMenu(ExtensionsManager extMgr, Class<?> cl) {
        this.menu = new ContextMenu();
        ObjectWrapper.createMethodMenuItems((ObservableList<MenuItem>)this.menu.getItems(), cl, this.iType, this, this.pkg.getQualifiedName(), true);
        MenuItem item = new MenuItem(inspect);
        this.menu.getItems().add((Object)item);
        JavaFXUtil.addStyleClass((Styleable)item, MENU_STYLE_INBUILT);
        item.setOnAction(e -> this.inspectObject());
        item = new MenuItem(remove);
        this.menu.getItems().add((Object)item);
        JavaFXUtil.addStyleClass((Styleable)item, MENU_STYLE_INBUILT);
        item.setOnAction(e -> this.removeObject());
        ExtensionsMenuManager menuManager = new ExtensionsMenuManager(this.menu, extMgr, (ExtensionMenu)new ObjectExtensionMenu(this));
        menuManager.addExtensionMenu(this.pkg.getProject());
    }

    public static void createMethodMenuItems(ObservableList<MenuItem> menu, Class<?> cl, InvokeListener il, String currentPackageName, boolean showObjectMethods) {
        GenTypeClass gt = new GenTypeClass(new JavaReflective(cl));
        ObjectWrapper.createMethodMenuItems(menu, cl, gt, il, currentPackageName, showObjectMethods);
    }

    public static void createMethodMenuItems(ObservableList<MenuItem> menu, Class<?> cl, GenTypeClass gtype, InvokeListener il, String currentPackageName, boolean showObjectMethods) {
        if (cl != null) {
            Menu subMenu;
            View view = View.getView(cl);
            Hashtable<String, String> methodsUsed = new Hashtable<String, String>();
            List<Class<?>> classes = ObjectWrapper.getClassHierarchy(cl);
            ViewFilter filter = new ViewFilter(ViewFilter.StaticOrInstance.INSTANCE, currentPackageName);
            menu.add((Object)new SeparatorMenuItem());
            MethodView[] declaredMethods = view.getDeclaredMethods();
            GenTypeClass curType = gtype;
            if (curType == null) {
                curType = new GenTypeClass(new JavaReflective(cl));
            }
            if (itemsOnScreen <= 0) {
                itemsOnScreen = 30;
            }
            int itemLimit = itemsOnScreen - 8 - classes.size();
            ObjectWrapper.createMenuItems(menu, declaredMethods, il, filter, itemLimit, curType.getMap(), methodsUsed);
            for (int i = 1; i < classes.size(); ++i) {
                Class<?> currentClass = classes.get(i);
                view = View.getView(currentClass);
                filter = new ViewFilter(ViewFilter.StaticOrInstance.INSTANCE, currentPackageName);
                curType = curType.mapToSuper(currentClass.getName());
                if ("java.lang.Object".equals(currentClass.getName()) && !showObjectMethods) continue;
                declaredMethods = view.getDeclaredMethods();
                subMenu = new Menu(inheritedFrom + " " + JavaNames.stripPrefix(currentClass.getName()));
                ObjectWrapper.createMenuItems((List<MenuItem>)subMenu.getItems(), declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                menu.add(0, (Object)subMenu);
            }
            for (Class<?> iface : ObjectWrapper.getInterfacesWithDefaultMethods(cl)) {
                view = View.getView(iface);
                declaredMethods = view.getDeclaredMethods();
                subMenu = new Menu(inheritedFrom + " " + JavaNames.stripPrefix(iface.getName()));
                ObjectWrapper.createMenuItems((List<MenuItem>)subMenu.getItems(), declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), methodsUsed);
                menu.add(0, (Object)subMenu);
            }
            menu.add((Object)new SeparatorMenuItem());
        }
    }

    private static void createMenuItems(List<MenuItem> menu, MethodView[] methods, InvokeListener il, ViewFilter filter, int sizeLimit, Map<String, GenTypeParameter> genericParams, Hashtable<String, String> methodsUsed) {
        boolean menuEmpty = true;
        Arrays.sort(methods);
        for (MethodView method : methods) {
            try {
                if (!filter.test(method)) continue;
                menuEmpty = false;
                String methodSignature = method.getCallSignature();
                Object methodDescription = method.getLongDesc(genericParams);
                if (methodsUsed.containsKey(methodSignature)) {
                    methodDescription = (String)methodDescription + "   [ " + redefinedIn + " " + JavaNames.stripPrefix(methodsUsed.get(methodSignature)) + " ]";
                } else {
                    methodsUsed.put(methodSignature, method.getClassName());
                }
                MenuItem item = new MenuItem((String)methodDescription);
                item.setMnemonicParsing(false);
                item.setOnAction(e -> il.executeMethod(method));
                int itemCount = menu.size();
                if (itemCount >= sizeLimit) {
                    Menu subMenu = new Menu(Config.getString("debugger.objectwrapper.moreMethods"));
                    menu.add((MenuItem)subMenu);
                    menu = subMenu.getItems();
                    sizeLimit = itemsOnScreen / 2;
                }
                menu.add((MenuItem)item);
            }
            catch (Exception e2) {
                Debug.reportError(methodException + e2);
                e2.printStackTrace();
            }
        }
        if (menuEmpty) {
            MenuItem mi = new MenuItem(Config.getString("debugger.objectwrapper.noMethods"));
            mi.setDisable(true);
            menu.add((MenuItem)mi);
        }
    }

    @OnThread(value=Tag.Any)
    private static List<Class<?>> getClassHierarchy(Class<?> derivedClass) {
        ArrayList classVector = new ArrayList();
        for (Class<?> currentClass = derivedClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            classVector.add(currentClass);
        }
        return classVector;
    }

    @OnThread(value=Tag.Any)
    private static List<Class<?>> getInterfacesWithDefaultMethods(Class<?> cls) {
        return ObjectWrapper.getClassHierarchy(cls).stream().flatMap(c -> Arrays.stream(c.getInterfaces())).filter(i -> Arrays.stream(i.getDeclaredMethods()).anyMatch(m -> m.isDefault())).collect(Collectors.toList());
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) String getName() {
        return this.objInstanceName;
    }

    @OnThread(value=Tag.Any)
    public synchronized void setName(String newName) {
        this.objInstanceName = newName;
    }

    @OnThread(value=Tag.Any)
    public DebuggerObject getObject() {
        return this.obj;
    }

    private void clicked(MouseEvent evt) {
        if (!evt.isPopupTrigger() && evt.getButton() == MouseButton.PRIMARY) {
            if (evt.getClickCount() > 1) {
                this.inspectObject();
            } else {
                this.ob.fireObjectSelectedEvent(this);
            }
        }
        this.requestFocus();
    }

    @OnThread(value=Tag.FXPlatform)
    protected void inspectObject() {
        ObjectInspectInvokerRecord ir = new ObjectInspectInvokerRecord(this.getName());
        this.pkg.getProject().getInspectorInstance(this.obj, this.getName(), this.pkg, ir, (Window)this.pmf.getWindow(), (Node)this);
    }

    protected void removeObject() {
        this.ob.removeObject(this, this.pkg.getId());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void executeMethod(MethodView method) {
        BluejResultWatcher watcher = null;
        this.pkg.forgetLastSource();
        String instanceName = this.getName();
        watcher = new BluejResultWatcher(this.obj, instanceName, this.pkg, this.pmf, method){

            @Override
            protected void addInteraction(InvokerRecord ir) {
                ObjectWrapper.this.ob.addInteraction(ir);
            }
        };
        if (this.pmf.checkDebuggerState()) {
            Invoker invoker = new Invoker(this.pmf, method, instanceName, this.obj, watcher);
            invoker.invokeInteractive();
        }
    }

    @Override
    public void callConstructor(ConstructorView cv) {
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.pmf.setStatus(this.getName() + " : " + this.displayClassName);
        }
    }

    public void showMenu() {
        this.menu.show((Node)this, Side.LEFT, 5.0, 5.0);
    }

    public void animateIn(Optional<Point2D> animateFromScenePoint) {
        this.setScaleX(0.2);
        this.setScaleY(0.2);
        JavaFXUtil.listenOnce(this.layoutYProperty(), layoutY -> {
            this.setVisible(true);
            ScaleTransition scale = new ScaleTransition(Duration.millis((double)300.0), (Node)this);
            scale.setFromX(0.2);
            scale.setFromY(0.2);
            scale.setToX(1.0);
            scale.setToY(1.0);
            if (animateFromScenePoint.isPresent()) {
                TranslateTransition move = new TranslateTransition(Duration.millis((double)300.0), (Node)this);
                Point2D local = this.sceneToLocal((Point2D)animateFromScenePoint.get());
                move.setFromX(local.getX());
                move.setFromY(local.getY());
                move.setToX(0.0);
                move.setToY(0.0);
                if (Math.hypot(local.getX(), local.getY()) >= 300.0) {
                    scale.setDuration(Duration.millis((double)600.0));
                    move.setDuration(Duration.millis((double)600.0));
                }
                new ParallelTransition(new Animation[]{scale, move}).play();
            } else {
                scale.play();
            }
        });
    }

    public void animateOut(FXPlatformRunnable after) {
        ScaleTransition t = new ScaleTransition(Duration.millis((double)300.0), (Node)this);
        t.setToX(0.0);
        t.setToY(0.0);
        t.setOnFinished(e -> {
            if (after != null) {
                after.run();
            }
        });
        t.play();
    }

    public void setHighlight(boolean highlightOn) {
        this.highlight.setVisible(highlightOn);
    }
}

