/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.Config;
import bluej.extensions2.BlueJ;
import bluej.extensions2.Extension;
import bluej.extensions2.ExtensionBridge;
import bluej.extensions2.ExternalFileLauncher;
import bluej.extensions2.PreferenceGenerator;
import bluej.extensions2.event.ExtensionEvent;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionPrefManager;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExtensionWrapper {
    private final ExtensionPrefManager prefManager;
    private File extensionJarFileName;
    private Class<?> extensionClass;
    private Extension extensionInstance;
    private BlueJ extensionBluej;
    private String extensionStatusString;
    private Project project;

    public ExtensionWrapper(ExtensionPrefManager prefManager, File jarFile) {
        this.prefManager = prefManager;
        this.extensionClass = this.getExtensionClass(jarFile);
        if (this.extensionClass == null) {
            return;
        }
        this.extensionJarFileName = jarFile;
    }

    private Class<?> getExtensionClass(File jarFileName) {
        Class<?> extensionClass = null;
        this.extensionStatusString = Config.getString("extmgr.status.loading");
        if (jarFileName == null) {
            return null;
        }
        if (!jarFileName.getName().endsWith(".jar")) {
            return null;
        }
        String errorPrefix = "getExtensionsClass: jarFile=" + jarFileName.getName() + " ";
        try {
            JarFile jarFile = new JarFile(jarFileName);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.nomanifest"));
                return null;
            }
            String className = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (className == null) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.nomain"));
                return null;
            }
            URL url = jarFileName.toURI().toURL();
            URL[] urlList = new URL[]{url};
            FirewallLoader fireLoader = new FirewallLoader(this.getClass().getClassLoader());
            URLClassLoader ucl = new URLClassLoader(urlList, (ClassLoader)fireLoader);
            extensionClass = ucl.loadClass(className);
            if (!Extension.class.isAssignableFrom(extensionClass)) {
                Debug.message(errorPrefix + Config.getString("extmgr.error.notsubclass"));
                return null;
            }
        }
        catch (Throwable exc) {
            Debug.message(errorPrefix + "Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return extensionClass;
    }

    void newExtension(Project aProject) {
        if (this.extensionClass == null) {
            return;
        }
        this.project = aProject;
        this.extensionBluej = ExtensionBridge.newBluej((ExtensionWrapper)this, (ExtensionPrefManager)this.prefManager);
        try {
            this.extensionInstance = (Extension)this.extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            this.extensionInstance = null;
            this.extensionStatusString = "newExtension: Exception=" + ex.getMessage();
            return;
        }
        if (!this.safeIsCompatible()) {
            this.extensionStatusString = Config.getString("extmgr.status.badversion");
            this.extensionInstance = null;
            return;
        }
        this.safeStartup(this.extensionBluej);
        this.extensionStatusString = Config.getString("extmgr.status.loaded");
    }

    Project getProject() {
        return this.project;
    }

    public boolean isValid() {
        return this.extensionInstance != null;
    }

    boolean isJarValid() {
        return this.extensionClass != null;
    }

    void terminate() {
        this.safeTerminate();
        this.extensionInstance = null;
        this.prefManager.panelRevalidate();
    }

    public String getExtensionStatus() {
        return this.extensionStatusString;
    }

    public String getExtensionClassName() {
        if (this.extensionClass == null) {
            return null;
        }
        return this.extensionClass.getName();
    }

    public Properties getLabelProperties() {
        String localLanguage = Config.getPropString("bluej.language", "english");
        Properties extensionsProps = this.getLabelProperties(localLanguage);
        if (extensionsProps != null) {
            return extensionsProps;
        }
        extensionsProps = this.getLabelProperties("english");
        return extensionsProps;
    }

    private Properties getLabelProperties(String language) {
        if (this.extensionClass == null) {
            return null;
        }
        String languageFileName = "lib/" + language + "/labels";
        InputStream inStream = this.extensionClass.getClassLoader().getResourceAsStream(languageFileName);
        if (inStream == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(inStream);
        }
        catch (Exception ex) {
            Debug.message("ExtensionWrapper.getLabelProperties(): Exception=" + ex.getMessage());
        }
        ExtensionWrapper.closeInputStream(inStream);
        return props;
    }

    public static void closeInputStream(InputStream aStream) {
        try {
            aStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExtensionFileName() {
        if (this.extensionJarFileName == null) {
            return null;
        }
        return this.extensionJarFileName.getPath();
    }

    public String getSettingsString(String key) {
        return "extensions." + this.getExtensionClassName() + ".settings." + key;
    }

    public String toString() {
        if (!this.isValid()) {
            return "ExtensionWrapper: invalid";
        }
        return "ExtensionWrapper: " + this.extensionClass.getName();
    }

    public void safeEventOccurred(ExtensionEvent event) {
        if (!this.isValid()) {
            return;
        }
        try {
            ExtensionBridge.delegateEvent((BlueJ)this.extensionBluej, (ExtensionEvent)event);
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeEventOccurred: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return;
        }
    }

    public String safeGetExtensionDescription() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getDescription();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionDescription: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public String safeGetExtensionName() {
        if (this.extensionInstance == null) {
            return "";
        }
        try {
            return this.extensionInstance.getName();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionName: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return "";
        }
    }

    public URL safeGetURL() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getURL();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeGetURL: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public String safeGetExtensionVersion() {
        if (this.extensionInstance == null) {
            return null;
        }
        try {
            return this.extensionInstance.getVersion();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeGetExtensionVersion: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    private boolean safeIsCompatible() {
        if (this.extensionInstance == null) {
            return false;
        }
        try {
            return this.extensionInstance.isCompatible();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeIsCompatible: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return false;
        }
    }

    private void safeStartup(BlueJ bluejProxy) {
        if (this.extensionInstance == null) {
            return;
        }
        try {
            this.extensionInstance.startup(bluejProxy);
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeStartup: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    private void safeTerminate() {
        if (this.extensionInstance == null) {
            return;
        }
        try {
            this.extensionInstance.terminate();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeTerminate: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public void safePrefGenLoadValues() {
        if (this.extensionBluej == null) {
            return;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return;
        }
        try {
            aPrefGen.loadValues();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safePrefGenLoadValues: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public void safePrefGenSaveValues() {
        if (this.extensionBluej == null) {
            return;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return;
        }
        try {
            aPrefGen.saveValues();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safePrefGenSaveValues: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public Pane safePrefGenGetWindow() {
        if (this.extensionBluej == null) {
            return null;
        }
        PreferenceGenerator aPrefGen = this.extensionBluej.getPreferenceGenerator();
        if (aPrefGen == null) {
            return null;
        }
        try {
            return aPrefGen.getWindow();
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safePrefGenGetWindow: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public List<MenuItem> safeGetMenuItems(ExtensionMenu attachedObject) {
        if (this.extensionBluej == null) {
            return null;
        }
        try {
            ArrayList<MenuItem> menuItems = ExtensionBridge.getMenuItems((BlueJ)this.extensionBluej, (ExtensionMenu)attachedObject);
            if (menuItems == null) {
                return Collections.emptyList();
            }
            menuItems = new ArrayList<MenuItem>(menuItems);
            menuItems.removeIf(m -> m == null);
            return menuItems;
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safeMenuGenGetMenuItem: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
    }

    public void safePostMenuItems(ExtensionMenu attachedObject, List<MenuItem> onTheseItems) {
        if (this.extensionBluej == null) {
            return;
        }
        try {
            ExtensionBridge.postMenuItems((BlueJ)this.extensionBluej, (ExtensionMenu)attachedObject, onTheseItems);
        }
        catch (Throwable exc) {
            Debug.message("ExtensionWrapper.safePostGenGetMenuItem: Class=" + this.getExtensionClassName() + " Exception=" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public List<ExternalFileLauncher> safeGetExternalFileLaunchers() {
        return this.extensionBluej != null ? ExtensionBridge.getExternalFileLaunchers((BlueJ)this.extensionBluej) : Collections.unmodifiableList(new ArrayList());
    }

    @OnThread(value=Tag.Any)
    static class FirewallLoader
    extends ClassLoader {
        ClassLoader myParent;

        FirewallLoader(ClassLoader parent) {
            this.myParent = parent;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("bluej.") || name.startsWith("rmiextension.") || name.startsWith("greenfoot.")) {
                return this.myParent.loadClass(name);
            }
            throw new ClassNotFoundException();
        }
    }
}

