/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.groupwork.ui.CommitAndPushFrame;
import bluej.pkgmgr.Project;
import bluej.utility.FXWorker;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CommitAction
extends TeamAction {
    private Set<File> newFiles;
    private Set<File> deletedFiles;
    private Set<File> files;
    private CommitAndPushFrame commitCommentsFrame;
    private @OnThread(value=Tag.Any, requireSynchronized=true) StatusHandle statusHandle;
    private CommitWorker worker;

    public CommitAction(CommitAndPushFrame frame) {
        super(Config.getString("team.commitButton"), false);
        this.commitCommentsFrame = frame;
    }

    public void setNewFiles(Set<File> newFiles) {
        this.newFiles = newFiles;
    }

    public void setDeletedFiles(Set<File> deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    public void setFiles(Set<File> files) {
        this.files = files;
    }

    @OnThread(value=Tag.Worker)
    public synchronized void setStatusHandle(StatusHandle statusHandle) {
        this.statusHandle = statusHandle;
    }

    @Override
    protected void actionPerformed(Project project) {
        this.commitCommentsFrame.startProgress();
        this.commitCommentsFrame.displayMessage(Config.getString("team.commit.statusMessage"));
        this.worker = new CommitWorker();
        this.worker.start();
    }

    public void cancel() {
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    private class CommitWorker
    extends FXWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private boolean aborted;

        @OnThread(value=Tag.FXPlatform)
        public CommitWorker() {
            String comment = CommitAction.this.commitCommentsFrame.getComment();
            HashSet<TeamStatusInfo> forceFiles = new HashSet();
            if (CommitAction.this.commitCommentsFrame.includeLayout()) {
                forceFiles = CommitAction.this.commitCommentsFrame.getChangedLayoutInfo();
                CommitAction.this.files.addAll(CommitAction.this.commitCommentsFrame.getChangedLayoutFiles());
            }
            Set<File> binFiles = TeamUtils.extractBinaryFilesFromSet(CommitAction.this.newFiles);
            this.command = CommitAction.this.statusHandle.commitAll(CommitAction.this.newFiles, binFiles, CommitAction.this.deletedFiles, CommitAction.this.files, forceFiles, comment);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.result;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            Project project = CommitAction.this.commitCommentsFrame.getProject();
            if (!this.aborted) {
                CommitAction.this.commitCommentsFrame.stopProgress();
                if (!this.result.isError() && !this.result.wasAborted()) {
                    DataCollector.teamCommitProject(project, CommitAction.this.statusHandle.getRepository(), CommitAction.this.files);
                    CommitAction.this.commitCommentsFrame.displayMessage(Config.getString("team.commit.statusDone"));
                }
            }
            TeamUtils.handleServerResponseFX(this.result, CommitAction.this.commitCommentsFrame.asWindow());
            if (!this.aborted) {
                CommitAction.this.commitCommentsFrame.setVisible();
            }
        }
    }
}

