/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.print;

import bluej.Config;
import bluej.editor.Editor;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class PrintProgressDialog
extends Dialog<Boolean> {
    private final ProgressBar fileProgress = new ProgressBar(0.0);
    private final VBox content;
    private @OnThread(value=Tag.Any) AtomicBoolean cancelPending = new AtomicBoolean(false);
    private final Label fileHeader;
    private final Label multiFileHeader;
    private final ProgressBar multiFileProgress;

    public PrintProgressDialog(Window owner, boolean multiFile) {
        this.initOwner(owner);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(Config.getString("printing.progress.title"));
        this.fileProgress.setPrefWidth(300.0);
        this.fileHeader = new Label(this.makeLabel("printing.progress.file", 0, 1));
        this.fileHeader.setTextAlignment(TextAlignment.CENTER);
        VBox.setMargin((Node)this.fileHeader, (Insets)new Insets(0.0, 0.0, 15.0, 0.0));
        this.content = new VBox(new Node[]{this.fileHeader, this.fileProgress});
        this.content.setAlignment(Pos.TOP_CENTER);
        this.content.setFillWidth(true);
        if (multiFile) {
            this.multiFileHeader = new Label(this.makeLabel("printing.progress.project", 0, 1));
            this.multiFileHeader.setTextAlignment(TextAlignment.CENTER);
            this.multiFileProgress = new ProgressBar();
            this.multiFileProgress.setPrefWidth(300.0);
            VBox.setMargin((Node)this.multiFileProgress, (Insets)new Insets(15.0, 0.0, 30.0, 0.0));
            this.content.getChildren().addAll(0, List.of(this.multiFileHeader, this.multiFileProgress));
        } else {
            this.multiFileProgress = null;
            this.multiFileHeader = null;
        }
        this.getDialogPane().setContent((Node)this.content);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        Button cancelButton = (Button)this.getDialogPane().lookupButton(ButtonType.CANCEL);
        cancelButton.addEventFilter(ActionEvent.ACTION, e -> {
            this.cancelPending.set(true);
            cancelButton.setText(Config.getString("printing.progress.canceling"));
            cancelButton.setDisable(true);
            e.consume();
        });
    }

    @OnThread(value=Tag.Any)
    public boolean setMultiFileProgress(int filesDone, int totalFiles) {
        Platform.runLater(() -> {
            this.multiFileProgress.setProgress((double)filesDone / (double)totalFiles);
            this.multiFileHeader.setText(this.makeLabel("printing.progress.project", filesDone, totalFiles));
        });
        if (this.cancelPending.get()) {
            this.finished();
            return false;
        }
        return true;
    }

    @OnThread(value=Tag.Any)
    public Editor.PrintProgressUpdate getWithinFileUpdater() {
        return this::updateFileProgress;
    }

    @OnThread(value=Tag.Any)
    private boolean updateFileProgress(int cur, int total) {
        Platform.runLater(() -> {
            this.fileHeader.setText(this.makeLabel("printing.progress.file", cur, total));
            this.fileProgress.setProgress((double)cur / (double)total);
        });
        if (this.cancelPending.get()) {
            this.finished();
            return false;
        }
        return true;
    }

    private String makeLabel(String labelKey, int cur, int total) {
        Properties p = new Properties();
        p.put("cur", "" + cur);
        p.put("total", "" + total);
        return Config.getString(labelKey, null, p, false);
    }

    @OnThread(value=Tag.Any)
    public void finished() {
        Platform.runLater(() -> this.close());
    }
}

