/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.Config;
import bluej.compiler.Diagnostic;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixSuggestion;
import bluej.editor.stride.FrameEditor;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.errors.DirectSlotError;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MissingDoubleEqualsError
extends DirectSlotError {
    private final List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();

    @OnThread(value=Tag.Any)
    public MissingDoubleEqualsError(SlotFragment slotFragment, int startErrorPos, FrameEditor editor) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        CompletableFuture errorLineTextFutureStr = new CompletableFuture();
        Platform.runLater(() -> errorLineTextFutureStr.complete(((ExpressionSlotFragment)slotFragment).getSlot().getText()));
        String errorLineText = null;
        try {
            errorLineText = (String)errorLineTextFutureStr.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        String leftCompPart = errorLineText.substring(0, startErrorPos - 1);
        String rightCompPart = errorLineText.substring(startErrorPos);
        this.corrections.add((FixSuggestion)new EditorFixesManager.FixSuggestionBase(Config.getString("editor.quickfix.wrongComparisonOperator.fixMsg"), () -> ((ExpressionSlotFragment)slotFragment).getSlot().setText(leftCompPart + "==" + rightCompPart)));
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return Config.getString("editor.quickfix.wrongComparisonOperator.errorMsg");
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }
}

