/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.ScreenreaderDictionary;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.stream.Stream;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;

class Operator {
    private final Label l;
    private final StringProperty sourceProperty = new SimpleStringProperty();
    private final BooleanProperty showingJava = new SimpleBooleanProperty();
    private final StringProperty rangeJavaPreview = new SimpleStringProperty(", ");
    private Precedence precedence;

    public Operator(String op, InfixStructured parent) {
        this.sourceProperty.set((Object)op);
        this.l = new Label();
        JavaFXUtil.addStyleClass((Styleable)this.l, "expression-operator");
        this.l.setOnMousePressed(e -> {
            parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            e.consume();
        });
        this.l.setOnMouseDragged(e -> {
            parent.selectTo(e.getSceneX(), e.getSceneY());
            e.consume();
        });
        this.l.setOnMouseReleased(e -> {
            parent.selected();
            e.consume();
        });
        this.l.setOnMouseMoved(e -> {
            if (e.isShortcutDown()) {
                parent.getSlot().getOverlay().hoverAtPos(-1);
            }
        });
        this.l.setOnMouseClicked(Event::consume);
        this.l.setOnDragDetected(Event::consume);
        this.l.textProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.showingJava).then((ObservableStringValue)new When((ObservableBooleanValue)this.sourceProperty.isEqualTo("<:")).then(" instanceof ").otherwise((ObservableStringValue)new When((ObservableBooleanValue)this.sourceProperty.isEqualTo("..")).then((ObservableStringValue)this.rangeJavaPreview).otherwise((ObservableStringValue)this.sourceProperty))).otherwise((ObservableStringValue)this.sourceProperty));
        JavaFXUtil.addChangeListener(this.sourceProperty, s -> this.updateBreaks());
        this.updateBreaks();
    }

    private void updateBreaks() {
        HangingFlowPane.setBreakBefore((Node)this.l, !((String)this.sourceProperty.get()).equals(","));
    }

    static int getOperatorPrecedence(String op, boolean unary) {
        return switch (op) {
            case "," -> 0;
            case ".." -> 1;
            case "||" -> 1;
            case "&&" -> 2;
            case "|" -> 3;
            case "^" -> 4;
            case "&" -> 5;
            case "=", "==", "!=" -> 6;
            case "<", ">", ">=", "<=", "<:" -> 7;
            case "<<", ">>", ">>>" -> 8;
            case "+", "-" -> unary ? 11 : 9;
            case "*", "/", "%" -> 10;
            case "~", "!" -> 12;
            case "new " -> 14;
            case ":", "::" -> 15;
            case "." -> 16;
            case "->" -> 17;
            default -> throw new IllegalStateException("Unknown operator: " + op);
        };
    }

    static Precedence getPrecForLevel(int ourLevel) {
        if (ourLevel == 0) {
            return Precedence.HIGH;
        }
        if (ourLevel == 1) {
            return Precedence.MEDIUM;
        }
        return Precedence.LOW;
    }

    public String getCopyText() {
        return (String)this.sourceProperty.get();
    }

    public Node getNode() {
        return this.l;
    }

    public String get() {
        return (String)this.sourceProperty.get();
    }

    public void set(String s) {
        this.sourceProperty.set((Object)s);
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Precedence chosen) {
        for (Precedence p : Precedence.values()) {
            JavaFXUtil.setPseudoclass(p.getPseudoClass(), false, new Node[]{this.l});
        }
        JavaFXUtil.setPseudoclass(chosen.getPseudoClass(), true, new Node[]{this.l});
        this.precedence = chosen;
    }

    public Stream<TextOverlayPosition> getStartEndPositions(InfixStructured parent) {
        return Stream.of(TextOverlayPosition.nodeToOverlay((Node)this.l, 0.0, 0.0, this.l.getBaselineOffset(), this.l.getHeight()), TextOverlayPosition.nodeToOverlay((Node)this.l, this.l.getWidth(), 0.0, this.l.getBaselineOffset(), this.l.getHeight()));
    }

    public String getJavaCode() {
        if ("<:".equals(this.get())) {
            return " instanceof ";
        }
        if (this.get().equals(",")) {
            return ", ";
        }
        if (this.get().equals(".")) {
            return ".";
        }
        return " " + this.get() + " ";
    }

    public void setView(Frame.View view, SharedTransition animate) {
        if (view != Frame.View.JAVA_PREVIEW) {
            this.rangeJavaPreview.set((Object)", ");
        }
        this.showingJava.set(view == Frame.View.JAVA_PREVIEW);
        JavaFXUtil.setPseudoclass("bj-java-preview", view == Frame.View.JAVA_PREVIEW, new Node[]{this.l});
    }

    public void setJavaPreviewRangeOverride(String s) {
        this.rangeJavaPreview.set((Object)s);
    }

    public Node makeDisplayClone(InteractionManager editor) {
        return JavaFXUtil.cloneLabel(this.l, (ObservableValue<String>)editor.getFontCSS());
    }

    public String getScreenreaderText() {
        return ScreenreaderDictionary.transcribeForScreenreader((String)this.sourceProperty.get());
    }

    public static enum Precedence {
        DOT,
        HIGH,
        MEDIUM,
        LOW,
        NEW,
        COMMA;


        public String getPseudoClass() {
            switch (this) {
                case DOT: {
                    return "bj-op-dot";
                }
                case HIGH: {
                    return "bj-op-high";
                }
                case MEDIUM: {
                    return "bj-op-medium";
                }
                case LOW: {
                    return "bj-op-low";
                }
                case NEW: {
                    return "bj-op-new";
                }
                case COMMA: {
                    return "bj-op-comma";
                }
            }
            return null;
        }
    }
}

