/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.editor.base.TextLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

class ContentLine
implements Iterable<TextLine.StyledSegment> {
    private final ArrayList<TextLine.StyledSegment> segments;
    private String cachedText;

    public ContentLine(List<TextLine.StyledSegment> segments) {
        this.segments = new ArrayList<TextLine.StyledSegment>(segments);
        this.cachedText = segments.stream().map(s -> s.getText()).collect(Collectors.joining());
    }

    public void append(TextLine.StyledSegment segment) {
        this.segments.add(segment);
        this.cachedText = this.cachedText + segment.getText();
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    TextLine.StyledSegment> iterator() {
        if (this.segments.isEmpty()) {
            return Collections.singletonList(new TextLine.StyledSegment(Collections.emptyList(), "")).iterator();
        }
        return TextLine.StyledSegment.mergeAdjacentIdentical(this.segments).iterator();
    }

    public String getText() {
        return this.cachedText;
    }

    public Object getCustomStyleDataAtColumn(int column) {
        if (column < 0) {
            return null;
        }
        int toSkip = column;
        for (TextLine.StyledSegment segment : this.segments) {
            int segmentLength = segment.getText().length();
            if (toSkip < segmentLength) {
                return segment.getCustomData();
            }
            toSkip -= segmentLength;
        }
        return null;
    }
}

