/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.NameTransform;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class JavaType
extends GenTypeParameter {
    public static int JT_VOID = 0;
    public static int JT_NULL = 1;
    public static int JT_BOOLEAN = 2;
    public static int JT_CHAR = 3;
    public static int JT_BYTE = 4;
    public static int JT_SHORT = 5;
    public static int JT_INT = 6;
    public static int JT_LONG = 7;
    public static int JT_FLOAT = 8;
    public static int JT_DOUBLE = 9;
    public static int JT_MAX = 9;
    public static int JT_LOWEST_NUMERIC = JT_CHAR;
    public static int JT_LOWEST_FLOAT = JT_FLOAT;

    @Override
    public String toString(NameTransform nt) {
        return this.toString();
    }

    public abstract String toString();

    @OnThread(value=Tag.FXPlatform)
    public abstract String arrayComponentName();

    @OnThread(value=Tag.FXPlatform)
    public abstract void getParamsFromTemplate(Map<String, GenTypeParameter> var1, GenTypeParameter var2);

    @Override
    public abstract boolean isPrimitive();

    public boolean isNumeric() {
        return false;
    }

    public boolean isIntegralType() {
        return false;
    }

    public final boolean isVoid() {
        return this.typeIs(JT_VOID);
    }

    public final boolean isNull() {
        return this.typeIs(JT_NULL);
    }

    public boolean typeIs(int v) {
        return false;
    }

    public GenTypeClass asClass() {
        return null;
    }

    @Override
    public JavaType asType() {
        return this;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean equals(JavaType var1);

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean equals(GenTypeParameter other) {
        if (other instanceof JavaType) {
            return this.equals((JavaType)other);
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isAssignableFrom(JavaType var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isAssignableFromRaw(JavaType var1);

    @Override
    @OnThread(value=Tag.FXPlatform)
    public abstract GenTypeParameter mapTparsToTypes(Map<String, ? extends GenTypeParameter> var1);

    @Override
    public JavaType getArrayComponent() {
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract GenTypeSolid getArray();

    public JavaType[] getIntersectionTypes() {
        return new JavaType[]{this};
    }

    @OnThread(value=Tag.FXPlatform)
    public JavaType getCapture() {
        return this;
    }

    @Override
    public JavaType getTparCapture() {
        return this;
    }
}

