/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.base;

import bluej.editor.base.BackgroundItem;
import bluej.editor.base.BaseEditorPane;
import bluej.editor.base.MarginAndTextLine;
import bluej.editor.base.TextLine;
import bluej.editor.flow.Document;
import bluej.utility.javafx.FXFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.ScrollEvent;
import javafx.scene.shape.Path;
import javafx.scene.text.HitInfo;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class LineDisplay {
    private final BaseEditorPane.BaseEditorPaneListener editorPaneListener;
    private int firstVisibleLineIndex = 0;
    private double firstVisibleLineOffset = 0.0;
    private final Map<Integer, MarginAndTextLine> visibleLines = new HashMap<Integer, MarginAndTextLine>();
    private final ArrayList<LineDisplayListener> lineDisplayListeners = new ArrayList();
    private final StringExpression fontCSS;
    private final DoubleExpression horizScrollProperty;
    private double lineHeightEstimate = 1.0;
    private final boolean showLeftMargin;

    public LineDisplay(DoubleExpression horizScrollProperty, StringExpression fontCSS, boolean showLeftMargin, BaseEditorPane.BaseEditorPaneListener editorPaneListener) {
        this.fontCSS = fontCSS;
        this.horizScrollProperty = horizScrollProperty;
        this.editorPaneListener = editorPaneListener;
        this.showLeftMargin = showLeftMargin;
    }

    public MarginAndTextLine getVisibleLine(int line) {
        if (!this.isLineVisible(line)) {
            throw new IndexOutOfBoundsException("Line " + line + " is not visible.  Visible range is " + this.firstVisibleLineIndex + " to " + (this.firstVisibleLineIndex + this.visibleLines.size()));
        }
        return this.visibleLines.get(line);
    }

    public boolean isLineVisible(int line) {
        return line >= this.firstVisibleLineIndex && line < this.firstVisibleLineIndex + this.visibleLines.size();
    }

    @OnThread(value=Tag.FX)
    public <L extends List<TextLine.StyledSegment>> List<MarginAndTextLine> recalculateVisibleLines(List<L> allLines, FXFunction<Double, Double> snapHeight, double xTranslate, double width, double height, boolean lineWrapping, BaseEditorPane editorPane) {
        int lastLineIndexIncl;
        if (this.firstVisibleLineIndex >= allLines.size()) {
            this.firstVisibleLineIndex = allLines.size() - 1;
            this.firstVisibleLineOffset = 0.0;
        }
        if (!lineWrapping) {
            double lineHeight = snapHeight.apply(this.calculateLineHeight());
            int linesToDraw = 1 + (int)Math.ceil((height - (lineHeight + this.firstVisibleLineOffset)) / lineHeight);
            Iterator<L> lines = allLines.subList(this.firstVisibleLineIndex, Math.min(linesToDraw + this.firstVisibleLineIndex, allLines.size())).iterator();
            int lineIndex = this.firstVisibleLineIndex;
            while (lines.hasNext()) {
                MarginAndTextLine line = this.visibleLines.computeIfAbsent(lineIndex, k -> new MarginAndTextLine(k + 1, new TextLine(lineWrapping), this.showLeftMargin, () -> this.editorPaneListener.marginClickedForLine((int)k), () -> this.editorPaneListener.getContextMenuToShow(editorPane), e -> this.editorPaneListener.scrollEventOnTextLine((ScrollEvent)e, editorPane)));
                line.textLine.setText((List)lines.next(), xTranslate, false, this.fontCSS);
                ++lineIndex;
            }
            this.lineHeightEstimate = lineHeight;
            lastLineIndexIncl = lineIndex - 1;
        } else {
            int lineIndex;
            double lineHeight;
            double totalHeightSoFar = 0.0;
            for (lineIndex = this.firstVisibleLineIndex; lineIndex < allLines.size() && totalHeightSoFar < height; totalHeightSoFar += snapHeight.apply(lineHeight).doubleValue(), ++lineIndex) {
                MarginAndTextLine line = this.visibleLines.computeIfAbsent(lineIndex, k -> new MarginAndTextLine(k + 1, new TextLine(lineWrapping), this.showLeftMargin, () -> this.editorPaneListener.marginClickedForLine((int)k), () -> this.editorPaneListener.getContextMenuToShow(editorPane), e -> this.editorPaneListener.scrollEventOnTextLine((ScrollEvent)e, editorPane)));
                line.textLine.setText((List)allLines.get(lineIndex), xTranslate, true, this.fontCSS);
                lineHeight = this.calculateLineHeight((List)allLines.get(lineIndex), width);
            }
            lastLineIndexIncl = lineIndex - 1;
        }
        this.visibleLines.entrySet().removeIf(e -> (Integer)e.getKey() < this.firstVisibleLineIndex || (Integer)e.getKey() > lastLineIndexIncl);
        int[] lineRangeVisible = this.getLineRangeVisible();
        for (LineDisplayListener lineDisplayListener : this.lineDisplayListeners) {
            if (lineRangeVisible[1] < lineRangeVisible[0]) continue;
            lineDisplayListener.renderedLines(lineRangeVisible[0], lineRangeVisible[1]);
        }
        return this.visibleLines.entrySet().stream().sorted(Comparator.comparing(e -> (Integer)e.getKey())).map(e -> (MarginAndTextLine)((Object)((Object)e.getValue()))).collect(Collectors.toList());
    }

    @OnThread(value=Tag.FX)
    public void scrollTo(int lineIndex, double lineOffset) {
        this.firstVisibleLineIndex = lineIndex;
        this.firstVisibleLineOffset = lineOffset;
    }

    void scrollBy(double deltaY, int documentLines, double containerHeight) {
        if (deltaY == 0.0) {
            return;
        }
        double overallPos = (double)this.firstVisibleLineIndex * this.lineHeightEstimate - this.firstVisibleLineOffset;
        double newOverallPos = overallPos - deltaY;
        newOverallPos = Math.min(newOverallPos, this.lineHeightEstimate * (double)documentLines - containerHeight);
        newOverallPos = Math.max(0.0, newOverallPos);
        int newTopLine = (int)Math.floor(newOverallPos / this.lineHeightEstimate);
        double newOffset = (double)newTopLine * this.lineHeightEstimate - newOverallPos;
        this.scrollTo(newTopLine, newOffset);
    }

    public double getFirstVisibleLineOffset() {
        return this.firstVisibleLineOffset;
    }

    @OnThread(value=Tag.FX)
    public int[] getLineRangeVisible() {
        return new int[]{this.firstVisibleLineIndex, this.firstVisibleLineIndex + this.visibleLines.size() - 1};
    }

    public void ensureLineVisible(int line, double containerHeight, int linesInDocument) {
        if (line <= this.firstVisibleLineIndex) {
            this.firstVisibleLineIndex = line;
            this.firstVisibleLineOffset = 0.0;
        }
        if (line >= this.firstVisibleLineIndex + this.visibleLines.size() - 1 || (double)this.visibleLines.size() * this.lineHeightEstimate < containerHeight && this.firstVisibleLineIndex > 0) {
            double singleLineHeight = this.lineHeightEstimate;
            int numLinesCanDisplay = (int)Math.ceil(containerHeight / singleLineHeight);
            this.firstVisibleLineIndex = line >= linesInDocument - numLinesCanDisplay + 1 && this.firstVisibleLineIndex >= linesInDocument - numLinesCanDisplay + 1 ? linesInDocument - numLinesCanDisplay + 1 : line - numLinesCanDisplay + 1;
            if (this.firstVisibleLineIndex < 0) {
                this.firstVisibleLineIndex = 0;
                this.firstVisibleLineOffset = 0.0;
            } else {
                this.firstVisibleLineOffset = containerHeight - (double)numLinesCanDisplay * singleLineHeight;
            }
        }
    }

    public int getVisibleLineCount() {
        return this.visibleLines.size();
    }

    public void addLineDisplayListener(LineDisplayListener lineDisplayListener) {
        this.lineDisplayListeners.add(lineDisplayListener);
    }

    public double getLineHeight() {
        return this.lineHeightEstimate;
    }

    public void applyScopeBackgrounds(Map<Integer, List<BackgroundItem>> scopeBackgrounds) {
        this.visibleLines.forEach((lineIndex, item) -> item.textLine.setScopeBackgrounds((Collection)scopeBackgrounds.get(lineIndex)));
    }

    public void fontSizeChanged() {
        for (MarginAndTextLine line : this.visibleLines.values()) {
            line.fontSizeChanged(this.fontCSS);
        }
    }

    public void hideAllErrorUnderlines() {
        for (MarginAndTextLine marginAndTextLine : this.visibleLines.values()) {
            marginAndTextLine.textLine.hideErrorUnderline();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public Bounds[] getBoundsForRange(Document document, int startOffset, int endOffset) {
        int firstLine = document.getLineFromPosition(startOffset);
        int lastLine = document.getLineFromPosition(endOffset);
        return (Bounds[])IntStream.rangeClosed(firstLine, lastLine).mapToObj(line -> {
            if (!this.isLineVisible(line)) {
                return null;
            }
            MarginAndTextLine node = this.getVisibleLine(line);
            Path path = new Path(node.textLine.rangeShape(Math.max(startOffset, document.getLineStart(line)), Math.min(endOffset, document.getLineEnd(line))));
            return node.localToParent(node.textLine.localToParent(path.getBoundsInLocal()));
        }).filter(b -> b != null).toArray(Bounds[]::new);
    }

    public double getFontSizeInPixels() {
        if (!this.visibleLines.isEmpty()) {
            return this.visibleLines.values().iterator().next().textLine.getSingleTextHeight();
        }
        return this.lineHeightEstimate;
    }

    public double textLeftEdge() {
        return MarginAndTextLine.textLeftEdge(this.showLeftMargin);
    }

    public int[] getCaretPositionForLocalPoint(Point2D localPoint) {
        for (int i = 0; i < this.visibleLines.size(); ++i) {
            HitInfo hitInfo;
            Point2D pointInLocal;
            MarginAndTextLine currentlyVisibleLine = this.visibleLines.get(i + this.firstVisibleLineIndex);
            if (currentlyVisibleLine == null || !(currentlyVisibleLine.getLayoutY() <= localPoint.getY()) || !(localPoint.getY() <= currentlyVisibleLine.getLayoutY() + currentlyVisibleLine.getHeight()) || !((pointInLocal = new Point2D(localPoint.getX() - currentlyVisibleLine.getLayoutX() - (double)MarginAndTextLine.textLeftEdge(this.showLeftMargin) + this.horizScrollProperty.get(), localPoint.getY() - currentlyVisibleLine.getLayoutY())).getX() >= 0.0) || (hitInfo = currentlyVisibleLine.textLine.hitTest(pointInLocal)) == null) continue;
            return new int[]{i + this.firstVisibleLineIndex, hitInfo.getInsertionIndex()};
        }
        return null;
    }

    public double calculateLineWidth(String line) {
        TextLine textLine = new TextLine(false);
        Scene s = new Scene((Parent)textLine);
        textLine.setText(List.of(new TextLine.StyledSegment(List.of(), line)), 0.0, true, this.fontCSS);
        textLine.applyCss();
        textLine.layout();
        return textLine.prefWidth(-1.0);
    }

    public double calculateLineHeight() {
        return this.calculateLineHeight(List.of(new TextLine.StyledSegment(List.of(), "Xy")), -1.0);
    }

    public double calculateLineHeight(List<TextLine.StyledSegment> content, double maxWidth) {
        TextLine textLine = new TextLine(false);
        Scene s = new Scene((Parent)textLine);
        textLine.setText(content, 0.0, true, this.fontCSS);
        textLine.applyCss();
        textLine.layout();
        return textLine.prefHeight(maxWidth);
    }

    public static interface LineDisplayListener {
        @OnThread(value=Tag.FX)
        public void renderedLines(int var1, int var2);
    }
}

