/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.BlueJEvent;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions2.BObject;
import bluej.extensions2.InvocationArgumentException;
import bluej.extensions2.InvocationErrorException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;

class DirectInvoker {
    private final PkgMgrFrame pkgFrame;
    private String resultName;

    DirectInvoker(PkgMgrFrame i_pkgFrame) {
        this.pkgFrame = i_pkgFrame;
    }

    DebuggerObject invokeConstructor(ConstructorView callable, Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, callable.getParameters())) {
            throw new InvocationArgumentException("invokeConstructor: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher();
        Invoker invoker = new Invoker(this.pkgFrame, callable, watcher);
        String[] argStrings = this.convObjToString(args);
        invoker.invokeDirect(argStrings);
        DebuggerObject result = watcher.getResult();
        String resultType = watcher.getResultType();
        if (resultType != null) {
            ExecutionEvent ee = new ExecutionEvent(this.pkgFrame.getPackage(), callable.getClassName(), null);
            DirectInvoker.raiseEvent(ee, callable, argStrings, watcher);
        }
        if (watcher.isFailed()) {
            throw new InvocationErrorException("invokeConstructor: Error=" + watcher.getError());
        }
        if (result == null) {
            throw new InvocationErrorException("invokeConstructor: ERROR: result==null");
        }
        this.resultName = watcher.getResultName();
        return result;
    }

    DebuggerObject invokeMethod(ObjectWrapper onThisObjectInstance, MethodView callable, Object[] args) throws InvocationArgumentException, InvocationErrorException {
        if (!this.paramsAlmostMatch(args, callable.getParameters())) {
            throw new InvocationArgumentException("invokeMethod: bad arglist");
        }
        DirectResultWatcher watcher = new DirectResultWatcher();
        Invoker invoker = callable.isStatic() ? new Invoker(this.pkgFrame, callable, watcher) : new Invoker(this.pkgFrame, callable, onThisObjectInstance.getName(), onThisObjectInstance.getObject(), watcher);
        String[] argStrings = this.convObjToString(args);
        invoker.invokeDirect(this.convObjToString(args));
        DebuggerObject result = watcher.getResult();
        String resultType = watcher.getResultType();
        if (resultType != null) {
            ExecutionEvent ee = new ExecutionEvent(this.pkgFrame.getPackage(), callable.getClassName(), onThisObjectInstance == null ? null : onThisObjectInstance.getName());
            ee.setMethodName(callable.getName());
            DirectInvoker.raiseEvent(ee, callable, argStrings, watcher);
        }
        if (watcher.isFailed()) {
            throw new InvocationErrorException("invokeMethod: Error=" + watcher.getError());
        }
        this.resultName = watcher.getResultName();
        return result;
    }

    private static void raiseEvent(ExecutionEvent event, CallableView callable, String[] argStrings, DirectResultWatcher watcher) {
        DebuggerObject result = watcher.getResult();
        String resultType = watcher.getResultType();
        event.setParameters(callable.getParamTypes(false), argStrings);
        event.setResult(resultType);
        if (resultType == "Normal exit") {
            event.setResultObject(result);
            event.setObjectName(watcher.getResultName());
        } else if (resultType == "An exception occurred") {
            event.setException(watcher.getException());
        }
        BlueJEvent.raiseEvent(5, event);
    }

    String getResultName() {
        return this.resultName;
    }

    private String[] convObjToString(Object[] i_array) {
        if (i_array == null) {
            return null;
        }
        if (i_array.length <= 0) {
            return new String[0];
        }
        String[] o_array = new String[i_array.length];
        for (int index = 0; index < i_array.length; ++index) {
            o_array[index] = this.convOneObj(i_array[index]);
        }
        return o_array;
    }

    private String convOneObj(Object i_obj) {
        if (i_obj == null) {
            return null;
        }
        if (i_obj instanceof String) {
            return "\"" + Utility.quoteString(i_obj.toString()) + "\"";
        }
        if (i_obj instanceof BObject) {
            return ((BObject)i_obj).getInstanceName();
        }
        return i_obj.toString();
    }

    private boolean paramsAlmostMatch(Object[] params, Class<?>[] paramClass) {
        if (params != null && params.length < 1) {
            params = null;
        }
        if (paramClass != null && paramClass.length < 1) {
            paramClass = null;
        }
        if (params == null && paramClass == null) {
            return true;
        }
        if (params == null || paramClass == null) {
            return false;
        }
        return params.length == paramClass.length;
    }

    class DirectResultWatcher
    implements ResultWatcher {
        private boolean resultReady = false;
        private boolean isFailed = false;
        private String resultType;
        private DebuggerObject result = null;
        private ExceptionDescription exception;
        private String errorMsg = null;
        private String resultName;

        public synchronized DebuggerObject getResult() {
            while (!this.resultReady) {
                try {
                    this.wait();
                }
                catch (InterruptedException exc) {
                    this.isFailed = true;
                    this.errorMsg = "getResult: Interrupt: Exception=" + exc.getMessage();
                    return null;
                }
            }
            return this.result;
        }

        public synchronized boolean isFailed() {
            return this.isFailed;
        }

        @Override
        public void beginCompile() {
        }

        @Override
        public void beginExecution(InvokerRecord ir) {
        }

        @Override
        public synchronized void putResult(DebuggerObject aResult, String anObjectName, InvokerRecord ir) {
            this.result = aResult;
            this.resultType = "Normal exit";
            this.resultName = anObjectName;
            this.resultReady = true;
            this.notifyAll();
        }

        @Override
        public synchronized void putError(String error, InvokerRecord ir) {
            this.errorMsg = "Invocation: Error=" + error;
            this.isFailed = true;
            this.resultReady = true;
            this.notifyAll();
        }

        @Override
        public synchronized void putException(ExceptionDescription exception, InvokerRecord ir) {
            this.exception = exception;
            this.resultType = "An exception occurred";
            this.putError(exception.getText(), ir);
        }

        @Override
        public void putVMTerminated(InvokerRecord ir, boolean terminatedByUserCode) {
            this.resultType = terminatedByUserCode ? "Normal exit" : "User terminated";
            this.putError("Terminated", ir);
        }

        public String getError() {
            return this.errorMsg;
        }

        public String getResultName() {
            return this.resultName;
        }

        public String getResultType() {
            return this.resultType;
        }

        public ExceptionDescription getException() {
            return this.exception;
        }
    }
}

