/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.actions.CommitCommentAction;
import bluej.groupwork.actions.ShareAction;
import bluej.groupwork.actions.ShowLogAction;
import bluej.groupwork.actions.StatusAction;
import bluej.groupwork.actions.TeamSettingsAction;
import bluej.groupwork.actions.UpdateDialogAction;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamActionGroup {
    private final String commitLabel;
    private final boolean initialTeamMode;
    private StatusAction statusAction;
    private UpdateDialogAction updateAction;
    private TeamSettingsAction teamSettingsAction;
    private CommitCommentAction commitCommentAction;
    private ShareAction shareAction;
    private ShowLogAction showLogAction;

    public TeamActionGroup(boolean teamMode) {
        String label = "team.commit";
        this.commitLabel = label = "team.commitPush";
        this.initialTeamMode = teamMode;
    }

    private void createAll() {
        if (this.statusAction == null) {
            this.statusAction = new StatusAction();
            this.updateAction = new UpdateDialogAction();
            this.teamSettingsAction = new TeamSettingsAction();
            this.commitCommentAction = new CommitCommentAction(this.commitLabel);
            this.shareAction = new ShareAction();
            this.showLogAction = new ShowLogAction();
            this.setTeamMode(this.initialTeamMode);
        }
    }

    public StatusAction getStatusAction() {
        this.createAll();
        return this.statusAction;
    }

    public UpdateDialogAction getUpdateAction() {
        this.createAll();
        return this.updateAction;
    }

    public TeamSettingsAction getTeamSettingsAction() {
        this.createAll();
        return this.teamSettingsAction;
    }

    public CommitCommentAction getCommitCommentAction() {
        this.createAll();
        return this.commitCommentAction;
    }

    public ShareAction getShareAction() {
        this.createAll();
        return this.shareAction;
    }

    public ShowLogAction getShowLogAction() {
        this.createAll();
        return this.showLogAction;
    }

    public void setTeamMode(boolean enabled) {
        this.createAll();
        this.statusAction.setEnabled(enabled);
        this.updateAction.setEnabled(enabled);
        this.teamSettingsAction.setEnabled(enabled);
        this.showLogAction.setEnabled(enabled);
        String label = "team.commit";
        label = "team.commitPush";
        this.commitCommentAction.setName(Config.getString(label), true);
        this.commitCommentAction.setEnabled(enabled);
        this.shareAction.setEnabled(!enabled);
    }

    public void setAllDisabled() {
        this.createAll();
        this.statusAction.setEnabled(false);
        this.updateAction.setEnabled(false);
        this.teamSettingsAction.setEnabled(false);
        this.commitCommentAction.setEnabled(false);
        this.shareAction.setEnabled(false);
        this.showLogAction.setEnabled(false);
    }
}

