/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.editor.stride.BirdseyeManager;
import bluej.parser.AssistContent;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.CommentFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.InheritedCanvas;
import bluej.stride.framedjava.frames.InheritedFieldFrame;
import bluej.stride.framedjava.frames.InheritedMethodFrame;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.StrideDictionary;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameTypeCheck;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.TopLevelDocumentMultiCanvasFrame;
import bluej.stride.operations.CopyFrameAsImageOperation;
import bluej.stride.operations.CopyFrameAsJavaOperation;
import bluej.stride.operations.CopyFrameAsStrideOperation;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.Implements;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TriangleLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ClassFrame
extends TopLevelDocumentMultiCanvasFrame<ClassElement> {
    private final SlotLabel abstractLabel = new SlotLabel("abstract", new String[0]);
    private final SimpleBooleanProperty focusHasBeenInNameOrExtends;
    private BooleanProperty abstractModifier = new SimpleBooleanProperty(false);
    private final TypeSlot extendsSlot;
    private final SimpleBooleanProperty showingExtends;
    private final TriangleLabel inheritedLabel;
    private final BooleanBinding showInheritedToggle;
    private final ObservableList<InheritedCanvas> extendsInheritedCanvases = FXCollections.observableArrayList();
    private final Implements implementsSlot;
    private final ReadOnlyBooleanProperty focusInName;
    private final ReadOnlyBooleanProperty focusInExtends;
    private final BooleanBinding focusInNameOrExtends;
    private Map<String, List<AssistContentThreadSafe>> curMembersByClass = Collections.emptyMap();
    private final FrameCanvas constructorsCanvas;
    private final SlotLabel constructorsLabel;
    private final FrameContentRow constructorsLabelRow;

    public ClassFrame(InteractionManager editor, EntityResolver projectResolver, String packageName, List<ImportElement> imports, JavadocUnit documentation, boolean abstractModifierParam, NameDefSlotFragment className, TypeSlotFragment extendsName, List<TypeSlotFragment> implementsList, boolean enabled) {
        super(editor, projectResolver, "class", "class-", packageName, imports, documentation, className, enabled);
        this.abstractModifier.set(abstractModifierParam);
        JavaFXUtil.addChangeListener(this.abstractModifier, abs -> editor.modifiedFrame(this, false));
        this.showingExtends = new SimpleBooleanProperty(extendsName != null);
        SlotLabel extendsLabel = new SlotLabel("extends", new String[0]);
        JavaFXUtil.addStyleClass((Styleable)extendsLabel, "class-extends-caption");
        this.extendsSlot = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.EXTENDS, "class-extends-");
        this.extendsSlot.addClosingChar(' ');
        this.extendsSlot.setSimplePromptText("parent class");
        if (extendsName != null) {
            this.extendsSlot.setText(extendsName);
        }
        this.implementsSlot = new Implements(this, () -> {
            TypeSlot s = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.INTERFACE, "class-");
            s.setSimplePromptText("interface type");
            return s;
        }, () -> this.getCanvases().findFirst().ifPresent(c -> c.getFirstCursor().requestFocus()), editor);
        implementsList.forEach(t -> this.implementsSlot.addTypeSlotAtEnd(t.getContent(), false));
        this.focusInName = JavaFXUtil.delay(this.paramName.effectivelyFocusedProperty(), Duration.ZERO, Duration.millis((double)100.0));
        this.focusInExtends = JavaFXUtil.delay(this.extendsSlot.effectivelyFocusedProperty(), Duration.ZERO, Duration.millis((double)100.0));
        this.focusInNameOrExtends = BooleanBinding.booleanExpression((ObservableBooleanValue)this.focusInName).or((ObservableBooleanValue)this.focusInExtends);
        this.focusHasBeenInNameOrExtends = new SimpleBooleanProperty(false);
        FXRunnable updateFocus = () -> {
            if (this.focusInNameOrExtends.get()) {
                this.implementsSlot.ensureAtLeastOneSlot();
                this.focusHasBeenInNameOrExtends.set(true);
            } else {
                if (!this.implementsSlot.focusedProperty().get()) {
                    this.implementsSlot.clearIfSingleEmpty();
                }
                this.focusHasBeenInNameOrExtends.set(this.focusHasBeenInNameOrExtends.get() && this.implementsSlot.focusedProperty().get());
            }
        };
        JavaFXUtil.addChangeListener(this.focusInNameOrExtends, f -> updateFocus.run());
        JavaFXUtil.addChangeListener(this.implementsSlot.focusedProperty(), f -> updateFocus.run());
        JavaFXUtil.addChangeListener(this.focusHasBeenInNameOrExtends, h -> this.showingExtends.set(!this.extendsSlot.isEmpty() || this.focusHasBeenInNameOrExtends.get()));
        this.extendsSlot.onTextPropertyChange(s -> this.showingExtends.set(!this.extendsSlot.isEmpty() || this.focusHasBeenInNameOrExtends.get()));
        this.inheritedLabel = new TriangleLabel(editor, t -> this.extendsInheritedCanvases.forEach(c -> c.grow((SharedTransition)t)), t -> this.extendsInheritedCanvases.forEach(c -> c.shrink((SharedTransition)t)), new SimpleBooleanProperty(false));
        this.inheritedLabel.setDisable(true);
        this.extendsInheritedCanvases.addListener(c -> this.inheritedLabel.setDisable(this.extendsInheritedCanvases.isEmpty()));
        JavaFXUtil.addChangeListenerPlatform(this.inheritedLabel.expandedProperty(), b -> editor.updateErrorOverviewBar());
        this.showInheritedToggle = this.showingExtends.and((ObservableBooleanValue)Bindings.isNotEmpty(this.extendsInheritedCanvases));
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{JavaFXUtil.listBool((BooleanExpression)this.abstractModifier, this.abstractLabel), FXCollections.observableArrayList((Object[])new SlotLabel[]{this.headerCaptionLabel}), FXCollections.observableArrayList((Object[])new TextSlot[]{this.paramName}), JavaFXUtil.listBool((BooleanExpression)this.showingExtends, List.of(extendsLabel, this.extendsSlot)), JavaFXUtil.listBool((BooleanExpression)this.showInheritedToggle, this.inheritedLabel), this.implementsSlot.getHeaderItems()}));
        this.constructorsLabel = this.makeLabel(Config.getString("frame.editor.label.constructors"));
        this.constructorsCanvas = new FrameCanvas(editor, this, "class-");
        this.constructorsLabelRow = new FrameContentRow((Frame)this, this.constructorsLabel);
        this.addCanvas(this.constructorsLabelRow, this.constructorsCanvas, 1);
        ((TextSlot)className.getSlot()).setSlotName(" class name slot");
        ((TextSlot)className.getSlot()).setScreenReaderHelpSlots();
        this.extendsSlot.setSlotName(" parent class name slot");
        this.extendsSlot.setAccessibilityHelpSlots();
        for (TypeSlot slot : this.implementsSlot.getTypeSlots().collect(Collectors.toList())) {
            slot.setSlotName(" interface name slot ");
            slot.setAccessibilityHelpSlots();
        }
        this.documentationPane.setScreenReaderHelpSlots("You are in the documentation for the class " + (String)this.nameProperty().get());
        this.frameName = "class frame";
    }

    @Override
    public String getScreenReaderHelp() {
        return "";
    }

    public String getLocationDescription() {
        Object text = this.nameProperty().get() != null && !((String)this.nameProperty().get()).isEmpty() ? " in the class " + (String)this.nameProperty().get() : " in the class [Undefined in ClassFrame name property] ";
        return text;
    }

    public String getClassName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public Stream<EditableSlot> getPossiblyHiddenSlotsDirect() {
        return Stream.of(this.extendsSlot);
    }

    @Override
    protected Frame findASpecialMethod() {
        return this.getMethods().stream().filter(f -> f.getName().equals("act") && f.getParamsPane().isEmpty()).findFirst().orElse(null);
    }

    @Override
    public synchronized void regenerateCode() {
        List<CodeElement> fields = this.getMembers(this.fieldsCanvas);
        List<CodeElement> constructors = this.getMembers(this.constructorsCanvas);
        List<CodeElement> methods = this.getMembers(this.methodsCanvas);
        List<ImportElement> imports = Utility.mapList(this.getMembers(this.importCanvas), e -> (ImportElement)e);
        this.element = new ClassElement(this, this.projectResolver, this.abstractModifier.get(), (NameDefSlotFragment)this.paramName.getSlotElement(), this.showingExtends.get() && !this.extendsSlot.getText().equals("") ? (TypeSlotFragment)this.extendsSlot.getSlotElement() : null, this.implementsSlot.getTypes(), fields, constructors, methods, new JavadocUnit(this.getDocumentation()), this.packageNameLabel == null ? null : this.packageNameLabel.getText(), imports, this.frameEnabledProperty.get());
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) ClassElement getCode() {
        return (ClassElement)this.element;
    }

    @Override
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> ops = new ArrayList<FrameOperation>();
        ops.add(new CopyFrameAsStrideOperation(this.editor));
        ops.add(new CopyFrameAsImageOperation(this.editor));
        ops.add(new CopyFrameAsJavaOperation(this.editor));
        ops.add(new CustomFrameOperation(this.getEditor(), "addRemoveAbstract", Arrays.asList(Config.getString("frame.class.toggle.abstract")), AbstractOperation.MenuItemOrder.TOGGLE_ABSTRACT, this, () -> this.abstractModifier.set(!this.abstractModifier.get())));
        if (this.extendsSlot.isEmpty()) {
            ops.add(new CustomFrameOperation(this.getEditor(), "addExtends", Arrays.asList(Config.getString("frame.class.add.extends")), AbstractOperation.MenuItemOrder.TOGGLE_EXTENDS, this, () -> this.showAndFocusExtends()));
        } else {
            CustomFrameOperation op = new CustomFrameOperation(this.getEditor(), "removeExtends", Arrays.asList(Config.getString("frame.class.remove.extends.from").replace("$", this.extendsSlot.getText())), AbstractOperation.MenuItemOrder.TOGGLE_EXTENDS, this, () -> this.extendsSlot.setText(""));
            op.setWideCustomItem(true);
            ops.add(op);
        }
        ops.add(new CustomFrameOperation(this.getEditor(), "addImplements", Arrays.asList(Config.getString("frame.class.add.implements")), AbstractOperation.MenuItemOrder.TOGGLE_IMPLEMENTS, this, () -> this.implementsSlot.addTypeSlotAtEnd("", true)));
        List<TypeSlotFragment> types = this.implementsSlot.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            int index = i;
            TypeSlotFragment type = types.get(i);
            CustomFrameOperation removeOp = new CustomFrameOperation(this.getEditor(), "removeImplements", Arrays.asList(Config.getString("frame.class.remove.implements").replace("$", type.getContent())), AbstractOperation.MenuItemOrder.TOGGLE_IMPLEMENTS, this, () -> this.implementsSlot.removeIndex(index));
            removeOp.setWideCustomItem(true);
            ops.add(removeOp);
        }
        return ops;
    }

    private void showAndFocusExtends() {
        this.paramName.requestFocus();
        this.extendsSlot.requestFocus();
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas canvas, FrameCursor cursorInCanvas) {
        ExtensionDescription abstractExtension = null;
        ExtensionDescription implementsExtension = null;
        ExtensionDescription extendsExtension = null;
        if (this.fieldsCanvas.equals(canvas) || canvas == null) {
            abstractExtension = new ExtensionDescription('b', Config.getString("frame.class.toggle.abstract"), () -> this.abstractModifier.set(!this.abstractModifier.get()), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER);
            implementsExtension = new ExtensionDescription('i', "Add implements declaration", () -> this.implementsSlot.addTypeSlotAtEnd("", true), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER);
            if (!this.showingExtends.get()) {
                extendsExtension = new ExtensionDescription('e', "Add extends declaration", () -> this.showAndFocusExtends(), true, ExtensionDescription.ExtensionSource.INSIDE_FIRST, ExtensionDescription.ExtensionSource.MODIFIER);
            }
        }
        return Utility.nonNulls(Arrays.asList(abstractExtension, extendsExtension, implementsExtension));
    }

    @Override
    public String getLocationDescription(FrameCanvas c) {
        return null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void saved() {
        if (this.extendsInheritedCanvases.isEmpty()) {
            this.updateInheritedItems();
        }
    }

    private Comparator<String> getSuperClassComparator() {
        return (a, b) -> {
            if (a == null || b == null) {
                throw new IllegalArgumentException("Null strings for super-class names");
            }
            if (a.equals(b)) {
                return 0;
            }
            if ("java.lang.Object".equals(a)) {
                return 1;
            }
            if ("java.lang.Object".equals(b)) {
                return -1;
            }
            if (this.extendsSlot.getText().equals(a)) {
                return -1;
            }
            if (this.extendsSlot.getText().equals(b)) {
                return 1;
            }
            return a.compareTo((String)b);
        };
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateInheritedItems() {
        this.withInheritedItems(new HashSet<AssistContent.CompletionKind>(Arrays.asList(AssistContent.CompletionKind.FIELD, AssistContent.CompletionKind.METHOD)), membersByClass -> {
            if (ClassFrame.inheritedEquals(membersByClass, this.curMembersByClass)) {
                return;
            }
            this.extendsInheritedCanvases.forEach(c -> this.removeCanvas(c.canvas));
            this.extendsInheritedCanvases.clear();
            List<String> classNames = membersByClass.keySet().stream().sorted(this.getSuperClassComparator()).collect(Collectors.toList());
            Collections.reverse(classNames);
            classNames.forEach(cls -> {
                InheritedCanvas section = new InheritedCanvas(this, this.editor, (String)cls, classNames.size() == 1);
                if (!this.inheritedLabel.expandedProperty().get()) {
                    section.canvas.shrinkUsing((DoubleExpression)new ReadOnlyDoubleWrapper(0.0));
                    if (section.optionalCollapse != null) {
                        section.optionalCollapse.setVisible(false);
                    }
                    if (section.precedingDividerLabel != null) {
                        section.precedingDividerLabel.shrinkInstantly();
                    }
                }
                this.extendsInheritedCanvases.add((Object)section);
                this.addCanvas(section.precedingDivider, section.canvas, 0);
                List items = (List)membersByClass.get(cls);
                List<AssistContentThreadSafe> methods = items.stream().filter(a -> a.getKind() == AssistContent.CompletionKind.METHOD).collect(Collectors.toList());
                List<AssistContentThreadSafe> fields = items.stream().filter(a -> a.getKind() == AssistContent.CompletionKind.FIELD).collect(Collectors.toList());
                Collections.reverse(fields);
                fields.forEach(field -> section.canvas.insertBlockBefore(new InheritedFieldFrame(this.editor, AccessPermission.fromAccess(field.getAccessPermission()), field.getType(), field.getName()), section.canvas.getFirstCursor()));
                Collections.reverse(methods);
                methods.forEach(method -> section.canvas.insertBlockBefore(new InheritedMethodFrame(this.editor, this, (String)cls, AccessPermission.fromAccess(method.getAccessPermission()), method.getType(), method.getName(), method.getParams()), section.canvas.getFirstCursor()));
            });
            this.extendsInheritedCanvases.forEach(s -> s.canvas.getCursors().forEach(c -> c.getNode().setFocusTraversable(false)));
            this.curMembersByClass = membersByClass;
        });
    }

    private static boolean inheritedEquals(Map<String, List<AssistContentThreadSafe>> a, Map<String, List<AssistContentThreadSafe>> b) {
        Set<String> bk;
        if (a.size() != b.size()) {
            return false;
        }
        Set<String> ak = a.keySet();
        if (!ak.equals(bk = b.keySet())) {
            return false;
        }
        for (String k : ak) {
            List<AssistContentThreadSafe> av = a.get(k);
            List<AssistContentThreadSafe> bv = b.get(k);
            if (av.size() != bv.size()) {
                return false;
            }
            for (int i = 0; i < av.size(); ++i) {
                AssistContentThreadSafe ax = av.get(i);
                AssistContentThreadSafe bx = bv.get(i);
                if (ax.getKind() != bx.getKind() || ax.getAccessPermission() != bx.getAccessPermission() || !ax.getName().equals(bx.getName()) || !ax.getType().equals(bx.getType())) {
                    return false;
                }
                if (ax.getKind() != AssistContent.CompletionKind.METHOD) continue;
                List<AssistContent.ParamInfo> ap = ax.getParams();
                List<AssistContent.ParamInfo> bp = bx.getParams();
                if (ap.size() != bp.size()) {
                    return false;
                }
                for (int j = 0; j < ap.size(); ++j) {
                    String aFormalName = ap.get(j).getFormalName();
                    String bFormalName = bp.get(j).getFormalName();
                    if (!(aFormalName != null ? !aFormalName.equals(bFormalName) : bFormalName != null) && ap.get(j).getQualifiedType().equals(bp.get(j).getQualifiedType())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public void withInheritedItems(Set<AssistContent.CompletionKind> kinds, FXPlatformConsumer<Map<String, List<AssistContentThreadSafe>>> handler) {
        this.editor.withAccessibleMembers(this.getCode().getPosInsideClass(), kinds, true, allMembers -> {
            HashMap<String, List> methodsByClass = new HashMap<String, List>();
            for (AssistContentThreadSafe a : allMembers) {
                if (a.getDeclaringClass().equals(this.paramName.getText())) continue;
                if (methodsByClass.containsKey(a.getDeclaringClass())) {
                    ((List)methodsByClass.get(a.getDeclaringClass())).add(a);
                    continue;
                }
                ArrayList<AssistContentThreadSafe> l = new ArrayList<AssistContentThreadSafe>();
                l.add(a);
                methodsByClass.put(a.getDeclaringClass(), l);
            }
            Comparator<AssistContentThreadSafe> comparator = Comparator.comparing(AssistContentThreadSafe::getName).thenComparing(ac -> ac.getParams() == null ? Collections.emptyList() : Utility.mapList(ac.getParams(), AssistContent.ParamInfo::getUnqualifiedType), Utility.listComparator());
            methodsByClass.forEach((k, v) -> v.sort(comparator));
            handler.accept(methodsByClass);
        });
    }

    @Override
    public BirdseyeManager prepareBirdsEyeView(SharedTransition animate) {
        final List<FrameCanvas> canvases = Arrays.asList(this.constructorsCanvas, this.methodsCanvas);
        int startingCanvas = -1;
        Frame startingFrame = null;
        while (startingFrame == null) {
            startingFrame = canvases.get(++startingCanvas).getBlockContents().stream().filter(f -> !(f instanceof CommentFrame)).findFirst().orElse(null);
        }
        Node focusOwner = canvases.get(0).getNode().getScene().getFocusOwner();
        block1: for (int i = 0; i < canvases.size(); ++i) {
            for (Frame f2 : canvases.get(i).getBlockContents()) {
                if (f2 instanceof CommentFrame || !this.nodeInside(focusOwner, (Parent)f2.getNode()) && f2.getCursorBefore().getNode() != focusOwner && (f2.getCursorAfter().getFrameAfter() != null || f2.getCursorAfter().getNode() != focusOwner)) continue;
                startingCanvas = i;
                startingFrame = f2;
                break block1;
            }
        }
        final int finalStartingCanvas = startingCanvas;
        final Frame finalStartingFrame = startingFrame;
        return new BirdseyeManager(){
            private int canvasIndex;
            private Frame frame;
            {
                this.canvasIndex = finalStartingCanvas;
                this.frame = finalStartingFrame;
            }

            @Override
            public String getAccessibleText(Frame.View viewMode) {
                return this.frame.getScreenReaderText(viewMode);
            }

            @Override
            public Node getNodeForRectangle() {
                return this.frame.getNode();
            }

            @Override
            public Node getNodeForVisibility() {
                return ClassFrame.getHeaderNodeOf(this.frame);
            }

            private Frame getFrameAt(double sceneX, double sceneY) {
                for (FrameCanvas canvas : canvases) {
                    for (Frame f : canvas.getBlockContents()) {
                        Node n = f.getNode();
                        Point2D scene = n.localToScene(n.getBoundsInLocal().getMinX(), n.getBoundsInLocal().getMinY());
                        if (!(scene.getX() <= sceneX) || !(sceneX < scene.getX() + n.getBoundsInLocal().getWidth()) || !(scene.getY() <= sceneY) || !(sceneY < scene.getY() + n.getBoundsInLocal().getHeight())) continue;
                        return f;
                    }
                }
                return null;
            }

            @Override
            public boolean canClick(double sceneX, double sceneY) {
                return this.getFrameAt(sceneX, sceneY) != null;
            }

            @Override
            public FrameCursor getClickedTarget(double sceneX, double sceneY) {
                Frame f = this.getFrameAt(sceneX, sceneY);
                if (f != null) {
                    return f.getFirstInternalCursor();
                }
                return null;
            }

            @Override
            public FrameCursor getCursorForCurrent() {
                return this.frame.getFirstInternalCursor();
            }

            @Override
            public void up() {
                Frame candidate = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameBefore(((FrameCanvas)canvases.get(this.canvasIndex)).getCursorBefore(this.frame));
                int prospective = this.canvasIndex;
                while (candidate == null || candidate instanceof CommentFrame) {
                    if (candidate == null) {
                        if (--prospective < 0) {
                            candidate = null;
                            break;
                        }
                        candidate = ((FrameCanvas)canvases.get(prospective)).getFrameBefore(((FrameCanvas)canvases.get(prospective)).getLastCursor());
                        continue;
                    }
                    candidate = ((FrameCanvas)canvases.get(prospective)).getFrameBefore(((FrameCanvas)canvases.get(prospective)).getCursorBefore(candidate));
                }
                if (candidate != null && !(candidate instanceof CommentFrame)) {
                    this.frame = candidate;
                    this.canvasIndex = prospective;
                }
            }

            @Override
            public void down() {
                Frame candidate = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameAfter(((FrameCanvas)canvases.get(this.canvasIndex)).getCursorAfter(this.frame));
                int prospective = this.canvasIndex;
                while (candidate == null || candidate instanceof CommentFrame) {
                    if (candidate == null) {
                        if (++prospective >= canvases.size()) {
                            candidate = null;
                            break;
                        }
                        candidate = ((FrameCanvas)canvases.get(prospective)).getFrameAfter(((FrameCanvas)canvases.get(prospective)).getFirstCursor());
                        continue;
                    }
                    candidate = ((FrameCanvas)canvases.get(prospective)).getFrameAfter(((FrameCanvas)canvases.get(prospective)).getCursorAfter(candidate));
                }
                if (candidate != null && !(candidate instanceof CommentFrame)) {
                    this.frame = candidate;
                    this.canvasIndex = prospective;
                }
            }
        };
    }

    @Override
    public void addExtendsClassOrInterface(String className) {
        this.extendsSlot.setText(className);
    }

    @Override
    public void removeExtendsClass() {
        this.extendsSlot.setText("");
    }

    @Override
    public void addImplements(String className) {
        this.implementsSlot.addTypeSlotAtEnd(className, false);
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName) {
        List<TypeSlotFragment> implementsTypes = this.implementsSlot.getTypes();
        for (int i = 0; i < implementsTypes.size(); ++i) {
            if (!implementsTypes.get(i).getContent().equals(interfaceName)) continue;
            this.implementsSlot.removeIndex(i);
            return;
        }
    }

    private boolean nodeInside(Node target, Parent parent) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (node == target) {
                return true;
            }
            if (!(node instanceof Parent) || !this.nodeInside(target, (Parent)node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDoBirdseye() {
        return Stream.concat(this.constructorsCanvas.getBlockContents().stream(), this.methodsCanvas.getBlockContents().stream()).anyMatch(f -> !(f instanceof CommentFrame));
    }

    @Override
    public void addDefaultConstructor() {
        this.constructorsCanvas.getFirstCursor().insertBlockAfter(ConstructorFrame.getFactory().createBlock(this.editor));
    }

    @Override
    public List<ConstructorFrame> getConstructors() {
        return this.constructorsCanvas.getBlocksSubtype(ConstructorFrame.class);
    }

    @Override
    public List<NormalMethodFrame> getMethods() {
        return this.methodsCanvas.getBlocksSubtype(NormalMethodFrame.class);
    }

    public FrameCanvas getConstructorsCanvas() {
        return this.constructorsCanvas;
    }

    public void findMethod(String methodName, List<AssistContent.ParamInfo> params, FXConsumer<NormalMethodFrame> callback) {
        ClassElement el = this.getCode();
        JavaFXUtil.runNowOrLater(() -> {
            Optional<NormalMethodFrame> method = el.streamMethods().filter(e -> {
                if (!(e instanceof NormalMethodElement)) {
                    return false;
                }
                NormalMethodElement m = (NormalMethodElement)e;
                return m.equalDeclaration(methodName, params, el);
            }).map(e -> ((NormalMethodElement)e).getFrame()).findFirst();
            callback.accept(method.orElse(null));
        });
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        if (!this.extendsInheritedCanvases.isEmpty() && newView != Frame.View.NORMAL) {
            this.inheritedLabel.expandedProperty().set(false);
        }
        this.inheritedLabel.setVisible(newView == Frame.View.NORMAL);
    }

    @Override
    protected List<FrameContentRow> getLabelRows() {
        return Arrays.asList(this.importRow, this.fieldsLabelRow, this.constructorsLabelRow, this.methodsLabelRow);
    }

    @Override
    protected List<SlotLabel> getCanvasLabels() {
        return Arrays.asList(this.importsLabel, this.fieldsLabel, this.constructorsLabel, this.methodsLabel);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void compiled() {
        JavaFXUtil.runAfterCurrent(() -> this.updateInheritedItems());
    }

    @Override
    public Stream<FrameCanvas> getPersistentCanvases() {
        List extendsFrameCanvases = this.extendsInheritedCanvases.stream().map(inheritedCanvas -> inheritedCanvas.canvas).collect(Collectors.toList());
        return this.getCanvases().filter(canvas -> !extendsFrameCanvases.contains(canvas));
    }

    @Override
    public FrameTypeCheck check(FrameCanvas canvas) {
        if (canvas == this.fieldsCanvas) {
            return StrideDictionary.checkClassField();
        }
        if (canvas == this.methodsCanvas) {
            return StrideDictionary.checkClassMethod();
        }
        if (canvas == this.constructorsCanvas) {
            return StrideDictionary.checkConstructor();
        }
        throw new IllegalStateException("Asking about canvas unknown to ClassFrame");
    }

    @Override
    public CanvasParent.CanvasKind getChildKind(FrameCanvas c) {
        if (c == this.fieldsCanvas) {
            return CanvasParent.CanvasKind.FIELDS;
        }
        if (c == this.constructorsCanvas) {
            return CanvasParent.CanvasKind.CONSTRUCTORS;
        }
        if (c == this.methodsCanvas) {
            return CanvasParent.CanvasKind.METHODS;
        }
        return CanvasParent.CanvasKind.STATEMENTS;
    }

    @Override
    public void restore(ClassElement target) {
        this.paramName.setText(target.getName());
        this.abstractModifier.set(target.isAbstract());
        this.restoreExtends(target);
        this.implementsSlot.setTypes(target.getImplements());
        this.importCanvas.restore(target.getImports(), this.editor);
        this.methodsCanvas.restore(target.getMethods(), this.editor);
        this.fieldsCanvas.restore(target.getFields(), this.editor);
        this.constructorsCanvas.restore(target.getConstructors(), this.editor);
    }

    private void restoreExtends(ClassElement target) {
        String targetExtends = target.getExtends();
        if (targetExtends != null) {
            if (!this.extendsSlot.getText().equals(targetExtends)) {
                this.extendsSlot.setText(targetExtends);
            }
        } else if (this.showingExtends.get()) {
            this.extendsSlot.setText("");
        }
    }

    @Override
    protected FrameContentRow makeHeader(String stylePrefix) {
        return new FrameContentRow(this, stylePrefix){

            @Override
            public boolean focusRightEndFromNext() {
                ClassFrame.this.focusHasBeenInNameOrExtends.set(true);
                ClassFrame.this.implementsSlot.ensureAtLeastOneSlot();
                Utility.findLast(ClassFrame.this.implementsSlot.getTypeSlots()).get().requestFocus(Focus.RIGHT);
                return true;
            }
        };
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart(FrameContentItem srcRow, HeaderItem src) {
        if (src == this.extendsSlot) {
            this.extendsSlot.setText("");
            this.paramName.requestFocus(Focus.RIGHT);
            return false;
        }
        return super.backspaceAtStart(srcRow, src);
    }

    @Override
    public String getHelpContext() {
        return "in class " + (String)this.nameProperty().get();
    }
}

