/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.parser.ParseFailure;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.convert.ConvertResultDialog;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.Frame;
import bluej.utility.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GreenfootFrameUtil {
    @OnThread(value=Tag.FXPlatform)
    public static List<CodeElement> getClipboardElements(Parser.JavaContext context) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString()) {
            XMLParseResult strideParseResult = GreenfootFrameUtil.getElements(clipboard.getString());
            if (strideParseResult.elements != null) {
                return strideParseResult.elements;
            }
            try {
                Parser.ConversionResult javaConvertResult = Parser.javaToStride(clipboard.getString(), context, false);
                if (!javaConvertResult.getWarnings().isEmpty()) {
                    new ConvertResultDialog(javaConvertResult.getWarnings().stream().map(ConversionWarning::getMessage).collect(Collectors.toList())).showAndWait();
                }
                return javaConvertResult.getElements();
            }
            catch (ParseFailure pf) {
                new ConvertResultDialog(strideParseResult.error, pf.getMessage()).showAndWait();
                return null;
            }
        }
        return null;
    }

    private static XMLParseResult getElements(String xmlString) {
        Builder parser = new Builder();
        Document doc = null;
        try {
            doc = parser.build(xmlString, null);
        }
        catch (IOException | ParsingException e) {
            Debug.reportError(e);
            return new XMLParseResult(e.getMessage());
        }
        if (doc == null) {
            return new XMLParseResult("Unknown error");
        }
        Element root = doc.getRootElement();
        if (!root.getLocalName().equals("frames")) {
            return new XMLParseResult("Outer element was not frames");
        }
        ArrayList<CodeElement> elements = new ArrayList<CodeElement>();
        for (int i = 0; i < root.getChildElements().size(); ++i) {
            elements.add(Loader.loadElement(root.getChildElements().get(i)));
        }
        return new XMLParseResult(elements);
    }

    public static String getXmlForMultipleFrames(List<Frame> frames) {
        Element framesEl = GreenfootFrameUtil.getXmlElementForMultipleFrames(frames);
        return framesEl.toXML();
    }

    public static Element getXmlElementForMultipleFrames(List<Frame> frames) {
        Element framesEl = new Element("frames");
        for (Frame f : frames) {
            if (!(f instanceof CodeFrame)) continue;
            ((CodeFrame)((Object)f)).regenerateCode();
            Object c = ((CodeFrame)((Object)f)).getCode();
            framesEl.appendChild((Node)((CodeElement)c).toXML());
        }
        return framesEl;
    }

    @OnThread(value=Tag.FXPlatform)
    private static String getJavaForMultipleFrames(List<Frame> frames) {
        StringBuilder java = new StringBuilder();
        for (Frame f : frames) {
            if (!(f instanceof CodeFrame)) continue;
            Object c = ((CodeFrame)((Object)f)).getCode();
            java.append(((CodeElement)c).toJavaSource().toTemporaryJavaCodeString());
        }
        return java.toString();
    }

    public static List<CodeElement> getElementsForMultipleFrames(List<Frame> frames) {
        return GreenfootFrameUtil.getElements((String)GreenfootFrameUtil.getXmlForMultipleFrames(frames)).elements;
    }

    public static void doCopyAsStride(List<Frame> frames) {
        if (frames.size() == 0) {
            return;
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(GreenfootFrameUtil.getXmlForMultipleFrames(frames));
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public static void doCopyAsImage(List<Frame> frames) {
        if (frames.size() == 0) {
            return;
        }
        ClipboardContent content = new ClipboardContent();
        content.putImage(Frame.takeShot(frames, null));
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void doCopyAsJava(List<Frame> frames) {
        if (frames.size() == 0) {
            return;
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(GreenfootFrameUtil.getJavaForMultipleFrames(frames));
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private static class XMLParseResult {
        public final List<CodeElement> elements;
        public final String error;

        public XMLParseResult(List<CodeElement> elements) {
            this.elements = elements;
            this.error = null;
        }

        public XMLParseResult(String error) {
            this.elements = null;
            this.error = error;
        }
    }
}

