/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.Config;
import bluej.debugger.gentype.Reflective;
import bluej.editor.fixes.SuggestionList;
import bluej.parser.AssistContent;
import bluej.parser.AssistContentThreadSafe;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.framedjava.slots.TypeSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.ScreenreaderDictionary;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.ToggleBooleanProperty;
import bluej.stride.slots.ChoiceSlot;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.MethodNameDefTextSlot;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.WrappableSlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TextField;
import threadchecker.OnThread;
import threadchecker.Tag;

public class NormalMethodFrame
extends MethodFrameWithBody<NormalMethodElement> {
    public static final String STATIC_NAME = "static";
    public static final String TOGGLE_STATIC_METHOD = "toggleStaticMethod";
    public static final String FINAL_NAME = "final";
    public static final String TOGGLE_FINAL_METHOD = "toggleFinalMethod";
    private final SlotLabel staticLabel;
    private BooleanProperty staticModifier = new SimpleBooleanProperty(false);
    private final SlotLabel finalLabel;
    private BooleanProperty finalModifier = new SimpleBooleanProperty(false);
    private final WrappableSlotLabel overrideLabel = new WrappableSlotLabel(""){

        @Override
        public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
            if (oldView == Frame.View.NORMAL && newView == Frame.View.JAVA_PREVIEW) {
                this.fadeOut(animate, true);
            } else {
                this.fadeIn(animate);
            }
        }
    };
    private @OnThread(value=Tag.FXPlatform) String curOverrideSource = null;
    private final TypeSlot returnType;
    private final TextSlot<NameDefSlotFragment> methodName;
    private NormalMethodElement element;

    private NormalMethodFrame(InteractionManager editor) {
        super(editor);
        this.setDocumentationPromptText(Config.getString("frame.class.method.doc.prompt"));
        this.methodName = new MethodNameDefTextSlot(editor, this, this.getHeaderRow(), new MethodOverrideCompletionCalculator(), "method-name-");
        this.methodName.addValueListener(new SlotTraversalChars(() -> this.getHeaderRow().focusRight(this.methodName), SlotTraversalChars.METHOD_NAME.getChars()){

            @Override
            public void deletePressedAtEnd(HeaderItem slot) {
                NormalMethodFrame.this.paramsPane.deleteFirstParam();
            }
        });
        this.returnType = new TypeSlot(editor, this, this, this.getHeaderRow(), TypeSlot.Role.RETURN, "method-return-type-");
        this.returnType.addClosingChar(' ');
        this.returnType.markReturnType();
        this.paramsPane = new FormalParameters(editor, this, this, this.getHeaderRow(), "method-param-");
        this.returnType.setSimplePromptText("type");
        this.methodName.setPromptText("name");
        this.staticLabel = new SlotLabel("static ", new String[0]);
        this.finalLabel = new SlotLabel("final ", new String[0]);
        this.modifiers.put(STATIC_NAME, this.staticModifier);
        this.modifiers.put(FINAL_NAME, this.finalModifier);
        this.overrideLabel.addStyleClass("method-override-label");
        this.overrideLabel.setAlignment(HangingFlowPane.FlowAlignment.RIGHT);
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<? extends HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new ChoiceSlot[]{this.access}), JavaFXUtil.listBool((BooleanExpression)this.staticModifier, this.staticLabel), JavaFXUtil.listBool((BooleanExpression)this.finalModifier, this.finalLabel), FXCollections.observableArrayList((Object[])new TypeSlot[]{this.returnType}), FXCollections.observableArrayList((Object[])new TextSlot[]{this.methodName}), this.paramsPane.getSlots(), this.throwsPane.getHeaderItems(), FXCollections.observableArrayList((Object[])new WrappableSlotLabel[]{this.overrideLabel})}));
        JavaFXUtil.addChangeListener(this.staticModifier, b -> editor.modifiedFrame(this, false));
        JavaFXUtil.addChangeListener(this.finalModifier, b -> editor.modifiedFrame(this, false));
        this.frameName = "method " + this.methodName.getText();
        this.returnType.setSlotName("return type");
    }

    public NormalMethodFrame(InteractionManager editor, AccessPermissionFragment access, boolean staticModifier, boolean finalModifier, String returnType, String name, String documentation, boolean enabled) {
        this(editor);
        this.access.setValue(access.getValue());
        access.registerSlot(this.access);
        this.staticModifier.set(staticModifier);
        this.finalModifier.set(finalModifier);
        this.setDocumentation(documentation);
        this.returnType.setText(returnType);
        this.methodName.setText(name);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public String getScreenReaderText(Frame.View viewMode) {
        StringBuilder paramString = new StringBuilder();
        for (ParamFragment pair : this.paramsPane.getSlotElement()) {
            String name = ((TextSlot)pair.getParamName().getSlot()).getText().equals("") ? "blank" : ((TextSlot)pair.getParamName().getSlot()).getText();
            String type = pair.getParamType().getSlot().getText().equals("") ? "blank" : pair.getParamType().getSlot().getText();
            paramString.append(type + " " + name + " ");
        }
        String nameString = this.methodName.getText().equals("") ? "blank" : ScreenreaderDictionary.transcribeForScreenreader(this.methodName.getText());
        String returnString = this.returnType.getText().equals("") ? "blank" : this.returnType.getText();
        String text = paramString.length() != 0 ? "Method " + nameString + "() with parameters " + paramString.toString() + " with " + this.access.getValue(AccessPermission.PUBLIC).toString() + " access and " + returnString + " return type " : "Method " + nameString + "() with " + this.access.getValue(AccessPermission.PUBLIC).toString() + " access and " + returnString + " return type ";
        if (this.finalModifier.get()) {
            text = this.finalLabel.getText() + " " + text;
        }
        if (this.staticModifier.get()) {
            text = this.staticLabel.getText() + " " + text;
        }
        if (viewMode != Frame.View.BIRDSEYE_NODOC) {
            text = text + ". Documentation: " + this.getDocumentation();
        }
        return text;
    }

    @Override
    public String getLocationDescription(FrameCanvas c) {
        String nameString = this.methodName.getText().equals("") ? "blank" : this.methodName.getText();
        String text = " in the method " + nameString + ",";
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            text = text + this.getParentCanvas().getParentLocationDescription();
        }
        return text;
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.returnType.requestFocus();
        return true;
    }

    public static FrameFactory<NormalMethodFrame> getFactory() {
        return new FrameFactory<NormalMethodFrame>(){

            @Override
            public NormalMethodFrame createBlock(InteractionManager editor) {
                return new NormalMethodFrame(editor);
            }

            @Override
            public Class<NormalMethodFrame> getBlockClass() {
                return NormalMethodFrame.class;
            }
        };
    }

    @Override
    public void regenerateCode() {
        List<ParamFragment> params = this.generateParams();
        this.element = new NormalMethodElement(this, new AccessPermissionFragment(this, this.access), this.staticModifier.get(), this.finalModifier.get(), (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), params, this.throwsPane.getTypes(), this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
    }

    @Override
    public NormalMethodElement getCode() {
        return this.element;
    }

    public String getName() {
        return this.methodName.getText();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> operations = new ArrayList<FrameOperation>(super.getContextOperations());
        InteractionManager editor = this.getEditor();
        operations.add(new CustomFrameOperation(editor, "method->constructor", Arrays.asList(Config.getString("frame.operation.change"), Config.getString("frame.operation.change.to.constructor")), AbstractOperation.MenuItemOrder.TRANSFORM, this, () -> {
            Frame parent = this.getParentCanvas().getParent().getFrame();
            if (parent instanceof ClassFrame) {
                FrameCanvas p = ((ClassFrame)parent).getConstructorsCanvas();
                FrameCursor c = p.getLastCursor();
                ConstructorElement el = new ConstructorElement(null, new AccessPermissionFragment(this, this.access), this.generateParams(), this.throwsPane.getTypes(), null, null, this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
                c.insertBlockAfter(el.createFrame(this.getEditor()));
                this.getParentCanvas().removeBlock(this);
            }
        }));
        operations.add(new CustomFrameOperation(editor, "concrete->abstract", Arrays.asList(Config.getString("frame.operation.change"), Config.getString("frame.operation.change.to.abstract")), AbstractOperation.MenuItemOrder.TRANSFORM, this, () -> {
            FrameCursor c = this.getCursorBefore();
            MethodProtoElement el = new MethodProtoElement(null, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.generateParams(), this.throwsPane.getTypes(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
            c.insertBlockAfter(el.createFrame(this.getEditor()));
            c.getParentCanvas().removeBlock(this);
        }));
        operations.addAll(this.getStaticFinalOperations());
        return operations;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas innerCanvas, FrameCursor cursorInCanvas) {
        ArrayList<ExtensionDescription> extensions = new ArrayList<ExtensionDescription>(super.getAvailableExtensions(innerCanvas, cursorInCanvas));
        this.getStaticFinalOperations().stream().forEach(op -> extensions.add(new ExtensionDescription((ToggleBooleanProperty)op, this, true, ExtensionDescription.ExtensionSource.BEFORE, ExtensionDescription.ExtensionSource.AFTER, ExtensionDescription.ExtensionSource.MODIFIER, ExtensionDescription.ExtensionSource.SELECTION)));
        return extensions;
    }

    private List<ToggleBooleanProperty> getStaticFinalOperations() {
        ArrayList<ToggleBooleanProperty> operations = new ArrayList<ToggleBooleanProperty>();
        operations.add(new ToggleBooleanProperty(this.getEditor(), TOGGLE_FINAL_METHOD, FINAL_NAME, 'n'));
        operations.add(new ToggleBooleanProperty(this.getEditor(), TOGGLE_STATIC_METHOD, STATIC_NAME, 's'));
        return operations;
    }

    public StringExpression returnTypeProperty() {
        return this.returnType.javaProperty();
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateOverrideDisplay(ClassElement topLevel) {
        if (this.element == null) {
            return;
        }
        NormalMethodElement cachedElement = this.element;
        List<String> qualParamTypes = cachedElement.getQualifiedParamTypes(topLevel);
        Reflective overriddenFrom = topLevel.findSuperMethod(cachedElement.getName(), qualParamTypes);
        if (overriddenFrom != null) {
            String name = overriddenFrom.getSimpleName();
            if (name.indexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            String nameFinal = name;
            if (this.curOverrideSource == null || !this.curOverrideSource.equals(nameFinal)) {
                this.curOverrideSource = nameFinal;
                this.overrideLabel.setText(Config.getString("frame.class.overrides.from").replace("$", nameFinal));
            }
        } else if (this.curOverrideSource != null) {
            this.curOverrideSource = null;
            this.overrideLabel.setText("");
        }
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.methodName;
    }

    @Override
    public void focusName() {
        this.methodName.requestFocus(Focus.LEFT);
    }

    @Override
    protected FrameContentRow makeHeader(String stylePrefix) {
        return new MethodFrameWithBody.MethodHeaderRow((Frame)this, stylePrefix){

            @Override
            protected EditableSlot getSlotAfterParams() {
                return NormalMethodFrame.this.throwsPane.getTypeSlots().findFirst().orElse(null);
            }

            @Override
            protected EditableSlot getSlotBeforeParams() {
                return NormalMethodFrame.this.methodName;
            }
        };
    }

    @Override
    public boolean tryRestoreTo(CodeElement codeElement) {
        if (codeElement instanceof NormalMethodElement) {
            NormalMethodElement nme = (NormalMethodElement)codeElement;
            this.staticModifier.set(nme.isStatic());
            this.finalModifier.set(nme.isFinal());
            this.returnType.setText(nme.getType());
            this.methodName.setText(nme.getName());
            this.restoreDetails(nme);
            return true;
        }
        return false;
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            this.documentationPane.setScreenReaderHelpSlots("You are in the documentation slot for the method " + this.methodName.getText() + this.getParentCanvas().getParentLocationDescription());
            for (ParamFragment pair : this.paramsPane.getSlotElement()) {
                pair.getParamType().getSlot().setSlotName(" parameter type slot ");
                pair.getParamType().getSlot().setAccessibilityHelpSlots();
                ((TextSlot)pair.getParamName().getSlot()).setSlotName(" parameter name slot ");
                ((TextSlot)pair.getParamName().getSlot()).setScreenReaderHelpSlots();
            }
            this.returnType.setSlotName("return type slot");
            this.returnType.setAccessibilityHelpSlots();
            this.methodName.setSlotName("method name slot");
            this.methodName.setScreenReaderHelpSlots();
        }
    }

    @Override
    public String getHelpContext() {
        String parent = "";
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            parent = this.getParentCanvas().getParent().getHelpContext();
        }
        return "in method " + this.getName() + " " + parent;
    }

    private class MethodOverrideCompletionCalculator
    implements CompletionCalculator {
        private List<AssistContentThreadSafe> inheritedMethods;
        private SuggestionList suggestionDisplay;

        private MethodOverrideCompletionCalculator() {
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, CodeElement codeEl, SuggestionList.SuggestionListListener listener, FXPlatformConsumer<SuggestionList> handler) {
            ClassFrame classFrame = (ClassFrame)ASTUtility.getTopLevelElement(codeEl).getFrame();
            classFrame.withInheritedItems(Collections.singleton(AssistContent.CompletionKind.METHOD), inheritedMethodsByDeclarer -> {
                this.inheritedMethods = inheritedMethodsByDeclarer.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                this.suggestionDisplay = new SuggestionList(NormalMethodFrame.this.getEditor(), Utility.mapList(this.inheritedMethods, ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getParamsCompletionDisplay(ac), ac.getType(), SuggestionList.SuggestionShown.COMMON, ac.getDocHTML())), null, SuggestionList.SuggestionShown.RARE, null, listener);
                handler.accept(this.suggestionDisplay);
            });
        }

        @Override
        public boolean execute(TextField field, int selected, int startOfCurWord) {
            if (selected == -1) {
                return false;
            }
            AssistContentThreadSafe a = this.inheritedMethods.get(selected);
            NormalMethodFrame.this.methodName.setText(a.getName());
            NormalMethodFrame.this.returnType.setText(a.getType());
            NormalMethodFrame.this.access.setValue(AccessPermission.fromAccess(a.getAccessPermission()));
            NormalMethodFrame.this.paramsPane.setParams(a.getParams(), AssistContent.ParamInfo::getUnqualifiedType, AssistContent.ParamInfo::getFormalName);
            return true;
        }
    }
}

