/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.collect.StrideEditReason;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.FrameHelper;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.CursorFinder;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameEffects;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.CopyFrameAsImageOperation;
import bluej.stride.operations.CopyFrameAsJavaOperation;
import bluej.stride.operations.CopyFrameAsStrideOperation;
import bluej.stride.operations.CutFrameOperation;
import bluej.stride.operations.DeleteFrameOperation;
import bluej.stride.operations.DisableFrameOperation;
import bluej.stride.operations.EnableFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.BetterVBox;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class Frame
implements CursorFinder,
FocusParent<FrameContentItem>,
ErrorShower,
AbstractOperation.ContextualItem<Frame> {
    protected final ObservableList<FrameContentItem> contents = FXCollections.observableArrayList();
    protected final FrameContentRow header;
    protected final SlotLabel headerCaptionLabel;
    protected final BooleanProperty frameEnabledProperty = new SimpleBooleanProperty(true);
    private final BetterVBox frameContents;
    private final BooleanProperty disabledRoot = new SimpleBooleanProperty(true);
    private final String stylePrefix;
    private final FXConsumer effectForUIListener;
    private String name;
    protected String frameName;
    private final ObjectProperty<FramePreviewEnabled> framePreviewEnableProperty = new SimpleObjectProperty((Object)FramePreviewEnabled.PREVIEW_NONE);
    private final BooleanProperty frameDragSourceProperty = new SimpleBooleanProperty(false);
    private final InteractionManager editor;
    private final BooleanProperty fresh = new SimpleBooleanProperty(false);
    private final ObservableList<CodeError> allFrameErrors = FXCollections.observableArrayList();
    private final ObjectProperty<CodeError> shownError = new SimpleObjectProperty(null);
    private FrameCanvas parentCanvas = null;
    private boolean alwaysBeenBlank = true;
    protected Map<String, BooleanProperty> modifiers = new HashMap<String, BooleanProperty>();

    public String getFrameName() {
        ArrayList<Character> vowels = new ArrayList<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('o')));
        return (vowels.contains(Character.valueOf(this.frameName.charAt(0))) ? "n " : " ") + this.frameName;
    }

    public String getScreenReaderText(View viewMode) {
        return this.frameName;
    }

    public abstract String getScreenReaderHelp();

    public final String getStylePrefix() {
        return this.stylePrefix;
    }

    @OnThread(value=Tag.FXPlatform)
    public void lostFocus() {
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertedWithCtrl() {
    }

    @OnThread(value=Tag.FX)
    public Frame(InteractionManager editor, String caption, String stylePrefix) {
        this.frameContents = new BetterVBox(200.0){

            @Override
            @OnThread(value=Tag.FX)
            public double getBottomMarginFor(Node n) {
                return Frame.this.getBottomMarginFor(n);
            }

            @Override
            @OnThread(value=Tag.FX)
            public double getLeftMarginFor(Node n) {
                return Frame.this.getLeftMarginFor(n);
            }

            @Override
            @OnThread(value=Tag.FX)
            public double getRightMarginFor(Node n) {
                return Frame.this.getRightMarginFor(n);
            }
        };
        if (stylePrefix == null) {
            throw new NullPointerException();
        }
        JavaFXUtil.addStyleClass((Styleable)this.frameContents, "frame", stylePrefix + "frame");
        this.stylePrefix = stylePrefix;
        this.frameEnabledProperty.addListener((a, b, enabled) -> {
            this.getEditableSlotsDirect().forEach(e -> e.setEditable((boolean)enabled));
            editor.modifiedFrame(this, false);
        });
        this.effectForUIListener = newVal -> {
            boolean isDisabledRoot = this.disabledRoot.get();
            boolean isFrameEnabled = this.frameEnabledProperty.get();
            FramePreviewEnabled framePreview = (FramePreviewEnabled)((Object)((Object)this.framePreviewEnableProperty.get()));
            boolean isFrameDragged = this.frameDragSourceProperty.get();
            Object effect = isDisabledRoot && (!isFrameEnabled && framePreview.equals((Object)FramePreviewEnabled.PREVIEW_NONE) || framePreview.equals((Object)FramePreviewEnabled.PREVIEW_DISABLED)) ? (isFrameDragged ? FrameEffects.getDragSourceAndDisabledEffect() : FrameEffects.getDisabledEffect()) : (isFrameDragged ? FrameEffects.getDragSourceEffect() : null);
            this.frameContents.setEffect((Effect)effect);
        };
        JavaFXUtil.addChangeListenerAndCallNow(this.disabledRoot, this.effectForUIListener);
        JavaFXUtil.addChangeListenerAndCallNow(this.frameEnabledProperty, this.effectForUIListener);
        JavaFXUtil.addChangeListenerAndCallNow(this.framePreviewEnableProperty, this.effectForUIListener);
        JavaFXUtil.addChangeListenerAndCallNow(this.frameDragSourceProperty, this.effectForUIListener);
        this.editor = editor;
        if (editor != null) {
            editor.setupFrame(this);
        }
        this.headerCaptionLabel = caption == null ? null : new SlotLabel(caption, "caption", stylePrefix + "caption");
        this.header = this.makeHeader(stylePrefix);
        this.contents.addListener(c -> this.frameContents.getChildren().setAll(this.calculateContents(Utility.mapList(this.contents, FrameContentItem::getNode))));
        this.contents.setAll((Object[])new FrameContentItem[]{this.header});
        this.setHeaderRow(new HeaderItem[0]);
        this.getNode().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getCursorAfter().requestFocus();
            }
        });
        this.allFrameErrors.addListener(c -> {
            this.shownError.set((Object)this.allFrameErrors.stream().min(CodeError::compareErrors).orElse(null));
            FXRunnable update = () -> JavaFXUtil.setPseudoclass("bj-frame-error", this.shownError.get() != null, new Node[]{this.frameContents});
            if (this.isFresh()) {
                this.onNonFresh(update);
            } else {
                update.run();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    protected void initialiseFX() {
    }

    public static Image takeShot(List<Frame> frames, Color border) {
        int xOffset;
        int yOffset;
        int y;
        WritableImage collated;
        int totalHeight = 0;
        int maxWidth = 0;
        for (Frame f : frames) {
            Bounds b = f.getNode().getBoundsInParent();
            totalHeight += (int)Math.ceil(b.getHeight()) + 0;
            maxWidth = Math.max(maxWidth, (int)Math.ceil(b.getWidth()));
        }
        totalHeight += 0;
        if (border != null) {
            collated = new WritableImage(maxWidth + 2, totalHeight + 2);
            for (int x = 0; x < maxWidth + 2; ++x) {
                collated.getPixelWriter().setColor(x, 0, border);
                collated.getPixelWriter().setColor(x, totalHeight + 1, border);
            }
            for (y = 0; y < totalHeight + 2; ++y) {
                collated.getPixelWriter().setColor(0, y, border);
                collated.getPixelWriter().setColor(maxWidth + 1, y, border);
            }
            yOffset = 1;
            xOffset = 1;
        } else {
            if (maxWidth * totalHeight < 1) {
                return null;
            }
            collated = new WritableImage(maxWidth, totalHeight);
            yOffset = 0;
            xOffset = 0;
        }
        y = 0;
        for (Frame f : frames) {
            Bounds b = f.getNode().getBoundsInParent();
            WritableImage image = new WritableImage((int)Math.ceil(b.getWidth()), (int)Math.ceil(b.getHeight()));
            SnapshotParameters p = new SnapshotParameters();
            p.setFill((Paint)Color.TRANSPARENT);
            boolean dr = f.disabledRoot.get();
            f.disabledRoot.set(true);
            JavaFXUtil.setPseudoclass("bj-hide-caret", true, f.getNode());
            f.getNode().snapshot(p, image);
            f.disabledRoot.set(dr);
            JavaFXUtil.setPseudoclass("bj-hide-caret", false, f.getNode());
            JavaFXUtil.blitImage(collated, xOffset, yOffset + y, (Image)image);
            y += (int)Math.ceil(b.getHeight()) + 0;
        }
        return collated;
    }

    protected Stream<RecallableFocus> getFocusablesInclContained() {
        return Utility.concat(this.getEditableSlotsDirect(), this.getPersistentCanvases().flatMap(c -> c.getFocusableCursors().stream()), this.getPersistentCanvases().flatMap(c -> c.getBlockContents().stream()).flatMap(Frame::getFocusablesInclContained));
    }

    protected double getRightMarginFor(Node n) {
        return n == this.header.getNode() ? 1.0 : 0.0;
    }

    protected double getLeftMarginFor(Node n) {
        return n == this.header.getNode() ? 1.0 : 0.0;
    }

    protected double getBottomMarginFor(Node n) {
        return 0.0;
    }

    protected FrameContentRow makeHeader(String stylePrefix) {
        return new FrameContentRow(this, stylePrefix);
    }

    protected List<? extends Node> calculateContents(List<Node> normalContent) {
        return normalContent;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<FrameOperation> getContextOperations() {
        ArrayList<FrameOperation> ops = new ArrayList<FrameOperation>();
        ops.add(new CutFrameOperation(this.editor));
        ops.add(new CopyFrameAsStrideOperation(this.editor));
        ops.add(new CopyFrameAsImageOperation(this.editor));
        ops.add(new CopyFrameAsJavaOperation(this.editor));
        ops.add(this.isFrameEnabled() ? new DisableFrameOperation(this.editor) : new EnableFrameOperation(this.editor));
        ops.add(new DeleteFrameOperation(this.editor));
        return ops;
    }

    public final FrameCursor getFirstInternalCursor() {
        return this.getCanvases().map(FrameCanvas::getFirstCursor).findFirst().orElse(null);
    }

    public final FrameCursor getLastInternalCursor() {
        return Utility.findLast(this.getCanvases().map(FrameCanvas::getLastCursor)).orElse(null);
    }

    public FrameCanvas getParentCanvas() {
        return this.parentCanvas;
    }

    public void setParentCanvas(FrameCanvas parentCanvas) {
        FrameCanvas oldCanvas = this.parentCanvas;
        this.parentCanvas = parentCanvas;
        if (oldCanvas != null) {
            oldCanvas.getBlockContents().forEach(f -> f.updateAppearance(f.getParentCanvas()));
        }
        if (parentCanvas != null) {
            parentCanvas.getBlockContents().forEach(f -> f.updateAppearance(f.getParentCanvas()));
            Utility.iterableStream(this.getAllFrames()).forEach(f -> f.updateAppearance(f.getParentCanvas()));
        }
    }

    public final FrameCursor getCursorAfter() {
        return this.parentCanvas == null ? null : this.parentCanvas.getCursorAfter(this);
    }

    public final FrameCursor getCursorBefore() {
        return this.parentCanvas == null ? null : this.parentCanvas.getCursorBefore(this);
    }

    protected final void addStyleClass(String styleClass) {
        JavaFXUtil.addStyleClass((Styleable)this.frameContents, styleClass);
    }

    protected final void removeStyleClass(String styleClass) {
        JavaFXUtil.removeStyleClass((Styleable)this.frameContents, styleClass);
    }

    public final Node getNode() {
        return this.frameContents;
    }

    protected final Region getRegion() {
        return this.frameContents;
    }

    public void updateAppearance(FrameCanvas parentCanvas) {
        this.disabledRoot.set(this.canHaveEnabledState(true));
    }

    public void setDragSourceEffect(boolean on) {
        this.frameDragSourceProperty.set(on);
    }

    public boolean isFrameEnabled() {
        return this.frameEnabledProperty.get();
    }

    public void setFrameEnabled(boolean enabled) {
        if (!this.canHaveEnabledState(enabled)) {
            return;
        }
        this.frameEnabledProperty.set(enabled);
        if (this instanceof CodeFrame) {
            ((CodeFrame)((Object)this)).setElementEnabled(enabled);
        }
        if (!enabled) {
            JavaFXUtil.runNowOrLater(() -> {
                this.flagErrorsAsOld();
                this.removeOldErrors();
            });
        }
        this.getCanvases().forEach(canvas -> canvas.getBlocksSubtype(Frame.class).forEach(b -> b.setFrameEnabled(enabled)));
        this.updateAppearance(this.getParentCanvas());
    }

    public boolean canHaveEnabledState(boolean enabled) {
        Frame parent;
        FrameCanvas canvas;
        if (enabled && (canvas = this.getParentCanvas()) != null && (parent = canvas.getParent().getFrame()) != null) {
            return parent.isFrameEnabled() && parent.canHaveEnabledState(enabled);
        }
        return true;
    }

    public void setFrameEnablePreview(FramePreviewEnabled state) {
        this.framePreviewEnableProperty.set((Object)state);
    }

    @OnThread(value=Tag.FXPlatform)
    public final void flagErrorsAsOld() {
        this.allFrameErrors.forEach(CodeError::flagAsOld);
        this.getEditableSlotsDirect().forEach(EditableSlot::flagErrorsAsOld);
        this.getPossiblyHiddenSlotsDirect().forEach(EditableSlot::flagErrorsAsOld);
        this.getCanvases().forEach(FrameHelper::flagErrorsAsOld);
    }

    @OnThread(value=Tag.FXPlatform)
    public final void removeOldErrors() {
        this.allFrameErrors.removeIf(CodeError::isFlaggedAsOld);
        this.getEditableSlotsDirect().forEach(EditableSlot::removeOldErrors);
        this.getPossiblyHiddenSlotsDirect().forEach(EditableSlot::removeOldErrors);
        this.getCanvases().forEach(FrameHelper::removeOldErrors);
    }

    public final void cleanup() {
        this.getEditableSlots().forEach(EditableSlot::cleanup);
        this.getCanvases().forEach(FrameCanvas::cleanup);
        this.cleanupFrame();
    }

    protected void cleanupFrame() {
    }

    public final Stream<FrameCanvas> getCanvases() {
        return this.contents.stream().map(FrameContentItem::getCanvas).flatMap(Utility::streamOptional);
    }

    public Stream<FrameCanvas> getPersistentCanvases() {
        return this.getCanvases();
    }

    public boolean isCollapsible() {
        return false;
    }

    public void setCollapsed(boolean collapse) {
    }

    public void checkForEmptySlot() {
    }

    public List<ExtensionDescription> getAvailableExtensions(FrameCanvas innerCanvas, FrameCursor cursorInCanvas) {
        if (innerCanvas != null) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ExtensionDescription('\\', "Disable/Enable frames", () -> {
            if (this.canHaveEnabledState(this.isFrameEnabled())) {
                this.setFrameEnabled(!this.isFrameEnabled());
            }
        }, false, ExtensionDescription.ExtensionSource.BEFORE, ExtensionDescription.ExtensionSource.AFTER));
    }

    @OnThread(value=Tag.FXPlatform)
    public final boolean notifyKeyAfter(char c, RecallableFocus rc) {
        return this.notifyKey(c, rc, this.getAvailableExtensions(null, null), ExtensionDescription.ExtensionSource.AFTER);
    }

    @OnThread(value=Tag.FXPlatform)
    public final boolean notifyKeyBefore(char c, RecallableFocus rc) {
        return this.notifyKey(c, rc, this.getAvailableExtensions(null, null), ExtensionDescription.ExtensionSource.BEFORE);
    }

    @OnThread(value=Tag.FXPlatform)
    private final boolean notifyKey(char c, RecallableFocus rc, List<ExtensionDescription> extensions, ExtensionDescription.ExtensionSource src) {
        List candidates = extensions.stream().filter(e -> e.getShortcutKey() == c && e.validFor(src)).collect(Collectors.toList());
        if (candidates.size() == 0) {
            return false;
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException("Ambiguous " + src + " for: " + c);
        }
        this.editor.beginRecordingState(rc);
        ((ExtensionDescription)candidates.get(0)).activate();
        this.editor.endRecordingState(rc);
        return true;
    }

    public boolean canDrag() {
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    public final boolean leftClicked(double sceneX, double sceneY, boolean shiftDown) {
        this.editor.clickNearestCursor(sceneX, sceneY, shiftDown);
        return true;
    }

    public boolean focusWhenJustAdded() {
        EditableSlot s = this.getEditableSlotsDirect().findFirst().orElse(null);
        if (s != null) {
            s.requestFocus();
            return true;
        }
        return false;
    }

    protected void addTopRight(Node n) {
    }

    protected final FrameContentRow getHeaderRow() {
        return this.header;
    }

    protected final void setHeaderRow(HeaderItem ... headerItems) {
        if (this.headerCaptionLabel == null) {
            this.header.setHeaderItems(Arrays.asList(headerItems));
        } else {
            ArrayList<HeaderItem> items = new ArrayList<HeaderItem>();
            items.add(this.headerCaptionLabel);
            items.addAll(Arrays.asList(headerItems));
            this.header.setHeaderItems(items);
        }
    }

    public final boolean focusFrameEnd(boolean up) {
        if (this.isFrameEnabled()) {
            FrameContentItem last = (FrameContentItem)this.contents.get(this.contents.size() - 1);
            return up ? last.focusBottomEndFromNext() : last.focusRightEndFromNext();
        }
        return false;
    }

    public final boolean focusFrameStart() {
        if (this.isFrameEnabled()) {
            FrameContentItem first = (FrameContentItem)this.contents.get(0);
            return first.focusLeftEndFromPrev();
        }
        return false;
    }

    public InteractionManager getEditor() {
        return this.editor;
    }

    public void show(ShowReason reason) {
        switch (reason) {
            case EXCEPTION: {
                JavaFXUtil.setPseudoclass("bj-stack-highlight", true, this.getNode());
                this.getParentCanvas().getCursorBefore(this).requestFocus();
                this.editor.scrollTo(this.getNode(), -50.0);
                this.editor.registerStackHighlight(this);
                break;
            }
            case LINK_TARGET: {
                this.editor.scrollTo(this.getNode(), -50.0);
                this.focusName();
            }
        }
    }

    public void focusName() {
        this.focusWhenJustAdded();
    }

    public void removeStackHighlight() {
        JavaFXUtil.setPseudoclass("bj-stack-highlight", false, this.getNode());
    }

    public final Stream<HeaderItem> getHeaderItems() {
        return this.contents.stream().flatMap(FrameContentItem::getHeaderItemsDeep);
    }

    public final Stream<EditableSlot> getEditableSlots() {
        return this.getHeaderItems().map(HeaderItem::asEditable).filter(x -> x != null);
    }

    public final Stream<EditableSlot> getEditableSlotsDirect() {
        return this.contents.stream().flatMap(FrameContentItem::getHeaderItemsDirect).map(HeaderItem::asEditable).filter(x -> x != null);
    }

    public Stream<EditableSlot> getPossiblyHiddenSlotsDirect() {
        return Stream.empty();
    }

    @Override
    public void focusUp(FrameContentItem src, boolean toEnd) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == 0) {
            this.focusPrevTarget();
        } else if (!((FrameContentItem)this.contents.get(index - 1)).focusBottomEndFromNext()) {
            this.focusUp((FrameContentItem)this.contents.get(index - 1), toEnd);
        }
    }

    @Override
    public void focusDown(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == this.contents.size() - 1) {
            if (this.getCursorAfter() != null) {
                this.getCursorAfter().requestFocus();
            }
        } else if (!((FrameContentItem)this.contents.get(index + 1)).focusTopEndFromPrev()) {
            this.focusDown((FrameContentItem)this.contents.get(index + 1));
        }
    }

    @Override
    public void focusEnter(FrameContentItem src) {
        this.focusDown(src);
    }

    @Override
    public void focusLeft(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == 0) {
            this.focusPrevTarget();
        } else if (!((FrameContentItem)this.contents.get(index - 1)).focusRightEndFromNext()) {
            this.focusLeft((FrameContentItem)this.contents.get(index - 1));
        }
    }

    @Override
    public void focusRight(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == this.contents.size() - 1) {
            if (this.getCursorAfter() != null) {
                this.getCursorAfter().requestFocus();
            }
        } else if (!((FrameContentItem)this.contents.get(index + 1)).focusLeftEndFromPrev()) {
            this.focusRight((FrameContentItem)this.contents.get(index + 1));
        }
    }

    protected void focusPrevTarget() {
        FrameCursor cursorBefore = this.getCursorBefore();
        if (cursorBefore != null) {
            cursorBefore.requestFocus();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart(FrameContentItem srcRow, HeaderItem src) {
        if (this.contents.size() > 0 && (src == this.contents.get(0) || srcRow == this.contents.get(0)) && this.isAlmostBlank()) {
            FrameCanvas parentCanvas = this.getParentCanvas();
            FrameCursor cursorBefore = this.getCursorBefore();
            parentCanvas.removeBlock(this);
            cursorBefore.requestFocus();
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean deleteAtEnd(FrameContentItem srcRow, HeaderItem src) {
        return false;
    }

    public void pullUpContents() {
        this.editor.modifiedFrame(this, false);
        this.getCursorBefore().insertFramesAfter(Utility.concat(this.getCanvases().map(canvas -> {
            ArrayList<Frame> contents = new ArrayList<Frame>((Collection<Frame>)canvas.getBlockContents());
            contents.forEach(c -> canvas.removeBlock((Frame)c));
            return contents;
        }).filter(list -> !list.isEmpty()).collect(Utility.intersperse(() -> Arrays.asList(new BlankFrame(this.editor)))).toArray(new List[0])));
    }

    public final Stream<Frame> getAllFrames() {
        return Stream.concat(Stream.of(this), this.getCanvases().flatMap(c -> c.getBlocksSubtype(Frame.class).stream()).flatMap(Frame::getAllFrames));
    }

    @OnThread(value=Tag.FXPlatform)
    public void markFresh() {
        this.fresh.set(true);
    }

    @OnThread(value=Tag.FXPlatform)
    public void markNonFresh() {
        if (!this.isShowingSuggestions()) {
            this.fresh.set(false);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    protected boolean isShowingSuggestions() {
        return this.getEditableSlots().anyMatch(s -> s instanceof StructuredSlot && ((StructuredSlot)s).isShowingSuggestions());
    }

    public boolean isFresh() {
        return this.fresh.get();
    }

    public void onNonFresh(FXRunnable action) {
        if (!this.isFresh()) {
            throw new IllegalStateException("Calling onNonFresh when we are already non-fresh; state cannot go back to fresh");
        }
        JavaFXUtil.addSelfRemovingListener(this.fresh, b -> action.run());
    }

    public ObservableBooleanValue freshProperty() {
        return this.fresh;
    }

    public List<String> getDeclaredVariablesAfter() {
        return Collections.emptyList();
    }

    public List<String> getDeclaredVariablesWithin(FrameCanvas c) {
        return Collections.emptyList();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setView(View oldView, View newView, SharedTransition animation) {
        this.setViewNoOverride(oldView, newView, animation);
    }

    protected final void setViewNoOverride(View oldView, View newView, SharedTransition animation) {
        Background start = this.frameContents.getBackground();
        Border startBorder = this.frameContents.getBorder();
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == View.JAVA_PREVIEW, new Node[]{this.frameContents});
        this.frameContents.applyCss();
        Background end = this.frameContents.getBackground();
        Border endBorder = this.frameContents.getBorder();
        boolean animatingBackground = false;
        if (start != null && end != null && start.getImages().isEmpty() && end.getImages().isEmpty() && start.getFills().size() == 1 && end.getFills().size() == 1) {
            BackgroundFill startFill = (BackgroundFill)start.getFills().get(0);
            BackgroundFill endFill = (BackgroundFill)end.getFills().get(0);
            if (startFill.getFill() instanceof Color && endFill.getFill() instanceof Color && !startFill.getFill().equals(endFill.getFill())) {
                Color startColor = (Color)startFill.getFill();
                Color endColor = (Color)endFill.getFill();
                animatingBackground = true;
                JavaFXUtil.addChangeListener(animation.getProgress(), t -> {
                    Color c = startColor.interpolate(endColor, t.doubleValue());
                    this.frameContents.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)c, endFill.getRadii(), endFill.getInsets())}));
                });
            }
        }
        boolean animatingBorder = false;
        if (startBorder != null && endBorder != null && startBorder.getImages().isEmpty() && endBorder.getImages().isEmpty() && startBorder.getStrokes().size() == 1 && endBorder.getStrokes().size() == 1) {
            BorderStroke startStroke = (BorderStroke)startBorder.getStrokes().get(0);
            BorderStroke endStroke = (BorderStroke)endBorder.getStrokes().get(0);
            if (startStroke.isStrokeUniform() && endStroke.isStrokeUniform()) {
                Paint startStrokePaint = startStroke.getTopStroke();
                Paint endStrokePaint = endStroke.getTopStroke();
                if (startStrokePaint instanceof Color && endStrokePaint instanceof Color && !startStrokePaint.equals(endStrokePaint)) {
                    Color startColor = (Color)startStrokePaint;
                    Color endColor = (Color)endStrokePaint;
                    animatingBorder = true;
                    JavaFXUtil.addChangeListener(animation.getProgress(), t -> {
                        Color c = startColor.interpolate(endColor, t.doubleValue());
                        this.frameContents.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)c, startStroke.getTopStyle(), startStroke.getRadii(), startStroke.getWidths())}));
                    });
                }
            }
        }
        if (animatingBackground || animatingBorder) {
            animation.addOnStopped(() -> this.frameContents.applyCss());
        }
        if (!this.isFrameEnabled()) {
            if (newView == View.JAVA_PREVIEW) {
                this.frameContents.opacityProperty().bind((ObservableValue)animation.getOppositeProgress());
                animation.addOnStopped(() -> {
                    this.frameContents.opacityProperty().unbind();
                    this.frameContents.setVisible(false);
                });
            } else {
                this.frameContents.setVisible(true);
                this.frameContents.opacityProperty().bind((ObservableValue)animation.getProgress());
                animation.addOnStopped(() -> this.frameContents.opacityProperty().unbind());
            }
        }
        this.contents.forEach(i -> i.setView(oldView, newView, animation));
    }

    public Stream<CodeError> getCurrentErrors() {
        return this.shownError.get() == null ? Stream.empty() : Stream.of((CodeError)this.shownError.get());
    }

    @OnThread(value=Tag.FXPlatform)
    public void addError(CodeError err) {
        this.allFrameErrors.add((Object)err);
        err.bindFresh((ObservableBooleanValue)this.fresh, this.editor);
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
        this.getCursorBefore().requestFocus();
    }

    @Override
    public Node getRelevantNodeForError(CodeError err) {
        if (this.getCursorBefore() == null) {
            return null;
        }
        return this.getCursorBefore().getNode();
    }

    @OnThread(value=Tag.FXPlatform)
    public void compiled() {
    }

    public EditableSlot getErrorShowRedirect() {
        return this.getEditableSlotsDirect().findFirst().orElse(null);
    }

    public boolean isAlmostBlank() {
        return this.getEditableSlotsDirect().allMatch(EditableSlot::isAlmostBlank) && this.getCanvases().allMatch(FrameCanvas::isAlmostBlank);
    }

    public void trackBlank() {
        this.alwaysBeenBlank = this.alwaysBeenBlank && this.isAlmostBlank();
    }

    @OnThread(value=Tag.FXPlatform)
    public void escape(FrameContentItem srcRow, HeaderItem src) {
        if (this.alwaysBeenBlank && this.isFresh()) {
            FrameCanvas parentCanvas = this.getParentCanvas();
            FrameCursor cursorBefore = this.getCursorBefore();
            this.editor.recordEdits(StrideEditReason.FLUSH);
            parentCanvas.removeBlock(this);
            this.editor.recordEdits(StrideEditReason.ESCAPE_FRESH);
            cursorBefore.requestFocus();
        }
    }

    protected Pane getSidebarContainer() {
        return this.frameContents;
    }

    @Override
    public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
        List canvases = this.getCanvases().filter(canvas -> canvas.getShowingProperty().get()).collect(Collectors.toList());
        FrameCanvas lastCanvas = (FrameCanvas)canvases.get(canvases.size() - 1);
        double sceneMaxY = lastCanvas.getSceneBounds().getMaxY();
        Bounds headerRowBounds = this.getHeaderRow().getSceneBounds();
        if (prevCursor != null && sceneY <= (headerRowBounds.getMinY() + headerRowBounds.getMaxY()) / 2.0) {
            return prevCursor;
        }
        for (int canvasIndex = 0; canvasIndex < canvases.size(); ++canvasIndex) {
            Bounds canvasBounds = ((FrameCanvas)canvases.get(canvasIndex)).getContentSceneBounds();
            double nextY = canvasIndex == canvases.size() - 1 ? sceneMaxY : ((FrameCanvas)canvases.get(canvasIndex + 1)).getSceneBounds().getMinY();
            if (!(sceneY <= (canvasBounds.getMaxY() + nextY) / 2.0)) continue;
            boolean isClickOnMargin = sceneX >= headerRowBounds.getMinX() && sceneX < canvasBounds.getMinX() && !isDrag;
            FrameCursor cursor = ((FrameCanvas)canvases.get(canvasIndex)).findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend && !isClickOnMargin);
            if (cursor == null) continue;
            return cursor;
        }
        if (nextCursor != null) {
            return nextCursor;
        }
        if (prevCursor != null) {
            return prevCursor;
        }
        return lastCanvas.findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend);
    }

    @Override
    public final String getXPathForElementAt(double sceneX, double sceneY, LocatableElement.LocationMap locationMap, boolean includePseudoElements, boolean includeSubstringIndex) {
        if (JavaFXUtil.containsScenePoint((Node)this.frameContents, sceneX, sceneY)) {
            String frameXPath = this instanceof CodeFrame ? locationMap.locationFor((CodeElement)((CodeFrame)((Object)this)).getCode()) : "";
            int canvasesBefore = 0;
            for (FrameContentItem content : this.contents) {
                String childXPath = content.getXPathForElementAt(sceneX, sceneY, locationMap, frameXPath, canvasesBefore, includePseudoElements, includeSubstringIndex);
                if (childXPath != null) {
                    return childXPath;
                }
                if (!content.getCanvas().isPresent()) continue;
                ++canvasesBefore;
            }
            return frameXPath.isEmpty() ? null : frameXPath;
        }
        return null;
    }

    public double lowestCursorY() {
        FrameCanvas lastCanvas = Utility.findLast(this.getCanvases()).orElse(null);
        return lastCanvas.getSceneBounds().getMaxY();
    }

    public boolean tryRestoreTo(CodeElement codeElement) {
        return false;
    }

    public boolean isEffectiveFrame() {
        return true;
    }

    public void setModifier(String name, boolean value) {
        if (this.modifiers.containsKey(name)) {
            this.modifiers.get(name).set(value);
        } else {
            Debug.reportError("No such modifier: " + name + " in Frame: " + this);
        }
    }

    public BooleanProperty getModifier(String name) {
        return this.modifiers.get(name);
    }

    protected static Node getHeaderNodeOf(Frame f) {
        return f.header.getNode();
    }

    public int calculateEffort() {
        int effort = 1;
        effort += this.getEditableSlotsDirect().mapToInt(EditableSlot::calculateEffort).sum();
        return effort += this.getAllFrames().filter(f -> f != this).mapToInt(Frame::calculateEffort).sum();
    }

    @OnThread(value=Tag.FXPlatform)
    public void fontSizeChanged() {
        this.header.fontSizeChanged();
    }

    public static enum FramePreviewEnabled {
        PREVIEW_NONE,
        PREVIEW_ENABLED,
        PREVIEW_DISABLED;

    }

    public static enum ShowReason {
        EXCEPTION,
        LINK_TARGET;

    }

    public static enum View {
        NORMAL("normal"),
        JAVA_PREVIEW("java_preview"),
        BIRDSEYE_NODOC("birdseye_nodoc"),
        BIRDSEYE_DOC("birdseye_doc");

        private final String text;

        private View(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public boolean isBirdseye() {
            return this == BIRDSEYE_DOC || this == BIRDSEYE_NODOC;
        }
    }

    public static enum ViewChangeReason {
        MOUSE_CLICKED("mouse_clicked"),
        KEY_PRESSED_ENTER("key_pressed_enter"),
        KEY_PRESSED_ESCAPE("key_pressed_escape"),
        MENU_OR_SHORTCUT("menu_or_shortcut");

        private final String text;

        private ViewChangeReason(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

