/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

public class Sidebar {
    private final Node node;
    private final Label label;
    private final Binding[] bindingsToKeepHoldOf;

    public Sidebar(Label label, Node node, Binding ... bindingsToKeepHoldOf) {
        this.label = label;
        this.node = node;
        this.bindingsToKeepHoldOf = bindingsToKeepHoldOf;
    }

    public Node getNode() {
        return this.node;
    }

    public StringProperty textProperty() {
        return this.label.textProperty();
    }

    public void setText(String value) {
        this.label.setText(value);
    }

    public Node getStyleable() {
        return this.label;
    }

    static Sidebar addSidebar(final InteractionManager editor, final Pane containedPane, final Observable observableBounds, String stylePrefix) {
        final SidebarLabel sidebar = new SidebarLabel();
        Group g = new Group(new Node[]{sidebar});
        g.setManaged(false);
        sidebar.getStyleClass().addAll((Object[])new String[]{"sidelabel", stylePrefix + "sidelabel"});
        sidebar.setOpacity(0.0);
        containedPane.getChildren().add((Object)g);
        if (editor == null || editor.getWindowOverlayPane() == null) {
            sidebar.setVisible(false);
            return new Sidebar(sidebar, (Node)g, new Binding[0]);
        }
        DoubleBinding containedPaneOffset = new DoubleBinding(){
            {
                super.bind(new Observable[]{editor.getObservableScroll()});
                super.bind(new Observable[]{editor.getObservableViewportHeight()});
                super.bind(new Observable[]{observableBounds});
                super.bind(new Observable[]{containedPane.localToSceneTransformProperty()});
            }

            protected double computeValue() {
                return (int)(-editor.getWindowOverlayPane().sceneYToWindowOverlayY(containedPane.localToScene(0.0, 0.0).getY()));
            }
        };
        containedPaneOffset.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number oldVal, Number newVal) {
                if (oldVal.doubleValue() <= 0.0 && newVal.doubleValue() > 0.0 || oldVal.doubleValue() > 0.0 && newVal.doubleValue() <= 0.0) {
                    FadeTransition ft = new FadeTransition(Duration.millis((double)200.0), (Node)sidebar);
                    ft.setToValue(newVal.doubleValue() <= 0.0 ? 0.0 : 1.0);
                    ft.play();
                }
            }
        });
        sidebar.setEllipsisString("\u22ef");
        sidebar.setTextOverrun(OverrunStyle.CENTER_ELLIPSIS);
        DoubleBinding containedPaneOffsetMax = Bindings.max((double)0.0, (ObservableNumberValue)containedPaneOffset);
        final DoubleBinding sidebarOffset = containedPaneOffsetMax.add((ObservableNumberValue)sidebar.topMarginProperty());
        DoubleBinding sidebarMaxWidth = new DoubleBinding(){
            {
                super.bind(new Observable[]{containedPane.heightProperty()});
                super.bind(new Observable[]{sidebarOffset});
                super.bind(new Observable[]{editor.getObservableViewportHeight()});
                super.bind(new Observable[]{sidebar.topMarginProperty()});
            }

            protected double computeValue() {
                return Math.min(containedPane.getHeight() - sidebarOffset.get(), editor.getObservableViewportHeight().get() - sidebar.topMarginProperty().get()) - 25.0;
            }
        };
        sidebar.maxWidthProperty().bind((ObservableValue)sidebarMaxWidth);
        Rotate r = new Rotate(-90.0, 0.0, 0.0);
        Translate t = new Translate();
        FXConsumer<Object> update = a -> t.setX(-(sidebar.getWidth() + sidebarOffset.get()));
        JavaFXUtil.addChangeListenerAndCallNow(sidebar.widthProperty(), update);
        JavaFXUtil.addChangeListenerAndCallNow(sidebarOffset, update);
        t.yProperty().bind((ObservableValue)sidebar.leftMarginProperty());
        sidebar.getTransforms().addAll((Object[])new Transform[]{r, t});
        sidebar.visibleProperty().bind((ObservableValue)sidebar.maxWidthProperty().greaterThanOrEqualTo(10.0));
        return new Sidebar(sidebar, (Node)g, new Binding[]{containedPaneOffset, containedPaneOffsetMax, sidebarOffset, sidebarMaxWidth});
    }

    private static class SidebarLabel
    extends Label {
        private final SimpleStyleableDoubleProperty leftMarginProperty = new SimpleStyleableDoubleProperty(SIDEBAR_LABEL_LEFT_MARGIN_META_DATA);
        private final SimpleStyleableDoubleProperty topMarginProperty = new SimpleStyleableDoubleProperty(SIDEBAR_LABEL_TOP_MARGIN_META_DATA);
        private static final CssMetaData<SidebarLabel, Number> SIDEBAR_LABEL_LEFT_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-left-margin", SidebarLabel::leftMarginProperty);
        private static final CssMetaData<SidebarLabel, Number> SIDEBAR_LABEL_TOP_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-top-margin", SidebarLabel::topMarginProperty);
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss(Label.getClassCssMetaData()).add(SIDEBAR_LABEL_LEFT_MARGIN_META_DATA).add(SIDEBAR_LABEL_TOP_MARGIN_META_DATA).build();

        private SidebarLabel() {
        }

        private final SimpleStyleableDoubleProperty leftMarginProperty() {
            return this.leftMarginProperty;
        }

        private final SimpleStyleableDoubleProperty topMarginProperty() {
            return this.topMarginProperty;
        }

        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return cssMetaDataList;
        }

        public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
            return SidebarLabel.getClassCssMetaData();
        }
    }
}

