/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.SplashWindow;
import com.sun.glass.ui.Application;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Boot {
    public static final String BLUEJ_VERSION = "5.2.1";
    public static final String GREENFOOT_VERSION = "3.8.0";
    public static final String GREENFOOT_API_VERSION = "3.0.0";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 5.2.1";
    private static final String[] bluejUserJars = new String[]{"bluejcore.jar", "javafx-*.jar", "junit-*.jar", "hamcrest-*.jar", "opentest4j-*.jar", "lang-stride.jar"};
    private static final String JLAYER_MP3_JAR = "jl1.0.1.jar";
    public static final String[] GREENFOOT_EXPORT_JARS = new String[]{"jl1.0.1.jar", "lang-stride.jar"};
    private static final String[] greenfootUserJars = new String[]{"greenfoot.jar", "bluejcore.jar", "javafx-*.jar", "junit-*.jar", "hamcrest-*.jar", "opentest4j-*.jar", "bluej.jar", "classgraph-*.jar", "diffutils-*.jar", "commons-logging*.jar", "jl1.0.1.jar", "opencsv-*.jar", "xom-*.jar", "lang-stride.jar", "nsmenufx-*.jar", "wellbehavedfx-*.jar", "guava-*.jar", "http*.jar"};
    private static final int greenfootUserBuildJars = 4;
    private static Boot instance;
    private static final String[] bluejJars;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static String[] javafxJars;
    private static boolean isGreenfoot;
    private static File bluejLibDir;
    private static final ArrayList<File> macInitialProjects;
    private static Consumer<List<File>> openProjectHandler;
    private @OnThread(value=Tag.FXPlatform) SplashWindow splashWindow;
    public static String[] cmdLineArgs;
    private final Properties commandLineProps;
    private File javaHomeDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;
    private Runnable quitAction;

    private Boot(Properties props, FXPlatformSupplier<Image> image) {
        CompletableFuture shown = new CompletableFuture();
        Platform.runLater(() -> {
            this.splashWindow = new SplashWindow((Image)image.get());
            shown.complete(true);
        });
        try {
            shown.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        this.commandLineProps = props;
    }

    public static void main(String[] args) {
        cmdLineArgs = args;
        javafx.application.Application.launch(App.class, (String[])args);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void setFileOpenHandler(Consumer<List<File>> openProjectHandler) {
        Boot.openProjectHandler = openProjectHandler;
        if (!macInitialProjects.isEmpty()) {
            openProjectHandler.accept(macInitialProjects);
        }
        macInitialProjects.clear();
    }

    public URL[] getJavaFXClassPath() {
        String javafxJarsProp = this.commandLineProps.getProperty("javafxjars", null);
        if (javafxJarsProp != null) {
            return (URL[])Arrays.stream(javafxJarsProp.split(":")).map(s -> {
                try {
                    return new File((String)s).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
        }
        File javafxLibPath = this.getJavaFXLibDir();
        URL[] urls = new URL[javafxJars.length];
        for (int i = 0; i < javafxJars.length; ++i) {
            try {
                urls[i] = new File(javafxLibPath, javafxJars[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    public File getJavaFXLibDir() {
        String javafxPathProp = this.commandLineProps.getProperty("javafxpath", null);
        if (javafxPathProp != null) {
            return new File(new File(javafxPathProp), "lib");
        }
        return new File(Boot.getBluejLibDir(), "javafx");
    }

    public File getJavaFXSourcePath() {
        File javafxLibPath = this.getJavaFXLibDir();
        File javafxSrcPath = new File(javafxLibPath, "src.zip");
        return javafxSrcPath;
    }

    @OnThread(value=Tag.Any)
    public static void subMain() {
        Properties commandLineProps = Boot.processCommandLineProperties(cmdLineArgs);
        isGreenfoot = commandLineProps.getProperty("greenfoot", "false").equals("true");
        FXPlatformSupplier<Image> image = new FXPlatformSupplier<Image>(){

            @Override
            @OnThread(value=Tag.FXPlatform)
            public Image get() {
                URL url = Boot.class.getResource(isGreenfoot ? "gen-greenfoot-splash.png" : "gen-bluej-splash.png");
                if (url != null) {
                    return new Image(url.toString());
                }
                WritableImage writableImage = new WritableImage(500, 300);
                int y = 0;
                while ((double)y < writableImage.getHeight()) {
                    int x = 0;
                    while ((double)x < writableImage.getWidth()) {
                        writableImage.getPixelWriter().setColor(x, y, Color.WHITE);
                        ++x;
                    }
                    ++y;
                }
                return writableImage;
            }
        };
        if (isGreenfoot) {
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
        }
        try {
            instance = new Boot(commandLineProps, image);
            instance.bootBluej();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        Boot boot = instance;
        synchronized (boot) {
            while (true) {
                try {
                    while (true) {
                        instance.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Boot getInstance() {
        return instance;
    }

    public static File getBluejLibDir() {
        if (bluejLibDir == null) {
            bluejLibDir = Boot.calculateBluejLibDir();
        }
        return bluejLibDir;
    }

    private static File calculateBluejLibDir() {
        File bluejDir = null;
        URL defsLocation = Boot.class.getResource("/lib/bluej.defs");
        if (defsLocation != null) {
            try {
                return new File(defsLocation.toURI()).getParentFile();
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String bootFullName = Boot.class.getResource("Boot.class").toString();
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir;
                for (startingDir = new File(new URI(bootFullName)).getParentFile(); startingDir != null && !new File(startingDir.getParentFile(), "lib").isDirectory(); startingDir = startingDir.getParentFile()) {
                }
                bluejDir = startingDir == null ? null : new File(startingDir.getParentFile(), "lib");
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                bluejDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bluejDir;
    }

    public static URL getJREJar(String name) throws MalformedURLException {
        String jrePathName = System.getProperty("java.home");
        if (jrePathName != null) {
            File jrePath = new File(jrePathName);
            if (jrePath.canRead()) {
                File jarPath = new File(jrePath, "lib/" + name);
                if (jarPath.canRead()) {
                    return jarPath.toURI().toURL();
                }
                System.err.println("Could not find " + name + " at: " + jarPath.getAbsolutePath());
            } else {
                System.err.println("Could not find JRE at: " + jrePath.getAbsolutePath());
            }
        } else {
            System.err.println("Could not find Java path");
        }
        return null;
    }

    private static Properties processCommandLineProperties(String[] args) {
        Properties props = new Properties();
        for (String arg : args) {
            String definition;
            int definitionEquals;
            if (!arg.startsWith("-") || (definitionEquals = (definition = arg.substring(1)).indexOf(61)) < 0) continue;
            String propName = definition.substring(0, definitionEquals);
            String propValue = definition.substring(definitionEquals + 1);
            if (propName.equals("") || propValue.equals("")) continue;
            props.put(propName, propValue);
        }
        return props;
    }

    public static boolean isTrialRecording() {
        return false;
    }

    public void disposeSplashWindow() {
        Platform.runLater(() -> {
            if (this.splashWindow != null) {
                this.splashWindow.hide();
                this.splashWindow = null;
            }
        });
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    @OnThread(value=Tag.Any)
    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader runtimeLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> mainClass = Class.forName("bluej.Main", true, runtimeLoader);
            mainClass.getDeclaredConstructor(ClassLoader.class).newInstance(runtimeLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        try {
            this.runtimeClassPath = this.getKnownJars(Boot.getBluejLibDir(), runtimeJars, false);
            this.runtimeUserClassPath = this.getKnownJars(Boot.getBluejLibDir(), userJars, true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private URL[] getKnownJars(File libDir, String[] jars, boolean isForUserVM) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (int i = 0; i < jars.length; ++i) {
            File[] filesToAdd;
            if (jars[i].startsWith("^")) {
                dir = new File(libDir.getPath());
                String excludeJAR = jars[i].substring(1);
                filesToAdd = dir.listFiles(f -> f.getName().endsWith(".jar") && !f.getName().equals(excludeJAR));
            } else if (jars[i].contains("*")) {
                dir = new File(libDir.getPath());
                String[] beforeAfter = jars[i].split("\\*");
                FileFilter fileFilter = f -> f.getName().startsWith(beforeAfter[0]) && f.getName().endsWith(beforeAfter[1]);
                filesToAdd = dir.listFiles(fileFilter);
            } else {
                filesToAdd = new File[]{new File(libDir, jars[i])};
            }
            for (File toAdd : filesToAdd) {
                if (!toAdd.canRead()) continue;
                urlList.add(toAdd.toURI().toURL());
            }
        }
        if (isForUserVM) {
            urlList.addAll(Arrays.asList(this.getJavaFXClassPath()));
        }
        return urlList.toArray(new URL[0]);
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    public void setQuitHandler(Runnable quitAction) {
        this.quitAction = quitAction;
    }

    static {
        bluejJars = new String[]{"^bluejcore.jar"};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        javafxJars = new String[]{"javafx.base.jar", "javafx.controls.jar", "javafx.fxml.jar", "javafx.graphics.jar", "javafx.media.jar", "javafx.properties.jar", "javafx.swing.jar", "javafx.web.jar"};
        isGreenfoot = false;
        macInitialProjects = new ArrayList();
        openProjectHandler = null;
    }

    @FunctionalInterface
    private static interface FXPlatformSupplier<T> {
        @OnThread(value=Tag.FXPlatform)
        public T get();
    }

    public static class App
    extends javafx.application.Application {
        public App() {
            if (System.getProperty("os.name").contains("OS X")) {
                Application glassApp = Application.GetApplication();
                glassApp.setEventHandler(new Application.EventHandler(){

                    public void handleOpenFilesAction(Application app, long time, String[] files) {
                        for (String f : files) {
                            if (f.contains(":") || f.equals("bluej.Boot") || f.startsWith("-")) continue;
                            macInitialProjects.add(new File(f));
                        }
                        if (openProjectHandler != null) {
                            openProjectHandler.accept(macInitialProjects);
                            macInitialProjects.clear();
                        }
                        super.handleOpenFilesAction(app, time, files);
                    }

                    public void handleQuitAction(Application app, long time) {
                        Boot.getInstance().quitAction.run();
                        super.handleQuitAction(app, time);
                    }
                });
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public void start(Stage s) throws Exception {
            Platform.setImplicitExit((boolean)false);
            s.setTitle("BlueJ");
            new Thread(() -> Boot.subMain(), "subMain thread").start();
        }
    }
}

