/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.Submitter;
import org.bluej.utility.FXCustomizedDialog;
import org.bluej.utility.Utility;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ResultDialog
extends FXCustomizedDialog {
    private Stat stat;
    private WebView resultArea;

    public ResultDialog(Stat i_stat, Window parentWindow) {
        super(parentWindow, i_stat.bluej.getLabel("title.results"), "");
        this.initModality(Modality.NONE);
        this.stat = i_stat;
        this.buildUI();
    }

    private void buildUI() {
        this.resultArea = new WebView();
        Utility.applyStyle((Node)this.resultArea, "results-dlg");
        this.resultArea.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    EventListener listener = new EventListener(){

                        @Override
                        @OnThread(value=Tag.Worker, ignoreParent=true)
                        public void handleEvent(Event evt) {
                            EventTarget target = evt.getCurrentTarget();
                            HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                            String href = anchorElement.getHref();
                            URL url = null;
                            try {
                                url = new URL(href);
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                                Platform.runLater(() -> ResultDialog.this.stat.submitDialog.statusWriteln("Malformed URL \"" + href + "\""));
                                return;
                            }
                            boolean canOpenWebBrowser = Utility.openWebBrowser(ResultDialog.this.stat.bluej, url);
                            if (canOpenWebBrowser) {
                                evt.preventDefault();
                            } else {
                                Platform.runLater(() -> ResultDialog.this.stat.submitDialog.statusWriteln("Can't open external browser"));
                            }
                        }
                    };
                    Document doc = ResultDialog.this.resultArea.getEngine().getDocument();
                    NodeList links = doc.getElementsByTagName("a");
                    for (int i = 0; i < links.getLength(); ++i) {
                        ((EventTarget)((Object)links.item(i))).addEventListener("click", listener, false);
                    }
                }
            }
        });
        ScrollPane scrollPane = new ScrollPane((Node)this.resultArea);
        scrollPane.getStylesheets().add((Object)Submitter.getCSSStyleFilePath());
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        this.getDialogPane().setContent((Node)scrollPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
    }

    void showResult(String result) {
        if (result == null) {
            return;
        }
        this.resultArea.getEngine().loadContent(result);
        if (result.length() > 0) {
            this.show();
        }
    }
}

