/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bluej.extensions.submitter.Stat;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any, ignoreParent=true)
public class SchemeEntry {
    private static final List<String> configItems = Arrays.asList(".transport", ".file.include", ".file.exclude", ".file.essential", ".file.jar", ".insert");
    private Stat stat;
    private List<String>[] configuration;
    private String title;
    private boolean isHidden = false;

    public SchemeEntry(Stat i_stat, String i_title) {
        this.stat = i_stat;
        this.title = i_title;
        this.configuration = new List[configItems.size()];
        int n = this.configuration.length;
        for (int i = 0; i < n; ++i) {
            this.configuration[i] = new ArrayList<String>();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getSimpleTitle() {
        if (this.title != null && this.title.contains("/")) {
            return this.title.substring(this.title.lastIndexOf(47) + 1);
        }
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    void addConfig(String key, String value, boolean forceTransport) {
        this.stat.aDbg.debug(4, "Node.addConfig: Node.title=" + this.title + " key=" + key + " value=" + value);
        int keyIndex = configItems.indexOf(key);
        if (keyIndex == -1) {
            throw new IllegalArgumentException("Unknown configuration item: " + key);
        }
        List<String> conf = this.configuration[keyIndex];
        if (conf.size() > 0 && key.equals(".transport")) {
            if (!forceTransport) {
                throw new IllegalArgumentException(key + " already set in this node");
            }
            conf.clear();
        }
        if (key.startsWith(".file.")) {
            int start;
            int end = value.length();
            int index = conf.size();
            do {
                start = value.lastIndexOf(44, end - 1);
                conf.add(index, value.substring(start + 1, end).trim());
                end = start;
            } while (start > 0);
            return;
        }
        if (key.startsWith(".insert")) {
            this.stat.aDbg.debug(4, "Node.addConfig: .insert Node.title=" + this.title + " key=" + key + " value=" + value);
            this.stat.schemeData.loadUrl(value);
            return;
        }
        conf.add(value);
    }

    public Collection<String> getConfig(String key) {
        int keyIndex = configItems.indexOf(key);
        if (keyIndex == -1) {
            throw new IllegalArgumentException("Unknown configuration item: " + key);
        }
        return this.configuration[keyIndex];
    }

    public void copyConfigurationsTo(SchemeEntry destEntry) {
        if (this.configuration[configItems.indexOf(".transport")].size() == 1 && destEntry.getConfig(".transport").size() == 1) {
            throw new IllegalArgumentException("Can not copy .transport configuration: already set in destination node");
        }
        for (String key : configItems) {
            Collection<String> srcConfValues = this.getConfig(key);
            for (String srcConfValue : srcConfValues) {
                destEntry.addConfig(key, srcConfValue, false);
            }
        }
    }

    boolean isValidKey(String key) {
        return configItems.indexOf(key) != -1;
    }

    public String insfoString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Node: " + this.title + "\n");
        for (int i = 0; i < this.configuration.length; ++i) {
            List<String> conf = this.configuration[i];
            if (conf.isEmpty()) continue;
            for (String it : conf) {
                buf.append(' ');
                buf.append(configItems.get(i) + "=");
                buf.append(it + "\n");
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.title;
    }

    public Object getUserObject() {
        return this.title;
    }

    public void setIsHidden() {
        this.isHidden = true;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }
}

