/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javax.activation.DataHandler;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.UserPasswordDialog;
import org.bluej.extensions.submitter.transport.TransportSession;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SmtpSession
extends TransportSession {
    private Message msg;
    private Multipart multipart;
    private Session session;
    private String smtpTransport;
    private static final String DEBUGLOG_FILENAME = "javamail-debuglog.txt";
    private File userConfigDir;

    public SmtpSession(URL url, Properties environment, Stat stat) throws UnsupportedEncodingException {
        super(url, environment, stat);
        CompletableFuture futureUserConfigFile = new CompletableFuture();
        Platform.runLater(() -> futureUserConfigFile.complete(stat.bluej.getUserConfigDir()));
        try {
            this.userConfigDir = (File)futureUserConfigFile.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.result = "Submission not sent. Check debug log.";
    }

    @Override
    public void connect() {
        this.createSession();
        this.msg = new MimeMessage(this.session);
        this.multipart = new MimeMultipart();
        String subject = this.urlProps.getProperty("subject");
        if (subject == null) {
            subject = "BlueJ Submission";
        } else {
            try {
                subject = URLDecoder.decode(subject, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        String body = this.urlProps.getProperty("body");
        if (body != null) {
            try {
                body = URLDecoder.decode(body, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        String sendAddress = this.url.getPath();
        try {
            this.msg.setFrom(new InternetAddress(this.urlProps.getProperty("useraddr")));
            this.msg.setRecipient(Message.RecipientType.TO, new InternetAddress(sendAddress));
            this.msg.setSubject(subject);
            this.msg.setSentDate(new Date());
            if (body != null) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setText(body);
                this.multipart.addBodyPart(mbp);
            }
        }
        catch (MessagingException ex) {
            this.reportEvent(ex.getMessage());
            ex.printStackTrace();
        }
        this.reportEvent("Message for " + sendAddress + " created ok.");
    }

    private void createSession() {
        String smtpHost;
        String debug = "false";
        File javaMailDebugLog = new File(this.userConfigDir, DEBUGLOG_FILENAME);
        if (javaMailDebugLog.exists()) {
            debug = "true";
        }
        if ((smtpHost = this.urlProps.getProperty("smtphost")) == null || smtpHost.length() == 0) {
            throw new IllegalArgumentException("SMTP Host has not been set");
        }
        String userAddress = this.urlProps.getProperty("useraddr");
        if (userAddress == null || userAddress.indexOf(64) < 1 || userAddress.indexOf(64) == userAddress.length() - 1) {
            throw new IllegalArgumentException("User Email address invalid");
        }
        this.smtpTransport = this.urlProps.getProperty("ssl", "smtp");
        this.smtpTransport = this.smtpTransport.equalsIgnoreCase("true") ? "smtps" : "smtp";
        String authentication = this.urlProps.getProperty("authenticate", "false");
        String enableTLS = this.urlProps.getProperty("tls", "false");
        String portNumber = this.urlProps.getProperty("port", "25");
        CompletableFuture saslRealmFuture = new CompletableFuture();
        Platform.runLater(() -> saslRealmFuture.complete(this.stat.bluej.getExtensionPropertyString("saslrealm", "")));
        this.urlProps.put("mail.smtp.starttls.enable", enableTLS);
        if (enableTLS.equalsIgnoreCase("true") || this.smtpTransport.equalsIgnoreCase("true")) {
            this.urlProps.put("mail.smtp.ssl.trust", smtpHost);
        }
        this.urlProps.put("mail.transport.protocol", this.smtpTransport);
        this.urlProps.put("mail.smtp.auth", authentication);
        this.urlProps.put("mail.smtps.auth", authentication);
        this.urlProps.put("mail.smtp.port", portNumber);
        this.urlProps.put("mail.host", smtpHost);
        this.urlProps.put("mail.user", userAddress);
        this.urlProps.put("mail.debug", debug);
        try {
            this.urlProps.put("mail.smtp.sasl.realm", saslRealmFuture.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.session = authentication.equals("true") ? Session.getInstance(this.urlProps, new MailUserAuthenticator()) : Session.getInstance(this.urlProps, null);
        if (debug.equals("true")) {
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(javaMailDebugLog));
                this.session.setDebugOut(ps);
                this.reportEvent("JavaMail's debug log will be written to " + javaMailDebugLog);
                ps.println("The JavaMail session was created with the following properties: ");
                this.session.getProperties().list(ps);
                ps.println("\n");
            }
            catch (FileNotFoundException ee) {
                this.reportEvent(ee.getMessage());
                ee.printStackTrace();
            }
        }
        this.reportEvent("Attempting connection to host " + smtpHost + " on port " + portNumber);
    }

    @Override
    public void send(InputStream is, String fileName, boolean binary) {
        String packageName = fileName.replace('/', '_');
        String mimeType = "text/plain";
        String reportText = "===> Added text file  " + packageName + " to message.";
        if (binary) {
            mimeType = "application/octet-stream";
            reportText = "===> Added binary file " + packageName + " to message.";
        }
        try {
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setFileName(packageName);
            DataHandler dh = new DataHandler(new ByteArrayDataSource(is, mimeType));
            mbp.setDataHandler(dh);
            this.multipart.addBodyPart(mbp);
            this.reportLog(reportText);
        }
        catch (Exception ex) {
            this.reportEvent(ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void disconnect() {
        try {
            SMTPTransport transport = (SMTPTransport)this.session.getTransport(this.smtpTransport);
            transport.connect();
            this.msg.setContent(this.multipart);
            transport.sendMessage(this.msg, this.msg.getAllRecipients());
            transport.close();
            this.reportEvent("Disconnecting. All seems ok.");
            this.result = null;
        }
        catch (MessagingException mex) {
            this.reportEvent(mex.getMessage());
            mex.printStackTrace();
            this.reportEvent("Message could not be sent.");
        }
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    private class MailUserAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            CompletableFuture pwdAuthFuture = new CompletableFuture();
            Platform.runLater(() -> pwdAuthFuture.complete(this.doGetPasswordAuthentication()));
            try {
                return (PasswordAuthentication)pwdAuthFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        private @OnThread(value=Tag.FXPlatform, ignoreParent=true) PasswordAuthentication doGetPasswordAuthentication() {
            String title = SmtpSession.this.stat.bluej.getLabel("authentication.dialog.title") + " ";
            String mainPrompt = SmtpSession.this.stat.bluej.getLabel("authentication.dialog.label");
            String usernamePrompt = SmtpSession.this.stat.bluej.getLabel("authentication.dialog.label.username");
            String passwordPrompt = SmtpSession.this.stat.bluej.getLabel("authentication.dialog.label.password");
            VBox box = new VBox();
            String s = SmtpSession.this.stat.bluej.getExtensionPropertyString("smtpauthuser", System.getProperty("user.name", ""));
            TextField username = new TextField(s);
            username.setPrefColumnCount(20);
            PasswordField password = new PasswordField();
            password.setPrefColumnCount(20);
            box.getChildren().add((Object)new Label(mainPrompt + " " + this.getRequestingSite()));
            box.getChildren().add((Object)new Label(usernamePrompt));
            box.getChildren().add((Object)username);
            box.getChildren().add((Object)new Label(passwordPrompt));
            box.getChildren().add((Object)password);
            String dialogTitle = title + this.getRequestingProtocol();
            UserPasswordDialog dlg = new UserPasswordDialog(SmtpSession.this.stat, dialogTitle, (Node)box);
            Optional result = dlg.showAndWait();
            if (((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                return new PasswordAuthentication(username.getText(), String.copyValueOf(password.getText().toCharArray()));
            }
            return null;
        }
    }
}

