/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ModelContainer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.DataAccessException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectTypeMismatchException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.IRepository;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.SerializationRepository;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PersistenceAwareModelManager
implements IModelManager {
    private final LinkedHashMap<ModelType, ModelContainer> mModelMap;
    private final IRepository<String, ModelContainer> mRepository;
    private final ILogger mLogger;
    private ModelType mLastAdded;

    public PersistenceAwareModelManager(File repositoryRoot, ILogger logger) {
        assert (logger != null);
        this.mModelMap = new LinkedHashMap();
        this.mLogger = logger;
        this.mLogger.info((Object)("Repository-Root is: " + repositoryRoot.getAbsolutePath()));
        this.mRepository = new SerializationRepository(repositoryRoot, this.mLogger);
    }

    public PersistenceAwareModelManager(String tmpDir, ILogger logger) {
        this(new File(tmpDir), logger);
    }

    private static String createFileNameFromNode(IElement node) {
        if (node == null) {
            return "";
        }
        String graphName = "";
        ILocation loc = ILocation.getAnnotation((IElement)node);
        if (loc != null && loc.getFileName() != null) {
            graphName = loc.getFileName();
        }
        if (graphName.contains(", ")) {
            String[] names = graphName.split(", ");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(s.substring(s.lastIndexOf(File.separator) + 1)).append(", ");
                ++n2;
            }
            graphName = sb.delete(sb.length() - 2, sb.length()).toString();
        } else {
            graphName = graphName.trim();
            graphName = graphName.substring(graphName.lastIndexOf(File.separator) + 1);
        }
        return graphName;
    }

    private boolean addItem(ModelContainer container) {
        ModelType type = container.getType();
        if (this.mModelMap.containsKey(type)) {
            this.mLogger.warn((Object)"Model is already present, skipping insertion....");
            return false;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Inserting " + container));
        }
        this.mModelMap.put(type, container);
        this.mLastAdded = type;
        return true;
    }

    @Override
    public boolean addItem(IElement rootNode, ModelType graphtype) {
        return this.addItem(new ModelContainer(rootNode, graphtype, PersistenceAwareModelManager.createFileNameFromNode(rootNode)));
    }

    @Override
    public List<String> getItemNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ModelType t : this.mModelMap.keySet()) {
            names.add(t.toString());
        }
        names.addAll(this.mRepository.listKeys());
        return names;
    }

    @Override
    public ModelType getLastAdded() {
        return this.mLastAdded;
    }

    @Override
    public IElement getRootNode(ModelType graph) throws GraphNotFoundException {
        ModelContainer container = this.mModelMap.get(graph);
        if (container == null) {
            try {
                container = this.mRepository.get(graph.toString());
                this.mModelMap.put(graph, container);
            }
            catch (PersistentObjectNotFoundException e) {
                throw new GraphNotFoundException(graph, e);
            }
            catch (PersistentObjectTypeMismatchException e) {
                this.mLogger.error((Object)("Could not deserialize graph " + graph), (Throwable)e);
                throw new GraphNotFoundException(graph, e);
            }
        }
        return container.getRoot();
    }

    @Override
    public boolean isEmpty() {
        return this.mModelMap.isEmpty() && this.mRepository.isEmpty();
    }

    @Override
    public void persistAll(boolean keepInMemory) throws StoreObjectException {
        for (Map.Entry<ModelType, ModelContainer> mapEntry : this.mModelMap.entrySet()) {
            if (mapEntry.getKey() == null || mapEntry.getValue() == null) continue;
            this.mRepository.addOrReplace(mapEntry.getKey().toString(), mapEntry.getValue());
        }
        if (!keepInMemory) {
            this.removeAll();
        }
    }

    @Override
    public void persistAndDropExistingGraph(ModelType key) throws StoreObjectException, GraphNotFoundException {
        this.persistExistingGraph(key, false);
    }

    @Override
    public void persistExistingGraph(ModelType key, boolean keepInMemory) throws StoreObjectException, GraphNotFoundException {
        if (this.mModelMap.containsKey(key)) {
            this.mRepository.addOrReplace(key.toString(), this.mModelMap.get(key));
            if (!keepInMemory) {
                this.mModelMap.remove(key);
            }
        } else {
            throw new GraphNotFoundException(key);
        }
    }

    @Override
    public void removeAll() {
        this.mModelMap.clear();
    }

    @Override
    public boolean removeItem(ModelType graphtype) {
        boolean successfull = true;
        if (this.mModelMap.containsKey(graphtype)) {
            boolean bl = successfull = this.mModelMap.remove(graphtype) != null;
        }
        return successfull && this.mRepository.remove(graphtype.toString());
    }

    @Override
    public boolean removeItem(String id) {
        boolean successfull = true;
        ModelType graphType = this.getInMemoryGraphTypeById(id);
        if (graphType != null) {
            boolean bl = successfull = this.mModelMap.remove(graphType) != null;
        }
        return successfull && this.mRepository.remove(id);
    }

    @Override
    public boolean removeItem(ModelContainer vault) {
        return this.mModelMap.remove(vault.getType()) != null;
    }

    @Override
    public ModelType getGraphTypeById(String s) {
        for (ModelType t : this.mModelMap.keySet()) {
            if (!t.toString().equals(s)) continue;
            return t;
        }
        if (this.mRepository.listKeys().contains(s)) {
            try {
                return this.mRepository.get(s).getType();
            }
            catch (DataAccessException e) {
                this.mLogger.error((Object)"Problems deserializing persistent model: ", (Throwable)e);
            }
        }
        return null;
    }

    private ModelType getInMemoryGraphTypeById(String id) {
        for (ModelType t : this.mModelMap.keySet()) {
            if (!t.toString().equals(id)) continue;
            return t;
        }
        return null;
    }

    @Override
    public ModelType getGraphTypeByGeneratorPluginId(String id) {
        Optional<Map.Entry> creator = this.mModelMap.entrySet().stream().filter(a -> ((ModelType)a.getKey()).getCreator().equals(id)).findFirst();
        if (creator.isPresent()) {
            return (ModelType)creator.get().getKey();
        }
        for (String keyFromRepos : this.mRepository.listKeys()) {
            if (!keyFromRepos.contains(id)) continue;
            try {
                ModelType graphType = this.mRepository.get(keyFromRepos).getType();
                if (!graphType.getCreator().equals(id)) continue;
                return graphType;
            }
            catch (DataAccessException e) {
                this.mLogger.error((Object)"Problems deserializing persistent model: ", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public int size() {
        this.mLogger.debug((Object)("Current MM size is " + this.mModelMap.size() + ". There are " + this.mRepository.listKeys().size() + " models in the repository."));
        return this.mModelMap.size();
    }

    @Override
    public List<ModelType> getItemKeys() {
        return new ArrayList<ModelType>(this.mModelMap.keySet());
    }
}

