/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.CFGWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.DFSTreeWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.IWalker;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class PluginConnector {
    private final ILogger mLogger;
    private final IModelManager mModelManager;
    private final IController<RunDefinition> mController;
    private final ITool mTool;
    private boolean mHasPerformedChanges;
    private final IToolchainStorage mStorage;
    private final IUltimateServiceProvider mServices;

    public PluginConnector(IModelManager modelmanager, ITool tool, IController<RunDefinition> control, IToolchainStorage storage, IUltimateServiceProvider services) {
        assert (storage != null);
        assert (control != null);
        assert (modelmanager != null);
        assert (tool != null);
        assert (services != null);
        this.mModelManager = modelmanager;
        this.mController = control;
        this.mTool = tool;
        this.mStorage = storage;
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.init();
    }

    private void init() {
        this.mHasPerformedChanges = false;
    }

    public void run() throws Throwable {
        this.mLogger.info((Object)("------------------------" + this.mTool.getPluginName() + "----------------------------"));
        this.init();
        PluginConnector.initializePlugin(this.mLogger, (IToolchainPlugin)this.mTool, this.mServices, this.mStorage);
        List<ModelType> models = this.selectModels();
        if (models.isEmpty()) {
            IllegalArgumentException ex = new IllegalArgumentException();
            this.mLogger.error((Object)"Tool did not select a valid model", (Throwable)ex);
            throw ex;
        }
        int max = models.size();
        int idx = 0;
        for (ModelType currentModel : models) {
            this.mTool.setInputDefinition(currentModel);
            List observers = this.mTool.getObservers();
            this.runTool(observers, currentModel, idx, max);
            ++idx;
        }
        this.mTool.finish();
        this.mLogger.info((Object)("------------------------ END " + this.mTool.getPluginName() + "----------------------------"));
    }

    public boolean hasPerformedChanges() {
        return this.mHasPerformedChanges;
    }

    public String toString() {
        return this.mTool.getPluginName();
    }

    private void runTool(List<IObserver> observers, ModelType currentModel, int currentModelIndex, int numberOfModels) throws Throwable {
        IElement entryNode = this.getEntryPoint(currentModel);
        if (this.mTool instanceof IGenerator) {
            IGenerator tool = (IGenerator)this.mTool;
            for (IObserver observer : observers) {
                this.runObserver(observer, currentModel, entryNode, currentModelIndex, numberOfModels);
                this.retrieveModel(tool, observer.toString());
            }
        } else {
            for (IObserver observer : observers) {
                this.runObserver(observer, currentModel, entryNode, currentModelIndex, numberOfModels);
            }
        }
    }

    private void runObserver(IObserver observer, ModelType currentModel, IElement entryNode, int currentModelIndex, int numberOfModels) throws Throwable {
        this.logObserverRun(observer, currentModel, currentModelIndex, numberOfModels);
        IWalker walker = this.selectWalker(currentModel);
        walker.addObserver(observer);
        observer.init(currentModel, currentModelIndex, numberOfModels);
        walker.run(entryNode);
        observer.finish();
        this.mHasPerformedChanges = this.mHasPerformedChanges || observer.performedChanges();
    }

    private void logObserverRun(IObserver observer, ModelType model, int idx, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append("Executing the observer ");
        sb.append(observer.getClass().getSimpleName());
        sb.append(" from plugin ");
        sb.append(this.mTool.getPluginName());
        sb.append(" for \"");
        sb.append(model);
        sb.append("\" (");
        sb.append(idx + 1);
        sb.append("/");
        sb.append(max);
        sb.append(") ...");
        this.mLogger.info((Object)sb.toString());
    }

    private IElement getEntryPoint(ModelType definition) {
        IElement n = null;
        try {
            n = this.mModelManager.getRootNode(definition);
        }
        catch (GraphNotFoundException e) {
            this.mLogger.error((Object)"Graph not found!", (Throwable)e);
        }
        return n;
    }

    private void retrieveModel(IGenerator tool, String observer) {
        IElement element = tool.getModel();
        ModelType type = tool.getOutputDefinition();
        if (element != null && type != null) {
            this.mLogger.info((Object)("Adding new model " + type + " " + element.getClass().getSimpleName()));
            this.mModelManager.addItem(element, type);
        } else {
            this.mLogger.info((Object)String.format("Invalid model from %s for observer %s and model type %s, skipping insertion in model container", tool.getPluginName(), observer, type));
        }
    }

    private List<ModelType> selectModels() {
        ArrayList<ModelType> models = new ArrayList<ModelType>();
        switch (this.mTool.getModelQuery()) {
            case ALL: {
                models.addAll(this.mModelManager.getItemKeys());
                break;
            }
            case USER: {
                if (this.mModelManager.size() > 1) {
                    for (String s : this.mController.selectModel(this.mModelManager.getItemNames())) {
                        ModelType t = this.mModelManager.getGraphTypeById(s);
                        if (t == null) continue;
                        models.add(t);
                    }
                    break;
                }
                models.add(this.mModelManager.getItemKeys().get(0));
                break;
            }
            case LAST: {
                models.add(this.mModelManager.getLastAdded());
                break;
            }
            case SOURCE: {
                models.addAll(this.mModelManager.getItemKeys());
                for (ModelType t : models) {
                    if (t.isFromSource()) continue;
                    models.remove(t);
                }
                break;
            }
            case TOOL: {
                List desiredToolIDs = this.mTool.getDesiredToolIds();
                if (desiredToolIDs == null || desiredToolIDs.isEmpty()) break;
                HashSet idSet = new HashSet(desiredToolIDs);
                this.mModelManager.getItemKeys().stream().filter(a -> idSet.contains(a.getCreator())).forEach(models::add);
                break;
            }
            default: {
                IllegalStateException ex = new IllegalStateException("Unknown query type");
                this.mLogger.fatal((Object)"Unknown query type", (Throwable)ex);
                throw ex;
            }
        }
        if (models.isEmpty()) {
            this.mLogger.warn((Object)"no suitable model selected, skipping...");
        }
        assert (CoreUtil.isSorted((Iterable)models.stream().map(ModelType::getCreated).collect(Collectors.toList()))) : "Available models are not sorted according to creation time";
        return models;
    }

    private IWalker selectWalker(ModelType currentModel) {
        if ("CFG".equals(currentModel.getType().name())) {
            return new CFGWalker(this.mLogger);
        }
        return new DFSTreeWalker(this.mLogger);
    }

    static void initializePlugin(ILogger logger, IToolchainPlugin plugin, IUltimateServiceProvider services, IToolchainStorage storage) {
        logger.info((Object)("Initializing " + plugin.getPluginName() + "..."));
        try {
            plugin.setServices(services);
            plugin.init();
            logger.info((Object)(String.valueOf(plugin.getPluginName()) + " initialized"));
        }
        catch (Exception ex) {
            logger.fatal((Object)("Exception during initialization of " + plugin.getPluginName()));
            throw ex;
        }
    }
}

