/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IServiceFactoryFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.SettingsManager;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.IOutput;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

final class PluginFactory
implements IServiceFactoryFactory {
    private static final Class<?>[] ITOOLCHAIN_PLUGIN_CLASSES = new Class[]{IAnalysis.class, IGenerator.class, IOutput.class, ISource.class};
    private final IExtensionRegistry mRegistry;
    private final ILogger mLogger;
    private final SettingsManager mSettingsManager;
    private final Map<Class<?>, List<IConfigurationElement>> mAvailableToolsByClass;
    private final Map<String, IConfigurationElement> mAvailableToolsByClassName;
    private final Map<String, String> mPluginIDToClassName;
    private final Map<Class<?>, IServiceFactory<?>> mAvailableServicesByClassName;
    private final Set<IConfigurationElement> mFailedTools;
    private boolean mGuiMode;
    private final IController<RunDefinition> mController;
    private List<IToolchainPlugin> mToolchainPluginCache;
    private List<ITool> mToolCache;

    PluginFactory(SettingsManager settingsManager, ILogger logger) {
        this.mLogger = logger;
        this.mRegistry = Platform.getExtensionRegistry();
        this.mAvailableToolsByClass = new HashMap();
        this.mAvailableToolsByClassName = new HashMap<String, IConfigurationElement>();
        this.mPluginIDToClassName = new HashMap<String, String>();
        this.mAvailableServicesByClassName = new HashMap();
        this.mFailedTools = new HashSet<IConfigurationElement>();
        this.mSettingsManager = settingsManager;
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mLogger.debug((Object)"Detecting plugins...");
        this.registerType(IController.class);
        this.registerType(ISource.class);
        this.registerType(IOutput.class);
        this.registerType(IGenerator.class);
        this.registerType(IAnalysis.class);
        this.mController = this.loadControllerPlugin(this.mRegistry);
        this.mLogger.debug((Object)"Finished detecting plugins!");
        this.mLogger.debug((Object)"Loading services ...");
        this.registerType(IServiceFactory.class);
        this.mLogger.debug((Object)"Finished loading services!");
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
    }

    IController<RunDefinition> getController() {
        return this.mController;
    }

    List<String> getPluginClassNames(Class<?> clazz) {
        List<IConfigurationElement> elems = this.mAvailableToolsByClass.get(clazz);
        ArrayList<String> rtr = new ArrayList<String>();
        if (elems != null) {
            for (IConfigurationElement elem : elems) {
                rtr.add(elem.getAttribute("class"));
            }
        }
        return rtr;
    }

    List<String> getPluginIds() {
        return new ArrayList<String>(this.mPluginIDToClassName.keySet());
    }

    <T extends IToolchainPlugin> T createTool(String toolId) {
        IConfigurationElement element = this.mAvailableToolsByClassName.get(toolId);
        if (element == null) {
            element = this.mAvailableToolsByClassName.get(this.mPluginIDToClassName.get(toolId));
        }
        IToolchainPlugin plugin = (IToolchainPlugin)this.createInstance(element);
        return (T)this.prepareToolchainPlugin(plugin);
    }

    private <T extends IToolchainPlugin> T prepareToolchainPlugin(T plugin) {
        ITool tool;
        if (plugin == null) {
            return null;
        }
        if (plugin instanceof ITool && (tool = (ITool)plugin).isGuiRequired() && !this.mGuiMode) {
            this.mLogger.error((Object)("Cannot load plugin " + tool.getPluginID() + ": Requires GUI controller"));
            return null;
        }
        this.mSettingsManager.registerPlugin((IUltimatePlugin)plugin);
        return plugin;
    }

    List<IToolchainPlugin> getAllAvailableToolchainPlugins() {
        if (this.mToolchainPluginCache == null) {
            this.mToolchainPluginCache = this.loadAdmissiblePlugins();
        }
        ArrayList<IToolchainPlugin> rtr = new ArrayList<IToolchainPlugin>();
        rtr.addAll(this.mToolchainPluginCache);
        return rtr;
    }

    List<ITool> getAllAvailableTools() {
        ArrayList<ITool> rtr = new ArrayList<ITool>();
        if (this.mToolCache != null) {
            rtr.addAll(this.mToolCache);
            return rtr;
        }
        for (IToolchainPlugin plugin : this.getAllAvailableToolchainPlugins()) {
            if (!(plugin instanceof ITool)) continue;
            rtr.add((ITool)plugin);
        }
        this.mToolchainPluginCache = new ArrayList<IToolchainPlugin>();
        this.mToolchainPluginCache.addAll(rtr);
        return rtr;
    }

    private List<IToolchainPlugin> loadAdmissiblePlugins() {
        ArrayList<IToolchainPlugin> rtr = new ArrayList<IToolchainPlugin>();
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mLogger.debug((Object)"Loading all admissible plugins (creating one instance, loading preferences)");
        int notAdmissible = 0;
        HashSet<String> pluginIds = new HashSet<String>();
        Class<?>[] classArray = ITOOLCHAIN_PLUGIN_CLASSES;
        int n = ITOOLCHAIN_PLUGIN_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            List<IConfigurationElement> elements = this.mAvailableToolsByClass.get(type);
            if (elements != null) {
                for (IConfigurationElement elem : elements) {
                    try {
                        IToolchainPlugin tool = this.prepareToolchainPlugin((IToolchainPlugin)this.createInstance(elem));
                        if (tool == null) {
                            ++notAdmissible;
                            continue;
                        }
                        if (!pluginIds.add(tool.getPluginID())) continue;
                        rtr.add(tool);
                    }
                    catch (Exception ex) {
                        this.mLogger.fatal((Object)("Exception during admissibility check of plugin " + elem.getName() + ": " + ex.getMessage()));
                    }
                }
            }
            ++n2;
        }
        this.mLogger.debug((Object)("Finished loading " + rtr.size() + " admissible plugins" + (notAdmissible > 0 ? " (" + notAdmissible + " not admissible)" : " (all were admissible)")));
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        return rtr;
    }

    boolean isPluginAvailable(String pluginId) {
        return this.mAvailableToolsByClassName.containsKey(pluginId) || this.mPluginIDToClassName.containsKey(pluginId);
    }

    private IController<RunDefinition> loadControllerPlugin(IExtensionRegistry reg) {
        List<IConfigurationElement> configElements = this.mAvailableToolsByClass.get(IController.class);
        if (configElements.isEmpty()) {
            this.mLogger.fatal((Object)"Invalid configuration. You should have at least one IController plugin, but there are none.");
            return null;
        }
        if (configElements.size() == 1) {
            return this.loadControllerPlugin(configElements.get(0));
        }
        List elemsWithPreference = configElements.stream().map(elem -> new Pair(elem, (Object)Integer.valueOf(elem.getAttribute("preference")))).collect(Collectors.toList());
        Optional preferredElemOptional = elemsWithPreference.stream().min((a, b) -> ((Integer)a.getSecond()).compareTo((Integer)b.getSecond()));
        if (!preferredElemOptional.isPresent()) {
            throw new AssertionError((Object)"Java8 is broken");
        }
        Pair preferredElem = (Pair)preferredElemOptional.get();
        int minValue = (Integer)preferredElem.getSecond();
        List preferredElements = elemsWithPreference.stream().filter(a -> ((Integer)a.getSecond()).equals(minValue)).collect(Collectors.toList());
        int preferredElementsSize = preferredElements.size();
        if (preferredElementsSize == 1) {
            return this.loadControllerPlugin((IConfigurationElement)preferredElem.getFirst());
        }
        this.mLogger.fatal((Object)("Invalid configuration. You should have only one preferred IController plugin, but you have " + preferredElementsSize));
        for (Pair elem2 : preferredElements) {
            this.mLogger.fatal((Object)(String.valueOf(((IConfigurationElement)elem2.getFirst()).getAttribute("class")) + " has preference value " + elem2.getSecond()));
        }
        return null;
    }

    private IController<RunDefinition> loadControllerPlugin(IConfigurationElement controllerDescriptor) {
        IController controller = (IController)this.createInstance(controllerDescriptor);
        this.mGuiMode = Boolean.valueOf(controllerDescriptor.getAttribute("isGraphical"));
        this.mSettingsManager.registerPlugin((IUltimatePlugin)controller);
        this.mLogger.debug((Object)("Loaded " + (this.mGuiMode ? "graphical " : "") + "controller " + controller.getPluginName()));
        return controller;
    }

    private <T extends IUltimatePlugin> T createInstance(IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        if (this.mFailedTools.contains(element)) {
            this.mLogger.warn((Object)("Will not retry already failed Ultimate plugin " + element.getAttribute("class")));
            return null;
        }
        try {
            return (T)((IUltimatePlugin)element.createExecutableExtension("class"));
        }
        catch (CoreException ex) {
            this.mLogger.fatal((Object)("Exception during instantiation of Ultimate plugin " + element.getAttribute("class")), (Throwable)ex);
            this.mFailedTools.add(element);
            return null;
        }
    }

    private void registerType(Class<?> clazz) {
        if (clazz.equals(IServiceFactory.class)) {
            IConfigurationElement[] iConfigurationElementArray = this.mRegistry.getConfigurationElementsFor(PluginFactory.getExtensionPointFromClass(clazz));
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String className = element.getAttribute("class");
                try {
                    Class<?> myClass = Class.forName(className);
                    IServiceFactory factory = (IServiceFactory)this.createInstance(element);
                    this.mSettingsManager.registerPlugin((IUltimatePlugin)factory);
                    this.registerClassAndAllInterfaces(myClass, factory);
                }
                catch (ClassNotFoundException e) {
                    this.mLogger.fatal((Object)("Cannot register type: " + e));
                }
                ++n2;
            }
            this.mLogger.debug((Object)(String.valueOf(this.mAvailableServicesByClassName.size()) + " " + clazz.getSimpleName() + " services available"));
        } else {
            this.registerTool(clazz);
        }
    }

    private void registerClassAndAllInterfaces(Class<?> myClass, IServiceFactory<?> factory) {
        this.mAvailableServicesByClassName.put(myClass, factory);
        Class<?>[] classArray = myClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazzInterface = classArray[n2];
            if (!clazzInterface.equals(IServiceFactory.class)) {
                this.registerClassAndAllInterfaces(clazzInterface, factory);
            }
            ++n2;
        }
    }

    private void registerTool(Class<?> clazz) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        this.mAvailableToolsByClass.put(clazz, result);
        IConfigurationElement[] iConfigurationElementArray = this.mRegistry.getConfigurationElementsFor(PluginFactory.getExtensionPointFromClass(clazz));
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            result.add(element);
            String className = element.getAttribute("class");
            this.mAvailableToolsByClassName.put(className, element);
            this.mPluginIDToClassName.put(PluginFactory.createPluginID(className), className);
            ++n2;
        }
        this.mLogger.debug((Object)(String.valueOf(result.size()) + " " + clazz.getSimpleName() + " plugins available"));
    }

    private static String createPluginID(String classname) {
        return classname.substring(0, classname.lastIndexOf(46));
    }

    private static String getExtensionPointFromClass(Class<?> clazz) {
        String qualifiedName;
        switch (qualifiedName = clazz.getName()) {
            case "de.uni_freiburg.informatik.ultimate.core.model.IController": {
                return "de.uni_freiburg.informatik.ultimate.ep.controller";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.ISource": {
                return "de.uni_freiburg.informatik.ultimate.ep.source";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IOutput": {
                return "de.uni_freiburg.informatik.ultimate.ep.output";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IGenerator": {
                return "de.uni_freiburg.informatik.ultimate.ep.generator";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IAnalysis": {
                return "de.uni_freiburg.informatik.ultimate.ep.analysis";
            }
            case "de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory": {
                return "de.uni_freiburg.informatik.ultimate.ep.service";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T, K extends IServiceFactory<T>> T createService(Class<K> service, IUltimateServiceProvider services, IToolchainStorage storage) {
        IServiceFactory<?> unknownfactory = this.mAvailableServicesByClassName.get(service);
        if (unknownfactory == null) {
            return null;
        }
        IServiceFactory factory = (IServiceFactory)service.cast(unknownfactory);
        return (T)factory.createInstance(services, storage);
    }
}

