/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceBinder;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

final class SettingsManager {
    private static final String SAVING_PREFERENCES_FAILED_WITH_EXCEPTION = "Saving preferences failed with exception: ";
    private final ILogger mLogger;
    private final Map<String, LogPreferenceChangeListener> mActivePreferenceListener;

    SettingsManager(ILogger logger) {
        this.mLogger = logger;
        this.mActivePreferenceListener = new HashMap<String, LogPreferenceChangeListener>();
    }

    void registerPlugin(IUltimatePlugin plugin) {
        if (plugin == null) {
            return;
        }
        String pluginName = plugin.getPluginName();
        IPreferenceInitializer prefs = plugin.getPreferences();
        if (prefs == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Plugin " + pluginName + " does not have preferences"));
            }
            return;
        }
        String pluginId = plugin.getPluginID();
        RcpPreferenceBinder.registerDefaultPreferences(pluginId, prefs.getPreferenceItems());
        this.attachLogPreferenceChangeListenerToPlugin(pluginId, pluginName);
        this.logDefaultPreferences(pluginId, pluginName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadPreferencesFromFile(ICore<RunDefinition> core, String filename, boolean silent) {
        Consumer<Object> infoLogger;
        Consumer<Object> consumer = infoLogger = silent ? a -> {} : arg_0 -> ((ILogger)this.mLogger).info(arg_0);
        if (filename != null && !filename.isEmpty()) {
            this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
            infoLogger.accept("Beginning loading settings from " + filename);
            if (this.mLogger.isDebugEnabled()) {
                infoLogger.accept("Preferences different from defaults before loading file:");
                this.logPreferencesDifferentFromDefaults(core);
            }
            try {
                try {
                    FileInputStream fis = new FileInputStream(filename);
                    IStatus status = RcpPreferenceProvider.importPreferences(fis);
                    if (!status.isOK()) {
                        this.mLogger.warn((Object)("Failed to load preferences. Status is: " + status));
                    } else {
                        infoLogger.accept("Loading preferences was successful");
                    }
                    infoLogger.accept("Preferences different from defaults after loading the file:");
                    if (silent) return;
                    this.logPreferencesDifferentFromDefaults(core);
                    return;
                }
                catch (IOException | CoreException e) {
                    this.mLogger.error((Object)("Could not load preferences: " + e.getMessage()));
                    this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
                }
                return;
            }
            finally {
                this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
            }
        } else {
            this.mLogger.warn((Object)"Loading settings from empty filename is not possible");
        }
    }

    private void logPreferencesDifferentFromDefaults(ICore<RunDefinition> core) {
        boolean isSomePluginDifferent = false;
        IUltimatePlugin[] iUltimatePluginArray = core.getRegisteredUltimatePlugins();
        int n = iUltimatePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUltimatePlugin plugin = iUltimatePluginArray[n2];
            String pluginId = plugin.getPluginID();
            String[] delta = new RcpPreferenceProvider(pluginId).getDeltaPreferencesStrings();
            if (delta != null && delta.length > 0) {
                isSomePluginDifferent = true;
                this.mLogger.info((Object)("Preferences of " + plugin.getPluginName() + " differ from their defaults:"));
                String[] stringArray = delta;
                int n3 = delta.length;
                int n4 = 0;
                while (n4 < n3) {
                    String setting = stringArray[n4];
                    this.mLogger.info((Object)(" * " + setting));
                    ++n4;
                }
            }
            ++n2;
        }
        if (!isSomePluginDifferent) {
            this.mLogger.info((Object)"All preferences are set to their defaults");
        }
    }

    void savePreferences(ICore<RunDefinition> core, String filename) {
        if (filename == null || filename.isEmpty()) {
            return;
        }
        this.mLogger.info((Object)("Saving preferences to file " + filename));
        try {
            File outputFile = new File(filename);
            if (outputFile.isFile() && outputFile.exists()) {
                outputFile.delete();
            }
            FileOutputStream fis = new FileOutputStream(filename);
            IUltimatePlugin[] iUltimatePluginArray = core.getRegisteredUltimatePlugins();
            int n = iUltimatePluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                IUltimatePlugin plugin = iUltimatePluginArray[n2];
                new RcpPreferenceProvider(plugin.getPluginID()).exportPreferences(fis);
                ++n2;
            }
            fis.flush();
            fis.close();
        }
        catch (FileNotFoundException e) {
            this.mLogger.error((Object)SAVING_PREFERENCES_FAILED_WITH_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            this.mLogger.error((Object)SAVING_PREFERENCES_FAILED_WITH_EXCEPTION, (Throwable)e);
        }
        catch (CoreException e) {
            this.mLogger.error((Object)SAVING_PREFERENCES_FAILED_WITH_EXCEPTION, (Throwable)e);
        }
    }

    void resetPreferences(ICore<RunDefinition> core, boolean silent) {
        Consumer<Object> log = silent ? a -> {} : arg_0 -> ((ILogger)this.mLogger).info(arg_0);
        log.accept("Resetting all preferences to default values...");
        IUltimatePlugin[] iUltimatePluginArray = core.getRegisteredUltimatePlugins();
        int n = iUltimatePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUltimatePlugin plugin = iUltimatePluginArray[n2];
            IPreferenceInitializer preferences = plugin.getPreferences();
            if (preferences != null) {
                log.accept("Resetting " + plugin.getPluginName() + " preferences to default values");
                RcpPreferenceBinder.resetToDefaultPreferences(plugin.getPluginID(), preferences.getPreferenceItems());
            } else {
                log.accept(String.valueOf(plugin.getPluginName()) + " provides no preferences, ignoring...");
            }
            ++n2;
        }
        log.accept("Finished resetting all preferences to default values...");
    }

    private void logDefaultPreferences(String pluginID, String pluginName) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        RcpPreferenceProvider ups = new RcpPreferenceProvider(pluginID);
        try {
            IEclipsePreferences defaults = ups.getDefaultEclipsePreferences();
            String prefix = "[" + pluginName + " (Current)] Preference \"";
            String[] stringArray = defaults.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.mLogger.debug((Object)(String.valueOf(prefix) + key + "\" = " + ups.getString(key, "NOT DEFINED")));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            this.mLogger.fatal((Object)("An exception occurred during printing of default preferences for plugin " + pluginName), (Throwable)e);
        }
    }

    private void attachLogPreferenceChangeListenerToPlugin(String pluginId, String pluginName) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Attaching preference change listener for plugin " + pluginName));
        }
        LogPreferenceChangeListener instanceListener = this.retrieveListener(pluginId, pluginName, "Instance");
        LogPreferenceChangeListener configListener = this.retrieveListener(pluginId, pluginName, "Configuration");
        LogPreferenceChangeListener defaultListener = this.retrieveListener(pluginId, pluginName, "Default");
        InstanceScope.INSTANCE.getNode(pluginId).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)instanceListener);
        InstanceScope.INSTANCE.getNode(pluginId).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)instanceListener);
        ConfigurationScope.INSTANCE.getNode(pluginId).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)configListener);
        ConfigurationScope.INSTANCE.getNode(pluginId).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)configListener);
        DefaultScope.INSTANCE.getNode(pluginId).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)defaultListener);
        DefaultScope.INSTANCE.getNode(pluginId).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)defaultListener);
    }

    private LogPreferenceChangeListener retrieveListener(String pluginID, String pluginName, String scope) {
        String listenerID = String.valueOf(pluginID) + scope;
        if (this.mActivePreferenceListener.containsKey(listenerID)) {
            return this.mActivePreferenceListener.get(listenerID);
        }
        LogPreferenceChangeListener listener = new LogPreferenceChangeListener(scope, pluginID, pluginName);
        this.mActivePreferenceListener.put(listenerID, listener);
        return listener;
    }

    class LogPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String mScope;
        private final RcpPreferenceProvider mPreferences;
        private final String mPrefix;

        public LogPreferenceChangeListener(String scope, String pluginID, String pluginName) {
            this.mScope = scope;
            this.mPreferences = new RcpPreferenceProvider(pluginID);
            this.mPrefix = "[" + pluginName + " (" + this.mScope + ")] Preference \"";
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            SettingsManager.this.mLogger.debug((Object)(String.valueOf(this.mPrefix) + event.getKey() + "\" changed: " + event.getOldValue() + " -> " + event.getNewValue() + " (actual value in store: " + this.mPreferences.getString(event.getKey()) + ")"));
        }
    }
}

