/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PersistenceAwareModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginConnector;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.GenericServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AssertionsEnabledResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainPlugin;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToolchainManager {
    private final ILogger mLogger;
    private final PluginFactory mPluginFactory;
    private final IController<RunDefinition> mCurrentController;
    private final AtomicLong mCurrentId;
    private final ConcurrentHashMap<Long, Toolchain> mActiveToolchains;
    private final ILoggingService mLoggingService;

    public ToolchainManager(ILoggingService loggingService, PluginFactory factory, IController<RunDefinition> controller) {
        this.mLoggingService = loggingService;
        this.mLogger = this.mLoggingService.getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.mPluginFactory = factory;
        this.mCurrentController = controller;
        this.mCurrentId = new AtomicLong();
        this.mActiveToolchains = new ConcurrentHashMap();
    }

    public void releaseToolchain(IToolchain<RunDefinition> toolchain) {
        if (toolchain == null) {
            throw new IllegalArgumentException("toolchain");
        }
        Toolchain removedTc = this.mActiveToolchains.remove(toolchain.getId());
        if (removedTc != null && removedTc.getId() != toolchain.getId()) {
            this.mLogger.warn((Object)"An concurrency error occured: Toolchain ID has changed during livecycle");
        }
        if (toolchain.getCurrentToolchainData() != null && toolchain.getCurrentToolchainData().getStorage() != null) {
            toolchain.getCurrentToolchainData().getStorage().clear();
            this.mLogger.debug((Object)("Toolchain " + toolchain.getId() + " released"));
        }
    }

    public IToolchain<RunDefinition> requestToolchain(File[] inputFiles) {
        Toolchain tc = new Toolchain(this.mCurrentId.incrementAndGet(), inputFiles, this.createModelManager());
        this.mActiveToolchains.put(tc.getId(), tc);
        return tc;
    }

    public void close() {
        if (this.mActiveToolchains.size() > 0) {
            this.mLogger.info((Object)("There are still " + this.mActiveToolchains.size() + " active toolchains alive"));
            ArrayList<Toolchain> openChains = new ArrayList<Toolchain>(this.mActiveToolchains.values());
            for (Toolchain tc : openChains) {
                if (tc == null || tc.getCurrentToolchainData() == null || tc.getCurrentToolchainData().getStorage() == null) continue;
                tc.getCurrentToolchainData().getStorage().clear();
            }
            this.mActiveToolchains.clear();
        }
    }

    private IModelManager createModelManager() {
        return new PersistenceAwareModelManager(new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core").getString("Repository directory"), this.mLogger);
    }

    private final class Toolchain
    implements IToolchain<RunDefinition> {
        private final long mId;
        private final IModelManager mModelManager;
        private final Benchmark mBenchmark;
        private IToolchainData<RunDefinition> mToolchainData;
        private final Map<File[], ISource> mFiles2Parser;
        private final File[] mInputFiles;
        private ToolchainWalker mToolchainWalker;

        Toolchain(long id, File[] inputFiles, IModelManager modelManager) {
            this.mId = id;
            this.mModelManager = modelManager;
            this.mBenchmark = new Benchmark();
            this.mFiles2Parser = new LinkedHashMap<File[], ISource>();
            this.mInputFiles = Objects.requireNonNull(inputFiles);
        }

        public void init(IToolchainProgressMonitor monitor) {
            if (this.mToolchainData == null) {
                return;
            }
            this.mToolchainWalker = new ToolchainWalker(this.mBenchmark, this.mModelManager, ToolchainManager.this.mPluginFactory, ToolchainManager.this.mLogger);
            this.mToolchainData.getStorage().clear();
            ToolchainManager.this.mLoggingService.setCurrentControllerID(ToolchainManager.this.mCurrentController.getPluginID());
            ToolchainManager.this.mLoggingService.store(this.mToolchainData.getStorage());
            this.mToolchainData.getStorage().putStorable(GenericServiceProvider.getServiceKey(), (IStorable)new GenericServiceProvider(ToolchainManager.this.mPluginFactory));
            ProgressMonitorService monitorService = new ProgressMonitorService(monitor, ToolchainManager.this.mLogger, this.mToolchainWalker);
            this.mToolchainData.getStorage().putStorable(ProgressMonitorService.getServiceKey(), (IStorable)monitorService);
        }

        public IToolchainData<RunDefinition> makeToolSelection(IToolchainProgressMonitor monitor) {
            List<ITool> tools = ToolchainManager.this.mPluginFactory.getAllAvailableTools();
            if (tools.isEmpty()) {
                ToolchainManager.this.mLogger.warn((Object)(String.valueOf(this.getLogPrefix()) + ": There are no plugins present, returning null tools."));
                return null;
            }
            IToolchainData rtr = ToolchainManager.this.mCurrentController.selectTools(tools);
            return this.setToolSelection(monitor, (IToolchainData<RunDefinition>)rtr);
        }

        public IToolchainData<RunDefinition> setToolSelection(IToolchainProgressMonitor monitor, IToolchainData<RunDefinition> data) {
            if (data == null) {
                ToolchainManager.this.mLogger.warn((Object)(String.valueOf(this.getLogPrefix()) + ": No toolchain found."));
                return null;
            }
            if (!this.checkToolchain(((RunDefinition)data.getRootElement()).getToolchain().getPluginOrSubchain())) {
                ToolchainManager.this.mLogger.warn((Object)(String.valueOf(this.getLogPrefix()) + ": Invalid toolchain found."));
                return null;
            }
            this.mToolchainData = data;
            this.init(monitor);
            ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": Toolchain selected."));
            return data;
        }

        public boolean initializeParsers() {
            if (this.mInputFiles == null || this.mInputFiles.length == 0) {
                ToolchainManager.this.mLogger.fatal((Object)(String.valueOf(this.getLogPrefix()) + ": No input files specified"));
                return false;
            }
            Set<ISource> parsers = this.loadParsers();
            HashSet<File> alreadyParsable = new HashSet<File>();
            for (ISource parser : parsers) {
                File[] parseableFiles = parser.parseable(this.mInputFiles);
                assert (parseableFiles != null);
                if (parseableFiles.length <= 0) continue;
                this.mFiles2Parser.put(parseableFiles, parser);
                File[] fileArray = parseableFiles;
                int n = parseableFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File parseableFile = fileArray[n2];
                    if (!alreadyParsable.add(parseableFile)) {
                        ToolchainManager.this.mLogger.warn((Object)("Multiple parsers will parse " + parseableFile.getAbsolutePath()));
                    }
                    ++n2;
                }
            }
            if (this.mFiles2Parser.isEmpty()) {
                ToolchainManager.this.mLogger.warn((Object)(String.valueOf(this.getLogPrefix()) + ": No parsers available for " + this.getStringFromFiles(this.mInputFiles)));
                return false;
            }
            Set allFiles = Arrays.stream(this.mInputFiles).collect(Collectors.toSet());
            Set selectedFiles = this.mFiles2Parser.entrySet().stream().flatMap(a -> Arrays.stream((File[])a.getKey())).collect(Collectors.toSet());
            if (!selectedFiles.containsAll(allFiles)) {
                HashSet<File> notParseable = new HashSet<File>(allFiles);
                notParseable.removeAll(selectedFiles);
                ToolchainManager.this.mLogger.error((Object)(String.valueOf(this.getLogPrefix()) + ": No parsers available for " + this.getStringFromFiles(notParseable)));
                return false;
            }
            ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": Applicable parser(s) successfully (re)initialized"));
            return true;
        }

        private String getStringFromFiles(File[] files) {
            return this.getStringFromFiles(Arrays.stream(files));
        }

        private String getStringFromFiles(Collection<File> files) {
            return this.getStringFromFiles(files.stream());
        }

        private String getStringFromFiles(Stream<File> fileStream) {
            return fileStream.map(File::getAbsolutePath).collect(Collectors.joining(","));
        }

        public void runParsers() throws Exception {
            for (Map.Entry<File[], ISource> entry : this.mFiles2Parser.entrySet()) {
                ISource parser = entry.getValue();
                File[] input = entry.getKey();
                IElement element = this.runParser(input, parser);
                ModelType t = parser.getOutputDefinition();
                if (t == null) {
                    String errorMsg = String.valueOf(parser.getPluginName()) + " returned invalid output definition for file(s) " + this.getStringFromFiles(input);
                    ToolchainManager.this.mLogger.fatal((Object)(String.valueOf(this.getLogPrefix()) + ": " + errorMsg + ", aborting..."));
                    throw new IllegalArgumentException(errorMsg);
                }
                this.addAST(element, t);
            }
        }

        public IToolchain.ReturnCode processToolchain(IToolchainProgressMonitor monitor) throws Throwable {
            IToolchain.ReturnCode returnCode;
            ToolchainManager.this.mLogger.info((Object)("####################### " + this.getLogPrefix() + " #######################"));
            RcpPreferenceProvider ups = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
            boolean useBenchmark = ups.getBoolean("Generate benchmark results");
            IUltimateServiceProvider currentToolchainServices = this.mToolchainData.getServices();
            Benchmark bench = null;
            if (useBenchmark) {
                bench = new Benchmark();
                bench.start("Toolchain (without parser)");
            }
            try {
                if (this.mModelManager.size() < 1) {
                    ToolchainManager.this.mLogger.error((Object)(String.valueOf(this.getLogPrefix()) + ": There is no model present. Did you run a ISource or IGenerator plugin in your toolchain?"));
                    throw new IllegalStateException("There is no model present.");
                }
                Collection<ISource> parsers = this.mFiles2Parser.values();
                this.mToolchainData = ToolchainManager.this.mCurrentController.prerun(this.mToolchainData);
                ToolchainWalker.CompleteToolchainData data = new ToolchainWalker.CompleteToolchainData(this.mToolchainData, parsers.toArray(new ISource[parsers.size()]), ToolchainManager.this.mCurrentController);
                currentToolchainServices = data.getToolchain().getServices();
                returnCode = this.mToolchainWalker.walk(data, currentToolchainServices.getProgressMonitorService(), monitor);
            }
            catch (Throwable throwable) {
                IResultService resultService = currentToolchainServices.getResultService();
                if (VMUtils.areAssertionsEnabled()) {
                    resultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new AssertionsEnabledResult("de.uni_freiburg.informatik.ultimate.core"));
                }
                if (useBenchmark) {
                    bench.stopAll();
                    bench.printResult(ToolchainManager.this.mLogger);
                    this.mBenchmark.printResult(ToolchainManager.this.mLogger);
                    resultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new StatisticsResult("de.uni_freiburg.informatik.ultimate.core", "Toolchain Benchmarks", (ICsvProviderProvider)this.mBenchmark));
                }
                ToolchainManager.this.mLogger.info((Object)("#######################  End " + this.getLogPrefix() + " #######################"));
                ILogger controllerLogger = currentToolchainServices.getLoggingService().getControllerLogger();
                boolean appendCompleteLongDescription = CorePreferenceInitializer.getPreferenceProvider(currentToolchainServices).getBoolean("Show long description of results");
                boolean printStatisticResults = CorePreferenceInitializer.getPreferenceProvider(currentToolchainServices).getBoolean("Print statistic results");
                Map results = printStatisticResults ? resultService.getResults() : ResultUtil.filterResultMap((Map)resultService.getResults(), p -> !(p instanceof StatisticsResult));
                ResultUtil.logResults((ILogger)controllerLogger, (Map)results, (boolean)appendCompleteLongDescription);
                ToolchainManager.this.mCurrentController.displayToolchainResults(this.mToolchainData, resultService.getResults());
                this.mModelManager.removeAll();
                this.mToolchainWalker.endToolchain();
                throw throwable;
            }
            IResultService resultService = currentToolchainServices.getResultService();
            if (VMUtils.areAssertionsEnabled()) {
                resultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new AssertionsEnabledResult("de.uni_freiburg.informatik.ultimate.core"));
            }
            if (useBenchmark) {
                bench.stopAll();
                bench.printResult(ToolchainManager.this.mLogger);
                this.mBenchmark.printResult(ToolchainManager.this.mLogger);
                resultService.reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new StatisticsResult("de.uni_freiburg.informatik.ultimate.core", "Toolchain Benchmarks", (ICsvProviderProvider)this.mBenchmark));
            }
            ToolchainManager.this.mLogger.info((Object)("#######################  End " + this.getLogPrefix() + " #######################"));
            ILogger controllerLogger = currentToolchainServices.getLoggingService().getControllerLogger();
            boolean appendCompleteLongDescription = CorePreferenceInitializer.getPreferenceProvider(currentToolchainServices).getBoolean("Show long description of results");
            boolean printStatisticResults = CorePreferenceInitializer.getPreferenceProvider(currentToolchainServices).getBoolean("Print statistic results");
            Map results = printStatisticResults ? resultService.getResults() : ResultUtil.filterResultMap((Map)resultService.getResults(), p -> !(p instanceof StatisticsResult));
            ResultUtil.logResults((ILogger)controllerLogger, (Map)results, (boolean)appendCompleteLongDescription);
            ToolchainManager.this.mCurrentController.displayToolchainResults(this.mToolchainData, resultService.getResults());
            this.mModelManager.removeAll();
            this.mToolchainWalker.endToolchain();
            return returnCode;
        }

        public void addAST(IElement root, ModelType outputDefinition) {
            if (this.mModelManager.addItem(root, outputDefinition)) {
                ToolchainManager.this.mLogger.debug((Object)(String.valueOf(this.getLogPrefix()) + ": Successfully added AST to model manager"));
            } else {
                ToolchainManager.this.mLogger.error((Object)(String.valueOf(this.getLogPrefix()) + ": Could not add AST to model manager!"));
            }
        }

        public long getId() {
            return this.mId;
        }

        private boolean checkToolchain(List<Object> chain) {
            return chain.stream().allMatch(this::checkToolchainElement);
        }

        private boolean checkToolchainElement(Object elem) {
            if (elem instanceof PluginType) {
                PluginType plugin = (PluginType)elem;
                if (ToolchainManager.this.mPluginFactory.isPluginAvailable(plugin.getId())) {
                    return true;
                }
                ToolchainManager.this.mLogger.error((Object)(String.valueOf(this.getLogPrefix()) + ": Did not find plugin with id \"" + plugin.getId() + "\". The following plugins are currently available:"));
                this.printAvailableTools();
                return false;
            }
            if (elem instanceof SubchainType) {
                return this.checkToolchain(((SubchainType)elem).getPluginOrSubchain());
            }
            throw new IllegalArgumentException("Found unknown type in toolchain: " + elem.getClass());
        }

        private void printAvailableTools() {
            if (!ToolchainManager.this.mLogger.isInfoEnabled()) {
                return;
            }
            for (ITool t : ToolchainManager.this.mPluginFactory.getAllAvailableTools()) {
                ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": " + t.getPluginID()));
            }
        }

        private IElement runParser(File[] input, ISource parser) throws Exception {
            boolean useBenchmark = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core").getBoolean("Generate benchmark results");
            IElement root = null;
            PluginConnector.initializePlugin(ToolchainManager.this.mLogger, (IToolchainPlugin)parser, this.mToolchainData.getServices(), this.mToolchainData.getStorage());
            try {
                try {
                    if (useBenchmark) {
                        this.mBenchmark.start(parser.getPluginName());
                    }
                    if (input.length == 1) {
                        ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": Parsing single file: " + input[0].getAbsolutePath()));
                    } else {
                        ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": Parsing files: " + this.getStringFromFiles(input)));
                    }
                    if (useBenchmark) {
                        this.mBenchmark.stop(parser.getPluginName());
                    }
                    root = parser.parseAST(input);
                }
                catch (Exception e) {
                    ToolchainManager.this.mLogger.fatal((Object)(String.valueOf(this.getLogPrefix()) + ": Exception during parsing: "), (Throwable)e);
                    this.resetModelManager();
                    throw e;
                }
            }
            finally {
                parser.finish();
            }
            return root;
        }

        private void resetModelManager() {
            if (!this.mModelManager.isEmpty()) {
                ToolchainManager.this.mLogger.info((Object)(String.valueOf(this.getLogPrefix()) + ": Clearing model..."));
                try {
                    this.mModelManager.persistAll(false);
                }
                catch (StoreObjectException e) {
                    Throwable cause = e.getCause();
                    ToolchainManager.this.mLogger.error((Object)(String.valueOf(this.getLogPrefix()) + ": Failed to persist models: " + (cause == null ? e.getMessage() : cause.getMessage())));
                }
            }
        }

        private Set<ISource> loadParsers() {
            List<String> parserIds = ToolchainManager.this.mPluginFactory.getPluginClassNames(ISource.class);
            if (ToolchainManager.this.mLogger.isDebugEnabled()) {
                ToolchainManager.this.mLogger.debug((Object)(String.valueOf(this.getLogPrefix()) + ": We have " + parserIds.size() + " parsers present."));
            }
            HashSet<ISource> rtr = new HashSet<ISource>();
            for (String parserId : parserIds) {
                ISource parser = (ISource)ToolchainManager.this.mPluginFactory.createTool(parserId);
                if (parser == null) {
                    ToolchainManager.this.mLogger.warn((Object)(String.valueOf(this.getLogPrefix()) + ": Parser with ID " + parserId + " could not be created"));
                    continue;
                }
                rtr.add(parser);
            }
            return rtr;
        }

        public IToolchainData<RunDefinition> getCurrentToolchainData() {
            return this.mToolchainData;
        }

        private String getLogPrefix() {
            return "[Toolchain " + this.mId + "]";
        }

        public File[] getInputFiles() {
            return this.mInputFiles;
        }
    }
}

