/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IModelManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginConnector;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.GraphNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.DropmodelType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ModelIdOnlyType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.PluginType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SerializeType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.SubchainType;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainModelType;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.ITimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainCancel;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class ToolchainWalker
implements IToolchainCancel {
    private static final int INITIAL_COUNTDOWN = 2;
    private boolean mToolchainCancelRequest;
    private final ILogger mLogger;
    private final Map<String, PluginConnector> mOpenPlugins;
    private final Benchmark mBench;
    private final IModelManager mModelManager;
    private final PluginFactory mPluginFactory;
    private final CountDownLatch mCountDownLatch;

    ToolchainWalker(Benchmark bench, IModelManager mmanager, PluginFactory factory, ILogger logger) {
        assert (logger != null);
        this.mBench = bench;
        this.mModelManager = mmanager;
        this.mLogger = logger;
        this.mPluginFactory = factory;
        this.mOpenPlugins = new HashMap<String, PluginConnector>();
        this.mCountDownLatch = new CountDownLatch(2);
        this.mToolchainCancelRequest = false;
    }

    IToolchain.ReturnCode walk(CompleteToolchainData data, IProgressMonitorService service, IToolchainProgressMonitor monitor) throws Throwable {
        if (this.mCountDownLatch.getCount() != 2L) {
            throw new IllegalStateException("You cannot reuse the toolchain walker");
        }
        try {
            IToolchain.ReturnCode returnCode = this.walkUnprotected(data, service, monitor);
            return returnCode;
        }
        finally {
            this.mCountDownLatch.countDown();
            monitor.done();
        }
    }

    public CountDownLatch cancelToolchain() {
        this.mToolchainCancelRequest = true;
        return this.mCountDownLatch;
    }

    void endToolchain() {
        this.mCountDownLatch.countDown();
    }

    private IToolchain.ReturnCode walkUnprotected(CompleteToolchainData data, IProgressMonitorService service, IToolchainProgressMonitor monitor) throws Throwable {
        IToolchainData<RunDefinition> chain = data.getToolchain();
        int remainingWork = ((RunDefinition)chain.getRootElement()).getToolchain().getPluginOrSubchain().size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)RcpProgressMonitorWrapper.create(monitor), (int)remainingWork);
        this.mLogger.info((Object)("Walking toolchain with " + remainingWork + " elements."));
        for (Object toolchainElement : ((RunDefinition)chain.getRootElement()).getToolchain().getPluginOrSubchain()) {
            IToolchain.ReturnCode returnCode;
            if (toolchainElement instanceof PluginType) {
                PluginType plugin = (PluginType)toolchainElement;
                if (this.shouldCancel(data, service, monitor, plugin.getId())) {
                    return IToolchain.ReturnCode.Cancel;
                }
                returnCode = this.processPlugin(data, plugin);
                progress.worked(1);
                progress.setWorkRemaining(--remainingWork);
            } else if (toolchainElement instanceof SubchainType) {
                SubchainType subchain = (SubchainType)toolchainElement;
                if (this.shouldCancel(data, service, monitor, subchain.toString())) {
                    return IToolchain.ReturnCode.Cancel;
                }
                returnCode = this.processSubchain(data, subchain, (IProgressMonitor)progress.newChild(1));
                progress.worked(1);
                progress.setWorkRemaining(--remainingWork);
            } else {
                if (toolchainElement != null) {
                    this.mLogger.warn((Object)("Unknown toolchain element " + toolchainElement.getClass().getSimpleName() + ", skipping..."));
                } else {
                    this.mLogger.warn((Object)"Toolchain element is NULL, skipping...");
                }
                returnCode = IToolchain.ReturnCode.Ok;
            }
            switch (returnCode) {
                case Error: 
                case Cancel: {
                    return returnCode;
                }
                case Ok: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown return code");
                }
            }
        }
        return IToolchain.ReturnCode.Ok;
    }

    private boolean shouldCancel(CompleteToolchainData data, IProgressMonitorService service, IToolchainProgressMonitor monitor, String pluginId) {
        if (this.mToolchainCancelRequest || monitor.isCanceled()) {
            this.mLogger.info((Object)("Toolchain execution was canceled (user or tool) before executing " + pluginId));
            return true;
        }
        if (!service.continueProcessing()) {
            Collection toResults = ResultUtil.filterResults((Map)data.getToolchain().getServices().getResultService().getResults(), ITimeoutResult.class);
            if (toResults.isEmpty()) {
                data.getToolchain().getServices().getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new TimeoutResult("de.uni_freiburg.informatik.ultimate.core", "Timeout occured before executing " + pluginId));
            }
            this.mLogger.info((Object)("Toolchain execution was canceled (Timeout) before executing " + pluginId));
            return true;
        }
        return false;
    }

    private IToolchain.ReturnCode processPlugin(CompleteToolchainData data, PluginType plugin) {
        PluginConnector pc;
        ITool tool = (ITool)this.mPluginFactory.createTool(plugin.getId());
        if (tool == null) {
            this.mLogger.error((Object)("Couldn't identify tool for plugin id " + plugin.getId() + "!"));
            this.mToolchainCancelRequest = true;
            return IToolchain.ReturnCode.Cancel;
        }
        if (!this.mOpenPlugins.containsKey(plugin.getId())) {
            pc = new PluginConnector(this.mModelManager, tool, data.getController(), data.getToolchain().getStorage(), data.getToolchain().getServices());
            this.mOpenPlugins.put(plugin.getId(), pc);
        } else {
            pc = this.mOpenPlugins.get(plugin.getId());
        }
        if (this.mBench != null) {
            this.mBench.start(pc.toString());
        }
        return this.executePluginConnector(data, plugin, pc);
    }

    private IToolchain.ReturnCode executePluginConnector(CompleteToolchainData data, PluginType plugin, PluginConnector pc) {
        try {
            pc.run();
            IToolchain.ReturnCode returnCode = IToolchain.ReturnCode.Ok;
            return returnCode;
        }
        catch (Throwable e) {
            IToolchain.ReturnCode returnCode = this.handleException(data, plugin, e);
            return returnCode;
        }
        finally {
            DropmodelType dt;
            SerializeType st;
            if (this.mBench != null) {
                this.mBench.stop(pc.toString());
            }
            if ((st = plugin.getSerialize()) != null) {
                this.processSerializeStmt(data, st);
            }
            if ((dt = plugin.getDropmodels()) != null) {
                this.processDropmodelStmt(data, dt);
            }
        }
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData data, PluginType plugin, ToolchainCanceledException e) {
        this.mLogger.info((Object)("Toolchain cancelled while executing plugin " + plugin.getId() + ". Reason: " + e.getMessage()));
        String longDescription = "Toolchain cancelled " + e.printRunningTaskMessage();
        TimeoutResult timeoutResult = new TimeoutResult(plugin.getId(), longDescription);
        data.getToolchain().getServices().getResultService().reportResult(plugin.getId(), (IResult)timeoutResult);
        return IToolchain.ReturnCode.Cancel;
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData data, PluginType plugin, SMTLIBException e) {
        this.mLogger.fatal((Object)"An unrecoverable error occured during an interaction with an SMT solver:", (Throwable)e);
        ToolchainWalker.reportExceptionOrError(data, plugin.getId(), (Throwable)e);
        return IToolchain.ReturnCode.Error;
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData data, PluginType plugin, ToolchainExceptionWrapper e) {
        this.mLogger.fatal((Object)"A wrapped exception occured:", (Throwable)e);
        return this.handleException(data, plugin, e.getCause());
    }

    private IToolchain.ReturnCode handleException(CompleteToolchainData data, PluginType plugin, Throwable cause) {
        if (cause instanceof ToolchainExceptionWrapper) {
            return this.handleException(data, plugin, (ToolchainExceptionWrapper)cause);
        }
        if (cause instanceof SMTLIBException) {
            return this.handleException(data, plugin, (SMTLIBException)cause);
        }
        if (cause instanceof ToolchainCanceledException) {
            return this.handleException(data, plugin, (ToolchainCanceledException)cause);
        }
        return this.handleExceptionFallback(data, plugin, cause);
    }

    private IToolchain.ReturnCode handleExceptionFallback(CompleteToolchainData data, PluginType plugin, Throwable e) {
        String pluginId = plugin.getId();
        this.mLogger.fatal((Object)("The Plugin " + pluginId + " has thrown an exception:"), e);
        ToolchainWalker.reportExceptionOrError(data, pluginId, e);
        return IToolchain.ReturnCode.Error;
    }

    private static void reportExceptionOrError(CompleteToolchainData data, String pluginId, Throwable e) {
        data.getToolchain().getServices().getResultService().reportResult(pluginId, (IResult)new ExceptionOrErrorResult(pluginId, e));
    }

    private IToolchain.ReturnCode processSubchain(CompleteToolchainData data, SubchainType chain, IProgressMonitor monitor) {
        this.mLogger.fatal((Object)"Subchain support is broken");
        return IToolchain.ReturnCode.Error;
    }

    private void processSerializeStmt(CompleteToolchainData data, SerializeType serializeType) {
        ArrayList<ModelType> models = new ArrayList<ModelType>();
        if (serializeType.getParser() != null) {
            ISource[] iSourceArray = data.getParsers();
            int n = iSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISource parser = iSourceArray[n2];
                ModelType graphType = this.mModelManager.getGraphTypeByGeneratorPluginId(parser.getPluginID());
                if (graphType != null) {
                    models.add(graphType);
                } else {
                    this.mLogger.warn((Object)"Parser model could not be found!");
                }
                ++n2;
            }
        }
        for (ToolchainModelType modelType : serializeType.getModel()) {
            ModelType graphType = "mostrecent".equals(modelType.getId()) ? this.mModelManager.getLastAdded() : this.mModelManager.getGraphTypeByGeneratorPluginId(modelType.getId());
            if (graphType != null) {
                models.add(graphType);
                continue;
            }
            this.mLogger.warn((Object)("Model " + modelType.getId() + " could not be found!"));
        }
        for (ModelType model : models) {
            try {
                this.mLogger.debug((Object)("Attempting to serialize model " + model.toString() + " ..."));
                this.mModelManager.persistAndDropExistingGraph(model);
                this.mLogger.debug((Object)"Persisting model succeeded.");
            }
            catch (StoreObjectException e) {
                this.mLogger.error((Object)"An error occurred while persisting selected model", (Throwable)e);
            }
            catch (GraphNotFoundException e) {
                this.mLogger.error((Object)"Specified graph could not be found.", (Throwable)e);
            }
        }
    }

    private void processDropmodelStmt(CompleteToolchainData data, DropmodelType dt) {
        if (dt.getParser() != null) {
            ISource[] iSourceArray = data.getParsers();
            int n = iSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISource parser = iSourceArray[n2];
                ModelType model = this.mModelManager.getGraphTypeByGeneratorPluginId(parser.getPluginID());
                this.dropModel(model, parser.getPluginID());
                ++n2;
            }
        }
        for (ModelIdOnlyType modelId : dt.getModel()) {
            ModelType model = this.mModelManager.getGraphTypeByGeneratorPluginId(modelId.getId());
            this.dropModel(model, modelId.getId());
        }
    }

    private void dropModel(ModelType modelType, String id) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Attempting to drop model " + id + " ..."));
        }
        if (modelType == null || !this.mModelManager.removeItem(modelType)) {
            this.mLogger.warn((Object)("Failed to remove model " + id));
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Dropping model succeeded.");
        }
    }

    static final class CompleteToolchainData {
        private final IToolchainData<RunDefinition> mToolchain;
        private final ISource[] mParsers;
        private final IController<RunDefinition> mController;

        CompleteToolchainData(IToolchainData<RunDefinition> toolchain, ISource[] parsers, IController<RunDefinition> controller) {
            this.mToolchain = toolchain;
            this.mParsers = parsers;
            this.mController = controller;
        }

        IToolchainData<RunDefinition> getToolchain() {
            return this.mToolchain;
        }

        ISource[] getParsers() {
            return this.mParsers;
        }

        IController<RunDefinition> getController() {
            return this.mController;
        }
    }
}

