/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.PluginFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.SettingsManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainManager;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.ToolchainWalker;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.util.RcpUtils;
import de.uni_freiburg.informatik.ultimate.ep.UltimateExtensionPoints;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class UltimateCore
implements IApplication,
ICore<RunDefinition>,
IUltimatePlugin {
    private static String[] sPluginNames;
    private ILogger mLogger;
    private IController<RunDefinition> mCurrentController;
    private ToolchainWalker mToolchainWalker;
    private ToolchainStorage mCoreStorage;
    private PluginFactory mPluginFactory;
    private SettingsManager mSettingsManager;
    private ToolchainManager mToolchainManager;
    private ILoggingService mLoggingService;
    private JobChangeAdapter mJobChangeAdapter;
    private String mUltimateVersion;

    public final Object startManually(IController<RunDefinition> controller) throws Exception {
        this.setCurrentController(controller);
        return this.start(null);
    }

    public final Object start(IApplicationContext context) throws Exception {
        String workspaceLoc;
        this.mCoreStorage = new ToolchainStorage();
        this.mLoggingService = this.mCoreStorage.getLoggingService();
        this.mLogger = this.mLoggingService.getLogger("de.uni_freiburg.informatik.ultimate.core");
        this.mLogger.debug((Object)"Initializing application");
        ILogger tmpLogger = this.mLogger;
        this.mJobChangeAdapter = new UltimateJobChangeAdapter(tmpLogger);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.mJobChangeAdapter);
        this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
        this.mSettingsManager = new SettingsManager(this.mLogger);
        this.mSettingsManager.registerPlugin(this);
        this.mLoggingService.reloadLoggers();
        try {
            workspaceLoc = UltimateCore.getCliWorkspaceLoc();
        }
        catch (IllegalArgumentException ex) {
            this.mLogger.fatal((Object)ex.getMessage());
            return -2;
        }
        if (workspaceLoc != null) {
            Location instanceLocation = Platform.getInstanceLocation();
            if (instanceLocation == null) {
                this.mLogger.fatal((Object)"Specifying -data @none is not supported");
                return -2;
            }
            if (instanceLocation.isSet()) {
                this.mLogger.fatal((Object)"You did specify -ultimatedata without specifying -data @noDefault");
                return -2;
            }
            String randomSubDir = UUID.randomUUID().toString().substring(0, 10).replace("-", "");
            String randomWorkspaceLoc = Path.fromOSString((String)workspaceLoc).append(randomSubDir).toOSString();
            instanceLocation.set(new URL("file", null, randomWorkspaceLoc), false);
            File toDelete = new File(randomWorkspaceLoc);
            Thread deleteWorkspaceThread = new Thread((Runnable)new DeleteDir(toDelete), "DeleteRandomWorkspace_" + CoreUtil.class.getSimpleName());
            Runtime.getRuntime().addShutdownHook(deleteWorkspaceThread);
        }
        this.mPluginFactory = new PluginFactory(this.mSettingsManager, this.mLogger);
        this.setCurrentController(this.mPluginFactory.getController());
        this.mToolchainManager = new ToolchainManager(this.mLoggingService, this.mPluginFactory, this.getCurrentController());
        try {
            Integer rtrCode = this.activateController();
            this.mToolchainManager.close();
            ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
            Integer n = rtrCode;
            return n;
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.mJobChangeAdapter);
            this.mJobChangeAdapter = null;
            this.mCoreStorage.clear();
            Platform.getInstanceLocation().release();
        }
    }

    private static String getCliWorkspaceLoc() {
        String[] recognizedProperties;
        EnvironmentInfo envInfo = RcpUtils.getEnvironmentInfo();
        Iterator iter = Arrays.stream(envInfo.getCommandLineArgs()).iterator();
        String workspaceloc = null;
        while (iter.hasNext()) {
            String current = (String)iter.next();
            if (!"-ultimatedata".equals(current)) continue;
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("-ultimatedata has no argument");
            }
            workspaceloc = (String)iter.next();
            break;
        }
        if (workspaceloc == null) {
            return null;
        }
        String[] stringArray = recognizedProperties = new String[]{"@user.home"};
        int n = recognizedProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String recognizedProperty = stringArray[n2];
            if (workspaceloc.contains(recognizedProperty)) {
                workspaceloc = workspaceloc.replace(recognizedProperty, envInfo.getProperty(recognizedProperty.substring(1)));
            }
            ++n2;
        }
        return workspaceloc;
    }

    private int activateController() {
        this.mLogger.debug((Object)"Initializing controller ...");
        if (this.getCurrentController() == null) {
            this.mLogger.fatal((Object)"Could not find a controller. Ultimate will exit.");
            return -1;
        }
        this.mLoggingService.setCurrentControllerID(this.getCurrentControllerID());
        int returnCode = this.getCurrentController().init((ICore)this);
        String msg = "Preparing to exit Ultimate with return code " + returnCode;
        if (returnCode == 0) {
            this.mLogger.debug((Object)msg);
        } else {
            this.mLogger.warn((Object)msg);
        }
        return returnCode;
    }

    public void cancelToolchain() {
        this.mToolchainWalker.cancelToolchain();
    }

    public IUltimatePlugin[] getRegisteredUltimatePlugins() {
        LinkedHashSet<UltimateCore> rtr = new LinkedHashSet<UltimateCore>();
        rtr.add(this);
        rtr.add((UltimateCore)this.getCurrentController());
        rtr.addAll(this.mPluginFactory.getAllAvailableToolchainPlugins());
        return rtr.toArray(new IUltimatePlugin[rtr.size()]);
    }

    public String[] getRegisteredUltimatePluginIDs() {
        List<String> rtr = this.mPluginFactory.getPluginIds();
        return rtr.toArray(new String[rtr.size()]);
    }

    public void loadPreferences(String absolutePath, boolean silent) {
        this.mSettingsManager.loadPreferencesFromFile(this, absolutePath, silent);
        this.mLoggingService.reloadLoggers();
    }

    public void savePreferences(String filename) {
        this.mSettingsManager.savePreferences(this, filename);
    }

    public void resetPreferences(boolean silent) {
        this.mSettingsManager.resetPreferences(this, silent);
    }

    public IToolchain<RunDefinition> requestToolchain(File[] inputFiles) {
        return this.mToolchainManager.requestToolchain(inputFiles);
    }

    public void releaseToolchain(IToolchain<RunDefinition> toolchain) {
        this.mToolchainManager.releaseToolchain(toolchain);
    }

    public void stop() {
        this.mLogger.warn((Object)"Received 'Stop'-Command, ignoring...");
    }

    private void setCurrentController(IController<RunDefinition> controller) {
        if (this.mCurrentController != null) {
            if (controller == null) {
                this.mLogger.warn((Object)("Controller already set! Using " + this.mCurrentController.getPluginName() + " and ignoring request to set controller to NULL (this may indicate test mode!)"));
            } else {
                this.mLogger.warn((Object)("Controller already set! Using " + this.mCurrentController.getPluginName() + " and ignoring request to set " + controller.getPluginName()));
            }
            return;
        }
        assert (controller != null);
        this.mCurrentController = controller;
    }

    private IController<RunDefinition> getCurrentController() {
        return this.mCurrentController;
    }

    private String getCurrentControllerID() {
        if (this.getCurrentController() == null) {
            return "de.uni_freiburg.informatik.ultimate.core";
        }
        return this.getCurrentController().getPluginID();
    }

    public static synchronized String[] getPluginNames() {
        if (sPluginNames == null) {
            ArrayList<String> lil = new ArrayList<String>();
            for (String ep : UltimateExtensionPoints.PLUGIN_EPS) {
                IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(ep);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement elem = iConfigurationElementArray[n2];
                    String classname = elem.getAttribute("class");
                    lil.add(classname.substring(0, classname.lastIndexOf(46)));
                    ++n2;
                }
            }
            sPluginNames = lil.toArray(new String[lil.size()]);
        }
        return sPluginNames;
    }

    public IToolchainData<RunDefinition> createToolchainData(String filename) throws FileNotFoundException, JAXBException, SAXException {
        if (!new File(filename).exists()) {
            throw new FileNotFoundException("The specified toolchain file " + filename + " was not found");
        }
        ToolchainStorage tcStorage = new ToolchainStorage();
        return new ToolchainData(filename, (IUltimateServiceProvider)tcStorage, (IToolchainStorage)tcStorage);
    }

    public IToolchainData<RunDefinition> createToolchainData() {
        ToolchainStorage tcStorage = new ToolchainStorage();
        return new ToolchainData((IUltimateServiceProvider)tcStorage, (IToolchainStorage)tcStorage);
    }

    public String getPluginName() {
        return "UltimateCore";
    }

    public String getPluginID() {
        return "de.uni_freiburg.informatik.ultimate.core";
    }

    public IPreferenceInitializer getPreferences() {
        return new CorePreferenceInitializer();
    }

    public ILoggingService getCoreLoggingService() {
        return this.mCoreStorage.getLoggingService();
    }

    public IPreferenceProvider getPreferenceProvider(String pluginId) {
        return this.mCoreStorage.getPreferenceProvider(pluginId);
    }

    public String getUltimateVersionString() {
        if (this.mUltimateVersion == null) {
            this.mUltimateVersion = this.createVersionString();
        }
        return this.mUltimateVersion;
    }

    private String createVersionString() {
        Bundle bundle = Platform.getBundle((String)"de.uni_freiburg.informatik.ultimate.core");
        if (bundle == null) {
            return "UNKNOWN";
        }
        Dictionary headers = bundle.getHeaders();
        if (headers == null) {
            return "UNKNOWN";
        }
        String major = (String)headers.get("Bundle-Version");
        String gitVersion = CoreUtil.readGitVersion((ClassLoader)this.getClass().getClassLoader());
        if (gitVersion == null) {
            return major;
        }
        return String.valueOf(major) + "-" + gitVersion;
    }

    private static final class DeleteDir
    implements Runnable {
        private final File mToDelete;

        private DeleteDir(File toDelete) {
            this.mToDelete = toDelete;
        }

        @Override
        public void run() {
            CoreUtil.deleteDirectory((File)this.mToDelete);
        }
    }

    private static final class UltimateJobChangeAdapter
    extends JobChangeAdapter {
        private final ILogger mLogger;

        private UltimateJobChangeAdapter(ILogger logger) {
            this.mLogger = logger;
        }

        public void done(IJobChangeEvent event) {
            if (event == null) {
                return;
            }
            if (event.getResult() == null) {
                return;
            }
            if (event.getResult().getException() == null) {
                return;
            }
            this.mLogger.error((Object)"Error during toolchain job processing:", event.getResult().getException());
        }
    }
}

