/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.external;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.LifecycleException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.DefaultToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import java.io.File;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExternalUltimateCore {
    private UltimateCore mCurrentUltimateInstance;
    private Throwable mUltimateThrowable;
    private volatile boolean mReachedInit;
    private final Semaphore mUltimateExit = new Semaphore(0);
    private final Semaphore mStarterContinue = new Semaphore(0);
    private final IController<RunDefinition> mController;
    protected ManualReleaseToolchainJob mJob;
    private volatile IStatus mReturnStatus;

    public ExternalUltimateCore(IController<RunDefinition> controller) {
        this.mController = controller;
        this.mReachedInit = false;
    }

    public IStatus runUltimate(String threadName) throws Throwable {
        if (this.mCurrentUltimateInstance != null) {
            throw new IllegalStateException("You must call complete() before re-using this instance: " + threadName);
        }
        this.mCurrentUltimateInstance = new UltimateCore();
        this.mUltimateThrowable = null;
        ActualUltimateRunnable runnable = new ActualUltimateRunnable();
        Thread thread = new Thread((Runnable)runnable, threadName);
        thread.start();
        this.mStarterContinue.acquireUninterruptibly();
        if (this.mUltimateThrowable != null) {
            throw this.mUltimateThrowable;
        }
        return this.mReturnStatus;
    }

    public IStatus init(ICore<RunDefinition> core) {
        return this.init(core, null, 0L, null);
    }

    public IStatus init(ICore<RunDefinition> core, File[] inputFiles) {
        return this.init(core, null, 0L, inputFiles);
    }

    public IStatus init(ICore<RunDefinition> core, File settingsFile, long deadline, File[] inputFiles) {
        ILogger logger = null;
        try {
            this.mReachedInit = true;
            if (core == null) {
                Status status = new Status(4, "de.uni_freiburg.informatik.ultimate.core", 4, "Initialization failed", null);
                return status;
            }
            try {
                logger = this.getLogger(core.getCoreLoggingService());
                if (settingsFile != null) {
                    core.loadPreferences(settingsFile.getAbsolutePath(), false);
                }
                this.mJob = this.getToolchainJob(core, this.mController, logger, inputFiles);
                if (deadline > 0L) {
                    this.mJob.setDeadline(deadline);
                }
                this.mJob.schedule();
                this.mJob.join();
                this.mReturnStatus = this.mJob.getResult();
            }
            catch (Throwable e) {
                logger.error((Object)"Exception during toolchain execution.", e);
            }
        }
        finally {
            this.mStarterContinue.release();
            this.mUltimateExit.acquireUninterruptibly();
        }
        return this.mReturnStatus;
    }

    protected ILogger getLogger(ILoggingService loggingService) {
        return loggingService.getControllerLogger();
    }

    protected ManualReleaseToolchainJob getToolchainJob(ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger, File[] inputFiles) {
        return new ManualReleaseToolchainJob("Processing Toolchain", core, controller, logger, inputFiles);
    }

    public void complete() {
        if (this.mJob != null) {
            this.mJob.releaseToolchainManually();
        }
        this.mUltimateExit.release();
    }

    private final class ActualUltimateRunnable
    implements Runnable {
        private ActualUltimateRunnable() {
        }

        @Override
        public void run() {
            try {
                ExternalUltimateCore.this.mCurrentUltimateInstance.startManually(ExternalUltimateCore.this.mController);
            }
            catch (Throwable e) {
                ExternalUltimateCore.this.mUltimateThrowable = e;
            }
            if (!ExternalUltimateCore.this.mReachedInit) {
                if (ExternalUltimateCore.this.mUltimateThrowable == null) {
                    ExternalUltimateCore.this.mUltimateThrowable = new LifecycleException("Ultimate terminated before calling init(...) on ExternalUltimateCore");
                }
                ExternalUltimateCore.this.mStarterContinue.release();
            }
        }
    }

    protected class ManualReleaseToolchainJob
    extends DefaultToolchainJob {
        public ManualReleaseToolchainJob(String name, ICore<RunDefinition> core, IController<RunDefinition> controller, ILogger logger, File[] inputs) {
            super(name, core, controller, logger, inputs);
        }

        @Override
        protected void releaseToolchain() {
        }

        public void releaseToolchainManually() {
            super.releaseToolchain();
        }
    }
}

