/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.ModelContainer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.DuplicateKeyException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.InvalidKeyException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectNotFoundException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.PersistentObjectTypeMismatchException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.StoreObjectException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelrepository.IRepository;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SerializationRepository
implements IRepository<String, ModelContainer> {
    private final File mFileSystemDirectory;
    private final ILogger mLogger;

    public SerializationRepository(File fileSystemDirectory, ILogger logger) {
        assert (logger != null);
        this.mFileSystemDirectory = fileSystemDirectory;
        this.mLogger = logger;
    }

    @Override
    public void dump() {
        this.removeAll(this.listKeys());
    }

    @Override
    public ModelContainer get(String key) throws PersistentObjectNotFoundException, PersistentObjectTypeMismatchException {
        if (this.listKeys().contains(key)) {
            try {
                this.mLogger.debug((Object)"deserializing model");
                Object obj = this.deserialize(key);
                return (ModelContainer)obj;
            }
            catch (FileNotFoundException e) {
                throw new PersistentObjectNotFoundException(e);
            }
            catch (IOException e) {
                throw new PersistentObjectNotFoundException(e);
            }
            catch (ClassNotFoundException e) {
                throw new PersistentObjectTypeMismatchException("A required class used in the stored object graph could not be found. Maybe it has been produced by a plug-in that didn't export this package", e);
            }
        }
        throw new PersistentObjectNotFoundException("No object found using the key: " + key);
    }

    private Object deserialize(String key) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream stream = new ObjectInputStream(new FileInputStream(this.keyToFile(key)));
        Object rtr = stream.readObject();
        stream.close();
        return rtr;
    }

    @Override
    public List<String> listKeys() {
        if (this.mFileSystemDirectory == null || !this.mFileSystemDirectory.exists() || !this.mFileSystemDirectory.isDirectory()) {
            return Collections.emptyList();
        }
        LinkedList<String> keys = new LinkedList<String>();
        String[] stringArray = this.mFileSystemDirectory.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(fileName);
            if (file.getName().endsWith(".ser")) {
                keys.add(file.getName().substring(0, file.getName().length() - 4));
            }
            ++n2;
        }
        return keys;
    }

    @Override
    public boolean remove(String key) {
        File toBeDeleted = new File(this.mFileSystemDirectory + "/" + key + ".ser");
        boolean success = toBeDeleted.delete();
        if (!success && this.listKeys().contains(key)) {
            this.mLogger.warn((Object)("Could not delete " + toBeDeleted.getPath() + " from the file system!"));
            return false;
        }
        this.mLogger.debug((Object)"Now, the model is not in the repository (anymore)");
        return true;
    }

    @Override
    public void removeAll(List<String> keys) {
        for (String string : keys) {
            this.remove(string);
        }
    }

    @Override
    public void add(String key, ModelContainer transientInstance) throws DuplicateKeyException, StoreObjectException {
        if (this.listKeys().contains(key)) {
            throw new DuplicateKeyException("The key: " + key + " is already in use. If you want to " + "replace the stored object, use method addOrReplace instead!");
        }
        this.addOrReplace(key, transientInstance);
    }

    @Override
    public void addOrReplace(String key, ModelContainer transientInstance) throws StoreObjectException {
        try {
            this.serializie(key, transientInstance);
        }
        catch (FileNotFoundException e) {
            throw new InvalidKeyException("invalid key: " + key, e);
        }
        catch (IOException e) {
            this.mLogger.fatal((Object)("Serialization of ModelContainer failed for key " + key + " to file " + this.keyToFile(key)));
            throw new StoreObjectException(e);
        }
    }

    private void serializie(String key, ModelContainer transientInstance) throws FileNotFoundException, IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this.keyToFile(key)));
        stream.writeObject(transientInstance);
        stream.close();
        this.mLogger.debug((Object)"serialized model");
    }

    private File keyToFile(String key) {
        return new File(this.mFileSystemDirectory + File.separator + SerializationRepository.sanitize(key) + ".ser");
    }

    private static String sanitize(String filename) {
        return filename.replaceAll("[\\/:\"*?<>|]+", "_");
    }

    @Override
    public boolean isEmpty() {
        return this.listKeys().isEmpty();
    }
}

