/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.modelwalker.IWalker;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseWalker
implements IWalker {
    protected ILogger mLogger;
    protected List<IObserver> mObservers = new LinkedList<IObserver>();

    protected BaseWalker(ILogger logger) {
        this.mLogger = logger;
    }

    @Override
    public boolean addObserver(IObserver v) {
        return this.mObservers.add(v);
    }

    @Override
    public boolean removeObserver(IObserver observer) {
        return this.mObservers.remove(observer);
    }

    @Override
    public void removeAllObservers() {
        this.mObservers.clear();
    }

    @Override
    public boolean containsObserver(IObserver observer) {
        return this.mObservers.contains(observer);
    }

    @Override
    public void run(IElement inode) throws Throwable {
        if (inode != null) {
            for (IObserver v : this.mObservers) {
                this.runObserver(inode, v);
            }
        }
    }

    private void runObserver(IElement root, IObserver observer) throws Throwable {
        if (observer instanceof IUnmanagedObserver) {
            this.runObserver(root, (IUnmanagedObserver)observer);
        } else {
            this.mLogger.error((Object)"Illegal observer type supplied, aborting...");
        }
    }

    protected abstract void runObserver(IElement var1, IUnmanagedObserver var2) throws Throwable;
}

