/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItemContainer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.util.RcpUtils;
import java.util.Arrays;
import java.util.Collections;

public class CorePreferenceInitializer
extends RcpPreferenceInitializer {
    public static final String PLUGINID = "de.uni_freiburg.informatik.ultimate.core";
    public static final String PLUGINNAME = "UltimateCore";
    public static final String RANDOM_WORKSPACE_CLI_OPTION_NAME = "ultimatedata";
    public static final String RANDOM_WORKSPACE_CLI_OPTION = "-ultimatedata";
    public static final String LABEL_SHOWUSABLEPARSER = "Show usable parsers";
    public static final boolean VALUE_SHOWUSABLEPARSER_DEFAULT = false;
    public static final String LABEL_SHOWRESULTNOTIFIERPOPUP = "Show result in pop-up window after toolchain execution";
    public static final boolean VALUE_SHOWRESULTNOTIFIERPOPUP_DEFAULT = false;
    public static final String LABEL_BENCHMARK = "Generate benchmark results";
    public static final boolean VALUE_BENCHMARK_DEFAULT = true;
    public static final String LABEL_LONG_RESULT = "Show long description of results";
    public static final boolean VALUE_LONG_RESULT_DEFAULT = true;
    public static final String LABEL_LOG4J_PATTERN = "Logger pattern";
    public static final String VALUE_LOG4J_PATTERN = "[%d{ISO8601} %-5p L%-5.5L %20.20C{1}]: %m%n";
    public static final String LABEL_LOG4J_CONTROLLER_PATTERN = "UI logger pattern";
    public static final String VALUE_LOG4J_CONTROLLER_PATTERN = "%m%n";
    public static final String DESC_LOGFILE = "The basic preferences for creating a log file (like enabled, name, directory)";
    public static final String LABEL_LOGFILE = "Create a Logfile";
    public static final boolean VALUE_LOGFILE = false;
    public static final String LABEL_APPEXLOGFILE = "Append to exisiting log file";
    public static final boolean VALUE_APPEXLOGFILE = false;
    public static final String LABEL_LOGFILE_NAME = "Name of the log file";
    public static final String VALUE_LOGFILE_NAME = "ultimate.log";
    public static final String LABEL_LOGFILE_DIR = "Directory (default: instance location)";
    public static final String VALUE_LOGFILE_DIR;
    public static final String LABEL_COLOR_DEBUG = "Debug log message color";
    public static final String DEFAULT_VALUE_COLOR_DEBUG = "223,223,223";
    public static final String LABEL_COLOR_INFO = "Info log message color";
    public static final String DEFAULT_VALUE_COLOR_INFO = "255,255,255";
    public static final String LABEL_COLOR_WARNING = "Warning log message color";
    public static final String DEFAULT_VALUE_COLOR_WARNING = "223,223,95";
    public static final String LABEL_COLOR_ERROR = "Error log message color";
    public static final String DEFAULT_VALUE_COLOR_ERROR = "255,85,85";
    public static final String LABEL_COLOR_FATAL = "Fatal log message color";
    public static final String DEFAULT_VALUE_COLOR_FATAL = "255,85,85";
    public static final String LABEL_DROP_MODELS = "Drop models when Ultimate exits";
    public static final boolean VALUE_DROP_MODELS = true;
    public static final String LABEL_TMP_DIRECTORY = "Repository directory";
    public static final String VALUE_TMP_DIRECTORY;
    public static final String LABEL_ROOT_PREF = "Root log level";
    public static final String LABEL_TOOLS_PREF = "Log level for external tools";
    public static final String LABEL_CORE_PREF = "Log level for core plugin";
    public static final String LABEL_CONTROLLER_PREF = "Log level for controller plugin";
    public static final String LABEL_PLUGINS_PREF = "Log level for plugins";
    private static final String LABEL_LOGLEVEL_PLUGIN_SPECIFIC = "Log level for";
    public static final String LABEL_LOGLEVEL_EXTERNAL_TOOL_SPECIFIC = "Log level for specific external tool";
    public static final String LABEL_LOGLEVEL_CLAZZ_SPECIFIC = "Log level for class";
    public static final String DEFAULT_VALUE_ROOT_PREF = "DEBUG";
    public static final String DEFAULT_VALUE_TOOLS_PREF = "WARN";
    public static final String DEFAULT_VALUE_CORE_PREF = "INFO";
    public static final String DEFAULT_VALUE_CONTROLLER_PREF = "INFO";
    public static final String DEFAULT_VALUE_PLUGINS_PREF = "INFO";
    public static final String VALUE_FATAL_LOGGING_PREF = "FATAL";
    public static final String VALUE_ERROR_LOGGING_PREF = "ERROR";
    public static final String VALUE_WARN_LOGGING_PREF = "WARN";
    public static final String VALUE_INFO_LOGGING_PREF = "INFO";
    public static final String VALUE_DEBUG_LOGGING_PREF = "DEBUG";
    public static final String VALUE_TRACE_LOGGING_PREF = "TRACE";
    public static final String VALUE_DELIMITER_LOGGING_PREF = ";";
    public static final String[] VALUE_VALID_LOG_LEVELS;
    public static final String LABEL_TIMEOUT = "Toolchain timeout in seconds";
    private static final int VALUE_TIMEOUT = 0;
    private static final String DESC_TIMEOUT = "Specify the time in seconds after which Ultimate will terminate due to a timeout. The value has to be larger or equal to 0. A value of 0 disables the timeout.";
    public static final String INVALID_LOGLEVEL;
    public static final String INVALID_ENTRY = "Entry has to be of the form: \"<plug-in id>=<log level>\"";
    public static final String INVALID_TOOL_ENTRY = "Entry has to be of the form: \"<tool id>=<log level>\"";
    public static final String INVALID_WITNESSVERIFCATION_SETTING = "You must enable generation and writing of witness results before you can verify them";
    public static final String LOGGING_PREFERENCES_DESC = "Specify log levels for the certail plugins.\nNote that there is a hierarchy and specifying a less strict level for children will have no effect";
    public static final String ALL_PLUGINS_PRESENT = "All entered plugins are in fact present!";
    public static final String PLUGINS_NOT_PRESENT = "The following plugins are not present at the moment: \n";
    public static final String EMPTY_STRING = "";
    public static final String LABEL_PRINT_STATISTICS_RESULTS = "Print statistic results";
    private static final boolean VALUE_PRINT_STATISTICS_RESULTS = true;
    private static final String DESC_PRINT_STATISTICS_RESULTS = "Print results of type StatisticsResult";

    static {
        VALUE_VALID_LOG_LEVELS = new String[]{"DEBUG", VALUE_ERROR_LOGGING_PREF, VALUE_FATAL_LOGGING_PREF, "INFO", VALUE_TRACE_LOGGING_PREF, "WARN"};
        INVALID_LOGLEVEL = "Valid levels: " + Arrays.toString(VALUE_VALID_LOG_LEVELS);
        String tmpDir = System.getProperty("java.io.tmpdir");
        String instLoc = RcpUtils.getInstanceLocationPath();
        VALUE_LOGFILE_DIR = instLoc == null ? tmpDir : instLoc;
        VALUE_TMP_DIRECTORY = tmpDir;
    }

    public CorePreferenceInitializer() {
        super(PLUGINID, "Core");
    }

    public static String getLabelLogLevelForSpecificPlugin(String pluginId) {
        return "Log level for " + pluginId;
    }

    public static String getPluginIdFromLabelLogLevelForSpecificPlugin(String settingsLabel) {
        return settingsLabel.substring(LABEL_LOGLEVEL_PLUGIN_SPECIFIC.length() + 1);
    }

    @Override
    protected BaseUltimatePreferenceItem[] initDefaultPreferences() {
        UltimatePreferenceItemContainer pluginSpecificLevels = new UltimatePreferenceItemContainer("Plugin-specific log levels");
        Object[] plugins = UltimateCore.getPluginNames();
        Arrays.sort(plugins);
        int i = 0;
        while (i < plugins.length) {
            pluginSpecificLevels.addItem((BaseUltimatePreferenceItem)new UltimatePreferenceItem(CorePreferenceInitializer.getLabelLogLevelForSpecificPlugin((String)plugins[i]), (Object)InheritableLogLevel.INHERITED, PreferenceType.Combo, (Object[])InheritableLogLevel.values()));
            ++i;
        }
        return new BaseUltimatePreferenceItem[]{pluginSpecificLevels, new UltimatePreferenceItem(LABEL_SHOWUSABLEPARSER, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_SHOWRESULTNOTIFIERPOPUP, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_BENCHMARK, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_LONG_RESULT, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_PRINT_STATISTICS_RESULTS, (Object)true, DESC_PRINT_STATISTICS_RESULTS, PreferenceType.Boolean), new UltimatePreferenceItem(DESC_LOGFILE, null, PreferenceType.Label), new UltimatePreferenceItem(LABEL_LOGFILE, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_APPEXLOGFILE, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_LOGFILE_NAME, (Object)VALUE_LOGFILE_NAME, PreferenceType.String), new UltimatePreferenceItem(LABEL_LOGFILE_DIR, (Object)VALUE_LOGFILE_DIR, PreferenceType.Directory), new UltimatePreferenceItem(LABEL_DROP_MODELS, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_TMP_DIRECTORY, (Object)VALUE_TMP_DIRECTORY, PreferenceType.Directory), new UltimatePreferenceItem(LABEL_LOG4J_PATTERN, (Object)VALUE_LOG4J_PATTERN, PreferenceType.String), new UltimatePreferenceItem(LABEL_LOG4J_CONTROLLER_PATTERN, (Object)VALUE_LOG4J_CONTROLLER_PATTERN, PreferenceType.String), new UltimatePreferenceItem(LOGGING_PREFERENCES_DESC, null, PreferenceType.Label), new UltimatePreferenceItem(LABEL_ROOT_PREF, (Object)"DEBUG", PreferenceType.String, null, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new LogLevelValidator()), new UltimatePreferenceItem(LABEL_CORE_PREF, (Object)"INFO", PreferenceType.String, null, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new LogLevelValidator()), new UltimatePreferenceItem(LABEL_CONTROLLER_PREF, (Object)"INFO", PreferenceType.String, null, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new LogLevelValidator()), new UltimatePreferenceItem(LABEL_PLUGINS_PREF, (Object)"INFO", PreferenceType.String, null, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new LogLevelValidator()), new UltimatePreferenceItem(LABEL_TOOLS_PREF, (Object)"WARN", PreferenceType.String, null, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new LogLevelValidator()), new UltimatePreferenceItem(LABEL_LOGLEVEL_EXTERNAL_TOOL_SPECIFIC, Collections.emptyMap(), PreferenceType.KeyValue), new UltimatePreferenceItem(LABEL_LOGLEVEL_CLAZZ_SPECIFIC, Collections.emptyMap(), PreferenceType.KeyValue), new UltimatePreferenceItem(LABEL_COLOR_DEBUG, (Object)DEFAULT_VALUE_COLOR_DEBUG, PreferenceType.Color), new UltimatePreferenceItem(LABEL_COLOR_INFO, (Object)DEFAULT_VALUE_COLOR_INFO, PreferenceType.Color), new UltimatePreferenceItem(LABEL_COLOR_WARNING, (Object)DEFAULT_VALUE_COLOR_WARNING, PreferenceType.Color), new UltimatePreferenceItem(LABEL_COLOR_ERROR, (Object)"255,85,85", PreferenceType.Color), new UltimatePreferenceItem(LABEL_COLOR_FATAL, (Object)"255,85,85", PreferenceType.Color), new UltimatePreferenceItem(LABEL_TIMEOUT, (Object)0, DESC_TIMEOUT, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, Integer.MAX_VALUE))};
    }

    public static IPreferenceProvider getPreferenceProvider(IUltimateServiceProvider services) {
        return services.getPreferenceProvider(PLUGINID);
    }

    public static enum InheritableLogLevel {
        OFF,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL,
        INHERITED;

    }

    private static final class LogLevelValidator
    implements UltimatePreferenceItem.IUltimatePreferenceItemValidator<String> {
        private LogLevelValidator() {
        }

        public boolean isValid(String value) {
            String upper = value.toUpperCase();
            String[] stringArray = VALUE_VALID_LOG_LEVELS;
            int n = VALUE_VALID_LOG_LEVELS.length;
            int n2 = 0;
            while (n2 < n) {
                String validValue = stringArray[n2];
                if (validValue.equals(upper)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getInvalidValueErrorMessage(String value) {
            return INVALID_LOGLEVEL;
        }
    }

    public static enum WitnessVerifierType {
        CPACHECKER;

    }
}

