/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ModelTranslationContainer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.List;

public class BacktranslationService
implements IStorable,
IBacktranslationService {
    private static final String sKey = "BacktranslationService";
    private ModelTranslationContainer mTranslatorSequence = new ModelTranslationContainer();

    public <STE, TTE, SE, TE, SVL, TVL> void addTranslator(ITranslator<STE, TTE, SE, TE, SVL, TVL> translator) {
        this.mTranslatorSequence.addTranslator(translator);
    }

    public <SE, TE> TE translateExpression(SE expression, Class<SE> clazz) {
        return this.mTranslatorSequence.translateExpression(expression, clazz);
    }

    public <STE> List<?> translateTrace(List<STE> trace, Class<STE> clazz) {
        return this.mTranslatorSequence.translateTrace(trace, clazz);
    }

    public <STE, SE> IProgramExecution<?, ?> translateProgramExecution(IProgramExecution<STE, SE> programExecution) {
        return this.mTranslatorSequence.translateProgramExecution(programExecution);
    }

    public <SE> IProgramExecution.ProgramState<?> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        return this.mTranslatorSequence.translateProgramState(programState);
    }

    public <SE> String translateProgramStateToString(IProgramExecution.ProgramState<SE> programState) {
        return this.mTranslatorSequence.translateProgramStateToString(programState);
    }

    public <STE, SE> IBacktranslatedCFG<?, ?> translateCFG(IBacktranslatedCFG<?, STE> cfg) {
        return this.mTranslatorSequence.translateCFG(cfg);
    }

    public <SE> String translateExpressionToString(SE expression, Class<SE> clazz) {
        return this.mTranslatorSequence.translateExpressionToString(expression, clazz);
    }

    public <STE> List<String> translateTraceToHumanReadableString(List<STE> trace, Class<STE> clazz) {
        return this.mTranslatorSequence.translateTraceToHumanReadableString(trace, clazz);
    }

    public IBacktranslationService getTranslationServiceCopy() {
        return this.mTranslatorSequence.getTranslationServiceCopy();
    }

    static IBacktranslationService getService(IToolchainStorage storage) {
        assert (storage != null);
        IStorable rtr = storage.getStorable(sKey);
        if (rtr == null) {
            rtr = new BacktranslationService();
            storage.putStorable(sKey, rtr);
        }
        return (IBacktranslationService)rtr;
    }

    public String toString() {
        return this.mTranslatorSequence.toString();
    }

    public void destroy() {
        this.mTranslatorSequence = null;
    }
}

