/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.IServiceFactoryFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;

public class GenericServiceProvider
implements IStorable {
    private static final String KEY = "GenericServiceProvider";
    private final IServiceFactoryFactory mFactory;

    public GenericServiceProvider(IServiceFactoryFactory factory) {
        this.mFactory = factory;
    }

    static <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(ToolchainStorage toolchainStorage, Class<K> serviceType) {
        assert (toolchainStorage != null);
        IStorable storable = toolchainStorage.getStorable(serviceType.getName());
        if (storable != null) {
            return (T)((IService)storable);
        }
        GenericServiceProvider instance = (GenericServiceProvider)toolchainStorage.getStorable(KEY);
        IService rtrValue = (IService)instance.mFactory.createService(serviceType, toolchainStorage, toolchainStorage);
        if (rtrValue != null) {
            toolchainStorage.putStorable(serviceType.getName(), (IStorable)rtrValue);
        }
        return (T)rtrValue;
    }

    public static String getServiceKey() {
        return KEY;
    }

    public void destroy() {
    }
}

