/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class Log4J2Wrapper
implements ILogger {
    private static final Level[] sILoggerLevelToLog4jLevel = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.OFF};
    private static final String FQCN = Log4J2Wrapper.class.getName();
    private final ExtendedLoggerWrapper mLogger;

    public Log4J2Wrapper(Logger logger) {
        this.mLogger = new ExtendedLoggerWrapper((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
    }

    Logger getBacking() {
        return this.mLogger;
    }

    public void fatal(Object msg, Throwable t) {
        this.mLogger.logIfEnabled(FQCN, Level.FATAL, null, msg, t);
    }

    public void error(Object msg, Throwable t) {
        this.mLogger.logIfEnabled(FQCN, Level.ERROR, null, msg, t);
    }

    public void log(ILogger.LogLevel level, String msg) {
        this.mLogger.logIfEnabled(FQCN, Log4J2Wrapper.translateLevel(level), null, msg);
    }

    public int hashCode() {
        return Objects.hash(this.mLogger);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Log4J2Wrapper other = (Log4J2Wrapper)obj;
        return Objects.equals(this.mLogger, other.mLogger);
    }

    public String toString() {
        return "[" + this.hashCode() + "][" + this.getBacking().getLevel() + "] " + this.getBacking().getName();
    }

    public void setLevel(ILogger.LogLevel level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.mLogger.getName());
        loggerConfig.setLevel(Log4J2Wrapper.translateLevel(level));
    }

    public boolean isLogLevelEnabled(ILogger.LogLevel level) {
        return this.mLogger.isEnabled(Log4J2Wrapper.translateLevel(level));
    }

    private static Level translateLevel(ILogger.LogLevel level) {
        if (level.ordinal() >= sILoggerLevelToLog4jLevel.length) {
            throw new UnsupportedOperationException("Unknown LogLevel " + level);
        }
        return sILoggerLevelToLog4jLevel[level.ordinal()];
    }
}

