/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.LogfileException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.Log4JWrapper;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class Log4JLoggingService
implements IStorable,
ILoggingService {
    private static final String APPENDER_NAME_CONSOLE = "ConsoleAppender";
    private static final String APPENDER_NAME_LOGFILE = "LogfileAppender";
    private static final String APPENDER_NAME_CONTROLLER = "ControllerAppender";
    private static final String LOGGER_NAME_CONTROLLER = "controller";
    private static final String LOGGER_NAME_NONCONTROLLER = "noncontroller";
    private static final String LOGGER_NAME_CORE = "noncontroller.de.uni_freiburg.informatik.ultimate.core";
    private static final String LOGGER_NAME_TOOLS = "noncontroller.tools";
    private static final String LOGGER_NAME_PLUGINS = "noncontroller.plugins";
    private static final String LOGGER_NAME_PREFIX_TOOLS = "external.";
    private static final String STORE_KEY = "LoggingService";
    private final RcpPreferenceProvider mPreferenceStore = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
    private final IEclipsePreferences.IPreferenceChangeListener mRefreshingListener;
    private final Set<Appender> mRootAppenders = new HashSet<Appender>();
    private final Set<Appender> mControllerAppenders = new HashSet<Appender>();
    private String mCurrentControllerName;
    private boolean mIsAttached;
    private Map<String, Level> mSettingsLogger2LogLevel;
    private Set<String> mRelevantSettings;
    private List<String> mPluginSpecificLogLevelSettingLabels;

    private Log4JLoggingService() {
        this.resetLoggerLevels();
        this.reinitializeDefaultAppenders();
        this.reattachAppenders();
        this.mRefreshingListener = new RefreshingPreferenceChangeListener();
        this.mPreferenceStore.addPreferenceChangeListener(this.mRefreshingListener);
        this.mIsAttached = true;
    }

    public void reloadLoggers() {
        this.resetLoggerLevels();
        this.reinitializeDefaultAppenders();
        this.reattachAppenders();
        this.getLogger("de.uni_freiburg.informatik.ultimate.core").debug((Object)"Logger refreshed");
    }

    private void reinitializeDefaultAppenders() {
        this.mRootAppenders.clear();
        this.mControllerAppenders.clear();
        PatternLayout mainLayout = new PatternLayout(this.mPreferenceStore.getString("Logger pattern"));
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)mainLayout);
        consoleAppender.setName(APPENDER_NAME_CONSOLE);
        this.mRootAppenders.add((Appender)consoleAppender);
        PatternLayout controllerLayout = new PatternLayout(this.mPreferenceStore.getString("UI logger pattern"));
        ConsoleAppender controllerAppender = new ConsoleAppender((Layout)controllerLayout);
        controllerAppender.setName(APPENDER_NAME_CONTROLLER);
        this.mControllerAppenders.add((Appender)controllerAppender);
        if (this.mPreferenceStore.getBoolean("Create a Logfile")) {
            String logName = this.mPreferenceStore.getString("Name of the log file");
            String logDir = this.mPreferenceStore.getString("Directory (default: instance location)");
            String logFilePattern = this.mPreferenceStore.getString("Logger pattern");
            boolean append = this.mPreferenceStore.getBoolean("Append to exisiting log file");
            String absolutePath = String.valueOf(logDir) + File.separator + logName + ".log";
            PatternLayout logFileLayout = new PatternLayout(logFilePattern);
            try {
                FileAppender appender = new FileAppender((Layout)logFileLayout, absolutePath, append);
                appender.setName(APPENDER_NAME_LOGFILE);
                this.mRootAppenders.add((Appender)appender);
                this.mControllerAppenders.add((Appender)appender);
            }
            catch (IOException e) {
                throw new LogfileException(e);
            }
        }
    }

    private void reattachAppenders() {
        Log4JLoggingService.reattachAppenders(Logger.getLogger((String)LOGGER_NAME_NONCONTROLLER), this.mRootAppenders);
        Log4JLoggingService.reattachAppenders(Logger.getLogger((String)LOGGER_NAME_CONTROLLER), this.mControllerAppenders);
    }

    private static void reattachAppenders(Logger logger, Collection<Appender> appenders) {
        for (Appender appender : appenders) {
            logger.removeAppender(appender.getName());
            logger.addAppender(appender);
        }
    }

    private void resetLoggerLevels() {
        Logger rootLogger = Log4JLoggingService.getLog4JRootLogger();
        Level rootLevel = this.getLogLevelPreference("Root log level");
        rootLogger.setLevel(rootLevel);
        this.mSettingsLogger2LogLevel = this.getSettingsLogger2Level();
        LoggerRepository repo = rootLogger.getLoggerRepository();
        for (Map.Entry<String, Level> entry : this.mSettingsLogger2LogLevel.entrySet()) {
            repo.getLogger(entry.getKey()).setLevel(entry.getValue());
        }
    }

    private Map<String, Level> getSettingsLogger2Level() {
        HashMap<String, Level> rtr = new HashMap<String, Level>();
        rtr.put(LOGGER_NAME_CONTROLLER, this.getLogLevelPreference("Log level for controller plugin"));
        rtr.put(LOGGER_NAME_NONCONTROLLER, this.getLogLevelPreference("Root log level"));
        rtr.put(LOGGER_NAME_PLUGINS, this.getLogLevelPreference("Log level for plugins"));
        rtr.put(LOGGER_NAME_TOOLS, this.getLogLevelPreference("Log level for external tools"));
        rtr.put(LOGGER_NAME_CORE, this.getLogLevelPreference("Log level for core plugin"));
        Map<String, Level> pluginLevels = this.getSettingPluginSpecificLogLevels();
        for (Map.Entry<String, Level> entry : pluginLevels.entrySet()) {
            rtr.put(Log4JLoggingService.getPluginLoggerName(entry.getKey()), entry.getValue());
        }
        Map<String, Level> toolLevels = this.getSettingToolSpecificLogLevels("Log level for specific external tool");
        for (Map.Entry<String, Level> entry : toolLevels.entrySet()) {
            rtr.put(Log4JLoggingService.getToolLoggerName(entry.getKey()), entry.getValue());
        }
        Map<String, Level> clazzLevels = this.getSettingToolSpecificLogLevels("Log level for class");
        for (Map.Entry<String, Level> entry : clazzLevels.entrySet()) {
            rtr.put(Log4JLoggingService.getPluginLoggerName(entry.getKey()), entry.getValue());
        }
        return rtr;
    }

    private Level getLogLevelPreference(String label) {
        return Level.toLevel((String)this.mPreferenceStore.getString(label));
    }

    private static boolean isExternalTool(String id) {
        return id.startsWith(LOGGER_NAME_PREFIX_TOOLS);
    }

    private Logger lookupLoggerInHierarchy(String id) {
        String actualLoggerName = this.getActualLoggerName(id);
        Logger logger = Logger.getLogger((String)actualLoggerName);
        Level logLevel = this.mSettingsLogger2LogLevel.get(actualLoggerName);
        logger.setLevel(logLevel);
        return logger;
    }

    private String getActualLoggerName(String id) {
        if (id.equals("de.uni_freiburg.informatik.ultimate.core")) {
            return LOGGER_NAME_CORE;
        }
        assert (this.mCurrentControllerName != null) : "There is no controller";
        if (id.equals(this.mCurrentControllerName) || id.equals(LOGGER_NAME_CONTROLLER)) {
            return LOGGER_NAME_CONTROLLER;
        }
        if (Log4JLoggingService.isExternalTool(id)) {
            return Log4JLoggingService.getToolLoggerName(id);
        }
        return Log4JLoggingService.getPluginLoggerName(id);
    }

    private static String getToolLoggerName(String toolId) {
        return "noncontroller.tools.external." + toolId;
    }

    private static String getPluginLoggerName(String plugin) {
        return "noncontroller.plugins." + plugin;
    }

    public void setCurrentControllerID(String name) {
        this.mCurrentControllerName = name;
    }

    public void destroy() {
        this.mPreferenceStore.removePreferenceChangeListener(this.mRefreshingListener);
        this.mIsAttached = false;
    }

    public ILogger getLogger(String pluginId) {
        return Log4JLoggingService.wrapLogger(this.lookupLoggerInHierarchy(pluginId));
    }

    public ILogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public ILogger getLoggerForExternalTool(String id) {
        return this.getLogger(LOGGER_NAME_PREFIX_TOOLS + id);
    }

    public ILogger getControllerLogger() {
        return this.getLogger(LOGGER_NAME_CONTROLLER);
    }

    private static Logger getLog4JRootLogger() {
        return Logger.getRootLogger();
    }

    public void addWriter(Writer writer, String logPattern) {
        Log4JAppenderWrapper appender = new Log4JAppenderWrapper(writer, logPattern);
        if (!this.mRootAppenders.add((Appender)appender)) {
            return;
        }
        Log4JLoggingService.getLog4JRootLogger().addAppender((Appender)appender);
    }

    public void removeWriter(Writer writer) {
        Log4JAppenderWrapper appender = new Log4JAppenderWrapper(writer, null);
        this.mRootAppenders.remove((Object)appender);
        Log4JLoggingService.getLog4JRootLogger().removeAppender((Appender)appender);
    }

    private Map<String, Level> getSettingPluginSpecificLogLevels() {
        LinkedHashMap<String, Level> rtr = new LinkedHashMap<String, Level>();
        for (String key : this.getPluginSpecificLogLevelSettingLabels()) {
            CorePreferenceInitializer.InheritableLogLevel value = this.mPreferenceStore.getEnum(key, CorePreferenceInitializer.InheritableLogLevel.class);
            if (value == CorePreferenceInitializer.InheritableLogLevel.INHERITED) continue;
            rtr.put(CorePreferenceInitializer.getPluginIdFromLabelLogLevelForSpecificPlugin(key), Level.toLevel((String)value.toString()));
        }
        return rtr;
    }

    private Map<String, Level> getSettingToolSpecificLogLevels(String settingsLabel) {
        Map map = KeyValueUtil.toMap((String)this.mPreferenceStore.getString(settingsLabel));
        LinkedHashMap<String, Level> rtr = new LinkedHashMap<String, Level>();
        for (Map.Entry entry : map.entrySet()) {
            rtr.put((String)entry.getKey(), Level.toLevel((String)((String)entry.getValue())));
        }
        return rtr;
    }

    private static ILogger wrapLogger(Logger logger) {
        return new Log4JWrapper(logger);
    }

    public Object getBacking(ILogger logger, Class<?> backingType) {
        if (logger == null || backingType == null) {
            return null;
        }
        if (Logger.class.isAssignableFrom(backingType) && logger instanceof Log4JWrapper) {
            Log4JWrapper wrappedLogger = (Log4JWrapper)logger;
            return wrappedLogger.getBacking();
        }
        return null;
    }

    static Log4JLoggingService getService(IToolchainStorage storage) {
        assert (storage != null);
        IStorable rtr = storage.getStorable(STORE_KEY);
        if (rtr == null) {
            rtr = new Log4JLoggingService();
            storage.putStorable(STORE_KEY, rtr);
        }
        return (Log4JLoggingService)rtr;
    }

    public void store(IToolchainStorage storage) {
        storage.putStorable(STORE_KEY, (IStorable)this);
        if (!this.mIsAttached) {
            this.mPreferenceStore.addPreferenceChangeListener(this.mRefreshingListener);
            this.reloadLoggers();
        }
    }

    public void setLogLevel(Class<?> clazz, ILogger.LogLevel level) {
        this.setLogLevel(clazz.getName(), level);
    }

    public void setLogLevel(String id, ILogger.LogLevel level) {
        this.mSettingsLogger2LogLevel.put(Log4JLoggingService.getPluginLoggerName(id), Level.toLevel((String)level.toString()));
    }

    private List<String> getPluginSpecificLogLevelSettingLabels() {
        if (this.mPluginSpecificLogLevelSettingLabels == null) {
            this.mPluginSpecificLogLevelSettingLabels = Arrays.stream(UltimateCore.getPluginNames()).map(CorePreferenceInitializer::getLabelLogLevelForSpecificPlugin).collect(Collectors.toList());
        }
        return this.mPluginSpecificLogLevelSettingLabels;
    }

    private Set<String> getRelevantSettings() {
        if (this.mRelevantSettings == null) {
            this.mRelevantSettings = new HashSet<String>();
            this.mRelevantSettings.addAll(this.getPluginSpecificLogLevelSettingLabels());
            this.mRelevantSettings.add("Logger pattern");
            this.mRelevantSettings.add("Create a Logfile");
            this.mRelevantSettings.add("Name of the log file");
            this.mRelevantSettings.add("Directory (default: instance location)");
            this.mRelevantSettings.add("Append to exisiting log file");
            this.mRelevantSettings.add("Root log level");
            this.mRelevantSettings.add("Log level for external tools");
            this.mRelevantSettings.add("Log level for core plugin");
            this.mRelevantSettings.add("Log level for controller plugin");
            this.mRelevantSettings.add("Log level for plugins");
            this.mRelevantSettings.add("Debug log message color");
            this.mRelevantSettings.add("Info log message color");
            this.mRelevantSettings.add("Warning log message color");
            this.mRelevantSettings.add("Error log message color");
            this.mRelevantSettings.add("Fatal log message color");
            this.mRelevantSettings.add("UI logger pattern");
            this.mRelevantSettings.add("Log level for class");
            this.mRelevantSettings.add("Log level for specific external tool");
        }
        return this.mRelevantSettings;
    }

    private static final class Log4JAppenderWrapper
    extends WriterAppender {
        private final Writer mWriter;

        private Log4JAppenderWrapper(Writer writer, String pattern) {
            this.mWriter = writer;
            this.setWriter(writer);
            if (pattern != null) {
                this.setLayout((Layout)new PatternLayout(pattern));
            }
            this.setImmediateFlush(true);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.mWriter == null ? 0 : this.mWriter.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Log4JAppenderWrapper other = (Log4JAppenderWrapper)((Object)obj);
            return !(this.mWriter == null ? other.mWriter != null : !this.mWriter.equals(other.mWriter));
        }
    }

    private final class RefreshingPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private RefreshingPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            String ek = event.getKey();
            if (!Log4JLoggingService.this.getRelevantSettings().contains(ek)) {
                return;
            }
            Log4JLoggingService.this.reloadLoggers();
        }
    }
}

