/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Objects;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Log4JWrapper
implements ILogger {
    private static final Level[] sILoggerLevelToLog4jLevel = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.OFF};
    private static final String FQCN = ILogger.class.getName();
    private final Logger mLogger;

    public Log4JWrapper(Logger logger) {
        this.mLogger = logger;
    }

    Logger getBacking() {
        return this.mLogger;
    }

    public void fatal(Object msg, Throwable t) {
        this.mLogger.log(FQCN, (Priority)Level.FATAL, msg, t);
    }

    public void error(Object msg, Throwable t) {
        this.mLogger.log(FQCN, (Priority)Level.ERROR, msg, t);
    }

    public void log(ILogger.LogLevel level, String msg) {
        this.mLogger.log(FQCN, (Priority)Log4JWrapper.translateLevel(level), (Object)msg, null);
    }

    public int hashCode() {
        return Objects.hash(this.mLogger);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Log4JWrapper other = (Log4JWrapper)obj;
        return Objects.equals(this.mLogger, other.mLogger);
    }

    public String toString() {
        return "[" + this.hashCode() + "][" + this.getBacking().getLevel() + "] " + this.getBacking().getName();
    }

    public void setLevel(ILogger.LogLevel level) {
        this.mLogger.setLevel(Log4JWrapper.translateLevel(level));
    }

    public boolean isLogLevelEnabled(ILogger.LogLevel level) {
        return this.mLogger.isEnabledFor((Priority)Log4JWrapper.translateLevel(level));
    }

    private static Level translateLevel(ILogger.LogLevel level) {
        if (level.ordinal() >= sILoggerLevelToLog4jLevel.length) {
            throw new UnsupportedOperationException("Unknown LogLevel " + level);
        }
        return sILoggerLevelToLog4jLevel[level.ordinal()];
    }
}

