/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Stack;

class ModelTranslationContainer
implements IBacktranslationService {
    private final ArrayDeque<ITranslator<?, ?, ?, ?, ?, ?>> mTranslationSequence;

    protected ModelTranslationContainer() {
        this.mTranslationSequence = new ArrayDeque();
    }

    protected ModelTranslationContainer(ModelTranslationContainer other) {
        this.mTranslationSequence = new ArrayDeque(other.mTranslationSequence);
    }

    public <STE, TTE, SE, TE, SVL, TVL> void addTranslator(ITranslator<STE, TTE, SE, TE, SVL, TVL> translator) {
        ITranslator<?, ?, ?, ?, ?, ?> last;
        if (this.mTranslationSequence.size() > 0 && !ModelTranslationContainer.isAllowedNext(last = this.mTranslationSequence.getLast(), translator)) {
            throw new IllegalArgumentException("The supplied ITranslator is not compatible with the existing ones. It has to be compatible with " + last + ", but it is " + translator);
        }
        this.mTranslationSequence.addLast(translator);
    }

    private static boolean isAllowedNext(ITranslator<?, ?, ?, ?, ?, ?> current, ITranslator<?, ?, ?, ?, ?, ?> next) {
        return current.getSourceExpressionClass() == next.getTargetExpressionClass() && current.getSourceTraceElementClass() == next.getTargetTraceElementClass();
    }

    public <SE, TE> TE translateExpression(SE expression, Class<SE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?>> current = this.prepareTranslatorStackAndCheckSourceExpression(clazz);
        return this.translateExpression(current, expression);
    }

    public <SE> String translateExpressionToString(SE expression, Class<SE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?>> current = this.prepareTranslatorStackAndCheckSourceExpression(clazz);
        ITranslator last = (ITranslator)current.firstElement();
        return ModelTranslationContainer.translateExpressionToString(this.translateExpression(current, expression), last);
    }

    private static <TE> String translateExpressionToString(TE expression, ITranslator<?, ?, ?, ?, ?, ?> trans) {
        ITranslator<?, ?, ?, ?, ?, ?> last = trans;
        return last.targetExpressionToString(expression);
    }

    private <TE, SE> TE translateExpression(Stack<ITranslator<?, ?, ?, ?, ?, ?>> remaining, SE expression) {
        if (remaining.isEmpty()) {
            return (TE)expression;
        }
        ITranslator<?, ?, ?, ?, ?, ?> tmp = remaining.pop();
        return this.translateExpression(remaining, tmp.translateExpression(expression));
    }

    public <STE> List<?> translateTrace(List<STE> trace, Class<STE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?>> current = this.prepareTranslatorStackAndCheckSourceTraceElement(clazz);
        return this.translateTrace(current, trace);
    }

    public <STE> List<String> translateTraceToHumanReadableString(List<STE> trace, Class<STE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?>> current = this.prepareTranslatorStackAndCheckSourceTraceElement(clazz);
        ITranslator last = (ITranslator)current.firstElement();
        return ModelTranslationContainer.translateTraceToString(this.translateTrace(current, trace), last);
    }

    private static <TTE> List<String> translateTraceToString(List<TTE> trace, ITranslator<?, ?, ?, ?, ?, ?> trans) {
        ITranslator<?, ?, ?, ?, ?, ?> last = trans;
        return last.targetTraceToString(trace);
    }

    private <STE> Stack<ITranslator<?, ?, ?, ?, ?, ?>> prepareTranslatorStackAndCheckSourceTraceElement(Class<STE> classOfSourceElement) {
        Stack current = new Stack();
        boolean canTranslate = false;
        for (ITranslator<?, ?, ?, ?, ?, ?> trans : this.mTranslationSequence) {
            current.push(trans);
            if (!trans.getSourceTraceElementClass().isAssignableFrom(classOfSourceElement)) continue;
            canTranslate = true;
        }
        if (!canTranslate) {
            throw new IllegalArgumentException("You cannot translate " + classOfSourceElement.getSimpleName() + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)current.peek()).getSourceTraceElementClass().isAssignableFrom(classOfSourceElement)) {
            throw new IllegalArgumentException("You cannot translate " + classOfSourceElement.getSimpleName() + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return current;
    }

    private <STE> Stack<ITranslator<?, ?, ?, ?, ?, ?>> prepareTranslatorStackAndCheckSourceExpression(Class<STE> classOfSourceExpression) {
        Stack current = new Stack();
        boolean canTranslate = false;
        for (ITranslator<?, ?, ?, ?, ?, ?> trans : this.mTranslationSequence) {
            current.push(trans);
            if (!trans.getSourceExpressionClass().isAssignableFrom(classOfSourceExpression)) continue;
            canTranslate = true;
        }
        if (!canTranslate) {
            throw new IllegalArgumentException("You cannot translate " + classOfSourceExpression.getSimpleName() + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)current.peek()).getSourceExpressionClass().isAssignableFrom(classOfSourceExpression)) {
            throw new IllegalArgumentException("You cannot translate " + classOfSourceExpression.getSimpleName() + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return current;
    }

    private <TTE, STE> List<TTE> translateTrace(Stack<ITranslator<?, ?, ?, ?, ?, ?>> remaining, List<STE> trace) {
        if (remaining.isEmpty()) {
            return trace;
        }
        ITranslator<?, ?, ?, ?, ?, ?> translator = remaining.pop();
        return this.translateTrace(remaining, translator.translateTrace(trace));
    }

    public <STE, SE> IProgramExecution<?, ?> translateProgramExecution(IProgramExecution<STE, SE> programExecution) {
        Stack current = new Stack();
        boolean canTranslate = false;
        for (ITranslator<?, ?, ?, ?, ?, ?> trans : this.mTranslationSequence) {
            current.push(trans);
            if (!trans.getSourceTraceElementClass().isAssignableFrom(programExecution.getTraceElementClass()) || !trans.getSourceExpressionClass().isAssignableFrom(programExecution.getExpressionClass())) continue;
            canTranslate = true;
        }
        if (!canTranslate) {
            throw new IllegalArgumentException("You cannot translate " + programExecution + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)current.peek()).getSourceTraceElementClass().isAssignableFrom(programExecution.getTraceElementClass()) || !((ITranslator)current.peek()).getSourceExpressionClass().isAssignableFrom(programExecution.getExpressionClass())) {
            throw new IllegalArgumentException("You cannot translate " + programExecution + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return this.translateProgramExecution(current, programExecution);
    }

    private <STE, TTE, SE, TE> IProgramExecution<TTE, TE> translateProgramExecution(Stack<ITranslator<?, ?, ?, ?, ?, ?>> remaining, IProgramExecution<STE, SE> programExecution) {
        if (remaining.isEmpty()) {
            return programExecution;
        }
        ITranslator<?, ?, ?, ?, ?, ?> translator = remaining.pop();
        IProgramExecution translated = translator.translateProgramExecution(programExecution);
        return this.translateProgramExecution(remaining, translated);
    }

    public <SE> IProgramExecution.ProgramState<?> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        Stack current = new Stack();
        boolean canTranslate = false;
        for (ITranslator<?, ?, ?, ?, ?, ?> trans : this.mTranslationSequence) {
            current.push(trans);
            canTranslate = true;
        }
        if (!canTranslate) {
            throw new IllegalArgumentException("You cannot translate " + programState + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        return this.translateProgramState(current, programState);
    }

    private <SE, TE> IProgramExecution.ProgramState<TE> translateProgramState(Stack<ITranslator<?, ?, ?, ?, ?, ?>> remaining, IProgramExecution.ProgramState<SE> programState) {
        if (remaining.isEmpty()) {
            return programState;
        }
        ITranslator<?, ?, ?, ?, ?, ?> translator = remaining.pop();
        IProgramExecution.ProgramState translated = translator.translateProgramState(programState);
        return this.translateProgramState(remaining, translated);
    }

    public <SE> String translateProgramStateToString(IProgramExecution.ProgramState<SE> programState) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?>> current = this.prepareTranslatorStackAndCheckSourceExpression(programState.getClassOfExpression());
        ITranslator last = (ITranslator)current.firstElement();
        return ModelTranslationContainer.translateProgramStateToString(this.translateProgramState(current, programState), last);
    }

    private static <TE> String translateProgramStateToString(IProgramExecution.ProgramState<TE> translateProgramState, ITranslator<?, ?, ?, ?, ?, ?> trans) {
        ITranslator<?, ?, ?, ?, ?, ?> last = trans;
        return translateProgramState.toString(x -> last.targetExpressionToString(x));
    }

    public <STE, SE> IBacktranslatedCFG<?, ?> translateCFG(IBacktranslatedCFG<?, STE> cfg) {
        Stack current = new Stack();
        boolean canTranslate = false;
        for (ITranslator<?, ?, ?, ?, ?, ?> trans : this.mTranslationSequence) {
            current.push(trans);
            if (!trans.getSourceTraceElementClass().isAssignableFrom(cfg.getTraceElementClass())) continue;
            canTranslate = true;
        }
        if (!canTranslate) {
            throw new IllegalArgumentException("You cannot translate " + cfg + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)current.peek()).getSourceTraceElementClass().isAssignableFrom(cfg.getTraceElementClass())) {
            throw new IllegalArgumentException("You cannot translate " + cfg + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return this.translateCFG(current, cfg);
    }

    private <STE, TTE, SE, TE, SVL, TVL> IBacktranslatedCFG<TVL, TTE> translateCFG(Stack<ITranslator<?, ?, ?, ?, ?, ?>> remaining, IBacktranslatedCFG<SVL, STE> cfg) {
        if (remaining.isEmpty()) {
            return cfg;
        }
        ITranslator<?, ?, ?, ?, ?, ?> translator = remaining.pop();
        IBacktranslatedCFG translated = translator.translateCFG(cfg);
        return this.translateCFG(remaining, translated);
    }

    public IBacktranslationService getTranslationServiceCopy() {
        return new ModelTranslationContainer(this);
    }

    public String toString() {
        return CoreUtil.join(this.mTranslationSequence, (String)",");
    }
}

